/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountAddress;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountMember;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AccountOrganization;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Account")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"externalReferenceCode", "name"})
@XmlRootElement(name="Account")
public class Account
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountAddress[] accountAddresses;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountMember[] accountMembers;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected AccountOrganization[] accountOrganizations;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean active;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, ?> customFields;
    @GraphQLField(description="The account's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The account's creation date.") Date dateCreated;
    @GraphQLField(description="The account's most recent modification date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The account's most recent modification date.") Date dateModified;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long defaultBillingAccountAddressId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long defaultShippingAccountAddressId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] emailAddresses;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long logoId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String logoURL;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean root;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String taxId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer type;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.account.dto.v1_0.Account", name="x-class-name")
    public String xClassName;

    public static Account toDTO(String json) {
        return (Account)ObjectMapperUtil.readValue(Account.class, (String)json);
    }

    @Schema
    @Valid
    public AccountAddress[] getAccountAddresses() {
        return this.accountAddresses;
    }

    public void setAccountAddresses(AccountAddress[] accountAddresses) {
        this.accountAddresses = accountAddresses;
    }

    @JsonIgnore
    public void setAccountAddresses(UnsafeSupplier<AccountAddress[], Exception> accountAddressesUnsafeSupplier) {
        try {
            this.accountAddresses = (AccountAddress[])accountAddressesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public AccountMember[] getAccountMembers() {
        return this.accountMembers;
    }

    public void setAccountMembers(AccountMember[] accountMembers) {
        this.accountMembers = accountMembers;
    }

    @JsonIgnore
    public void setAccountMembers(UnsafeSupplier<AccountMember[], Exception> accountMembersUnsafeSupplier) {
        try {
            this.accountMembers = (AccountMember[])accountMembersUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public AccountOrganization[] getAccountOrganizations() {
        return this.accountOrganizations;
    }

    public void setAccountOrganizations(AccountOrganization[] accountOrganizations) {
        this.accountOrganizations = accountOrganizations;
    }

    @JsonIgnore
    public void setAccountOrganizations(UnsafeSupplier<AccountOrganization[], Exception> accountOrganizationsUnsafeSupplier) {
        try {
            this.accountOrganizations = (AccountOrganization[])accountOrganizationsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @JsonIgnore
    public void setActive(UnsafeSupplier<Boolean, Exception> activeUnsafeSupplier) {
        try {
            this.active = (Boolean)activeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public Map<String, ?> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, ?> customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<Map<String, ?>, Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (Map)customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The account's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The account's most recent modification date.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema
    public @DecimalMin(value="0") Long getDefaultBillingAccountAddressId() {
        return this.defaultBillingAccountAddressId;
    }

    public void setDefaultBillingAccountAddressId(Long defaultBillingAccountAddressId) {
        this.defaultBillingAccountAddressId = defaultBillingAccountAddressId;
    }

    @JsonIgnore
    public void setDefaultBillingAccountAddressId(UnsafeSupplier<Long, Exception> defaultBillingAccountAddressIdUnsafeSupplier) {
        try {
            this.defaultBillingAccountAddressId = (Long)defaultBillingAccountAddressIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema
    public @DecimalMin(value="0") Long getDefaultShippingAccountAddressId() {
        return this.defaultShippingAccountAddressId;
    }

    public void setDefaultShippingAccountAddressId(Long defaultShippingAccountAddressId) {
        this.defaultShippingAccountAddressId = defaultShippingAccountAddressId;
    }

    @JsonIgnore
    public void setDefaultShippingAccountAddressId(UnsafeSupplier<Long, Exception> defaultShippingAccountAddressIdUnsafeSupplier) {
        try {
            this.defaultShippingAccountAddressId = (Long)defaultShippingAccountAddressIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String[] getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String[] emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @JsonIgnore
    public void setEmailAddresses(UnsafeSupplier<String[], Exception> emailAddressesUnsafeSupplier) {
        try {
            this.emailAddresses = (String[])emailAddressesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema
    public @DecimalMin(value="0") Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMin(value="0")
    @Schema
    public @DecimalMin(value="0") Long getLogoId() {
        return this.logoId;
    }

    public void setLogoId(Long logoId) {
        this.logoId = logoId;
    }

    @JsonIgnore
    public void setLogoId(UnsafeSupplier<Long, Exception> logoIdUnsafeSupplier) {
        try {
            this.logoId = (Long)logoIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getLogoURL() {
        return this.logoURL;
    }

    public void setLogoURL(String logoURL) {
        this.logoURL = logoURL;
    }

    @JsonIgnore
    public void setLogoURL(UnsafeSupplier<String, Exception> logoURLUnsafeSupplier) {
        try {
            this.logoURL = (String)logoURLUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Boolean getRoot() {
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    @JsonIgnore
    public void setRoot(UnsafeSupplier<Boolean, Exception> rootUnsafeSupplier) {
        try {
            this.root = (Boolean)rootUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    @JsonIgnore
    public void setTaxId(UnsafeSupplier<String, Exception> taxIdUnsafeSupplier) {
        try {
            this.taxId = (String)taxIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DecimalMax(value="2")
    @DecimalMin(value="0")
    @Schema
    public @DecimalMax(value="2") @DecimalMin(value="0") Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Integer, Exception> typeUnsafeSupplier) {
        try {
            this.type = (Integer)typeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Account)) {
            return false;
        }
        Account account = (Account)object;
        return Objects.equals(this.toString(), account.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.accountAddresses != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountAddresses\": ");
            sb.append("[");
            for (i = 0; i < this.accountAddresses.length; ++i) {
                sb.append(String.valueOf(this.accountAddresses[i]));
                if (i + 1 >= this.accountAddresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.accountMembers != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountMembers\": ");
            sb.append("[");
            for (i = 0; i < this.accountMembers.length; ++i) {
                sb.append(String.valueOf(this.accountMembers[i]));
                if (i + 1 >= this.accountMembers.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.accountOrganizations != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountOrganizations\": ");
            sb.append("[");
            for (i = 0; i < this.accountOrganizations.length; ++i) {
                sb.append(String.valueOf(this.accountOrganizations[i]));
                if (i + 1 >= this.accountOrganizations.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.active != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append((Object)this.active);
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append(Account._toJSON(this.customFields));
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.defaultBillingAccountAddressId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultBillingAccountAddressId\": ");
            sb.append((Object)this.defaultBillingAccountAddressId);
        }
        if (this.defaultShippingAccountAddressId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultShippingAccountAddressId\": ");
            sb.append((Object)this.defaultShippingAccountAddressId);
        }
        if (this.emailAddresses != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"emailAddresses\": ");
            sb.append("[");
            for (i = 0; i < this.emailAddresses.length; ++i) {
                sb.append("\"");
                sb.append(Account._escape(this.emailAddresses[i]));
                sb.append("\"");
                if (i + 1 >= this.emailAddresses.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Account._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.logoId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoId\": ");
            sb.append((Object)this.logoId);
        }
        if (this.logoURL != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoURL\": ");
            sb.append("\"");
            sb.append(Account._escape(this.logoURL));
            sb.append("\"");
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Account._escape(this.name));
            sb.append("\"");
        }
        if (this.root != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"root\": ");
            sb.append((Object)this.root);
        }
        if (this.taxId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxId\": ");
            sb.append("\"");
            sb.append(Account._escape(this.taxId));
            sb.append("\"");
        }
        if (this.type != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append((Object)this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            if (Account._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Account._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(value);
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

