/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.account.client.resource.v1_0;

import com.liferay.headless.commerce.admin.account.client.dto.v1_0.AccountOrganization;
import com.liferay.headless.commerce.admin.account.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.account.client.pagination.Page;
import com.liferay.headless.commerce.admin.account.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.account.client.problem.Problem;
import com.liferay.headless.commerce.admin.account.client.serdes.v1_0.AccountOrganizationSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface AccountOrganizationResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<AccountOrganization> getAccountByExternalReferenceCodeAccountOrganizationsPage(String var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getAccountByExternalReferenceCodeAccountOrganizationsPageHttpResponse(String var1, Pagination var2) throws Exception;

    public AccountOrganization postAccountByExternalReferenceCodeAccountOrganization(String var1, AccountOrganization var2) throws Exception;

    public HttpInvoker.HttpResponse postAccountByExternalReferenceCodeAccountOrganizationHttpResponse(String var1, AccountOrganization var2) throws Exception;

    public void deleteAccountByExternalReferenceCodeAccountOrganization(String var1, Long var2) throws Exception;

    public HttpInvoker.HttpResponse deleteAccountByExternalReferenceCodeAccountOrganizationHttpResponse(String var1, Long var2) throws Exception;

    public AccountOrganization getAccountByExternalReferenceCodeAccountOrganization(String var1, Long var2) throws Exception;

    public HttpInvoker.HttpResponse getAccountByExternalReferenceCodeAccountOrganizationHttpResponse(String var1, Long var2) throws Exception;

    public Page<AccountOrganization> getAccountIdAccountOrganizationsPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getAccountIdAccountOrganizationsPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public AccountOrganization postAccountIdAccountOrganization(Long var1, AccountOrganization var2) throws Exception;

    public HttpInvoker.HttpResponse postAccountIdAccountOrganizationHttpResponse(Long var1, AccountOrganization var2) throws Exception;

    public void postAccountIdAccountOrganizationBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postAccountIdAccountOrganizationBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public void deleteAccountIdAccountOrganization(Long var1, Long var2) throws Exception;

    public HttpInvoker.HttpResponse deleteAccountIdAccountOrganizationHttpResponse(Long var1, Long var2) throws Exception;

    public AccountOrganization getAccountIdAccountOrganization(Long var1, Long var2) throws Exception;

    public HttpInvoker.HttpResponse getAccountIdAccountOrganizationHttpResponse(Long var1, Long var2) throws Exception;

    public static class AccountOrganizationResourceImpl
    implements AccountOrganizationResource {
        private static final Logger _logger = Logger.getLogger(AccountOrganizationResource.class.getName());
        private Builder _builder;

        @Override
        public Page<AccountOrganization> getAccountByExternalReferenceCodeAccountOrganizationsPage(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getAccountByExternalReferenceCodeAccountOrganizationsPageHttpResponse(externalReferenceCode, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, AccountOrganizationSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getAccountByExternalReferenceCodeAccountOrganizationsPageHttpResponse(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/by-externalReferenceCode/{externalReferenceCode}/accountOrganizations");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public AccountOrganization postAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, AccountOrganization accountOrganization) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postAccountByExternalReferenceCodeAccountOrganizationHttpResponse(externalReferenceCode, accountOrganization);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return AccountOrganizationSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postAccountByExternalReferenceCodeAccountOrganizationHttpResponse(String externalReferenceCode, AccountOrganization accountOrganization) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(accountOrganization.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/by-externalReferenceCode/{externalReferenceCode}/accountOrganizations");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, Long organizationId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteAccountByExternalReferenceCodeAccountOrganizationHttpResponse(externalReferenceCode, organizationId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteAccountByExternalReferenceCodeAccountOrganizationHttpResponse(String externalReferenceCode, Long organizationId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/by-externalReferenceCode/{externalReferenceCode}/accountOrganizations/{organizationId}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.path("organizationId", organizationId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public AccountOrganization getAccountByExternalReferenceCodeAccountOrganization(String externalReferenceCode, Long organizationId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getAccountByExternalReferenceCodeAccountOrganizationHttpResponse(externalReferenceCode, organizationId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return AccountOrganizationSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getAccountByExternalReferenceCodeAccountOrganizationHttpResponse(String externalReferenceCode, Long organizationId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/by-externalReferenceCode/{externalReferenceCode}/accountOrganizations/{organizationId}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.path("organizationId", organizationId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<AccountOrganization> getAccountIdAccountOrganizationsPage(Long id, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getAccountIdAccountOrganizationsPageHttpResponse(id, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, AccountOrganizationSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getAccountIdAccountOrganizationsPageHttpResponse(Long id, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/{id}/accountOrganizations");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public AccountOrganization postAccountIdAccountOrganization(Long id, AccountOrganization accountOrganization) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postAccountIdAccountOrganizationHttpResponse(id, accountOrganization);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return AccountOrganizationSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postAccountIdAccountOrganizationHttpResponse(Long id, AccountOrganization accountOrganization) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(accountOrganization.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/{id}/accountOrganizations");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postAccountIdAccountOrganizationBatch(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postAccountIdAccountOrganizationBatchHttpResponse(id, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postAccountIdAccountOrganizationBatchHttpResponse(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/{id}/accountOrganizations/batch");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteAccountIdAccountOrganization(Long id, Long organizationId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteAccountIdAccountOrganizationHttpResponse(id, organizationId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteAccountIdAccountOrganizationHttpResponse(Long id, Long organizationId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/{id}/accountOrganizations/{organizationId}");
            httpInvoker.path("id", id);
            httpInvoker.path("organizationId", organizationId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public AccountOrganization getAccountIdAccountOrganization(Long id, Long organizationId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getAccountIdAccountOrganizationHttpResponse(id, organizationId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return AccountOrganizationSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getAccountIdAccountOrganizationHttpResponse(Long id, Long organizationId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-account/v1.0/accounts/{id}/accountOrganizations/{organizationId}");
            httpInvoker.path("id", id);
            httpInvoker.path("organizationId", organizationId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private AccountOrganizationResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public AccountOrganizationResource build() {
            return new AccountOrganizationResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

