/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.client.serdes.v1_0;

import com.liferay.headless.commerce.admin.catalog.client.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.client.json.BaseJSONParser;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class AttachmentSerDes {
    public static Attachment toDTO(String json) {
        AttachmentJSONParser attachmentJSONParser = new AttachmentJSONParser();
        return (Attachment)attachmentJSONParser.parseToDTO(json);
    }

    public static Attachment[] toDTOs(String json) {
        AttachmentJSONParser attachmentJSONParser = new AttachmentJSONParser();
        return (Attachment[])attachmentJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Attachment attachment) {
        if (attachment == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (attachment.getAttachment() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"attachment\": ");
            sb.append("\"");
            sb.append(AttachmentSerDes._escape(attachment.getAttachment()));
            sb.append("\"");
        }
        if (attachment.getDisplayDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(attachment.getDisplayDate()));
            sb.append("\"");
        }
        if (attachment.getExpirationDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"expirationDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(attachment.getExpirationDate()));
            sb.append("\"");
        }
        if (attachment.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(AttachmentSerDes._escape(attachment.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (attachment.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(attachment.getId());
        }
        if (attachment.getNeverExpire() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"neverExpire\": ");
            sb.append(attachment.getNeverExpire());
        }
        if (attachment.getOptions() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"options\": ");
            sb.append(AttachmentSerDes._toJSON(attachment.getOptions()));
        }
        if (attachment.getPriority() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"priority\": ");
            sb.append(attachment.getPriority());
        }
        if (attachment.getSrc() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"src\": ");
            sb.append("\"");
            sb.append(AttachmentSerDes._escape(attachment.getSrc()));
            sb.append("\"");
        }
        if (attachment.getTitle() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append(AttachmentSerDes._toJSON(attachment.getTitle()));
        }
        if (attachment.getType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append(attachment.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        AttachmentJSONParser attachmentJSONParser = new AttachmentJSONParser();
        return attachmentJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (attachment.getAttachment() == null) {
            map.put("attachment", null);
        } else {
            map.put("attachment", String.valueOf(attachment.getAttachment()));
        }
        if (attachment.getDisplayDate() == null) {
            map.put("displayDate", null);
        } else {
            map.put("displayDate", liferayToJSONDateFormat.format(attachment.getDisplayDate()));
        }
        if (attachment.getExpirationDate() == null) {
            map.put("expirationDate", null);
        } else {
            map.put("expirationDate", liferayToJSONDateFormat.format(attachment.getExpirationDate()));
        }
        if (attachment.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(attachment.getExternalReferenceCode()));
        }
        if (attachment.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(attachment.getId()));
        }
        if (attachment.getNeverExpire() == null) {
            map.put("neverExpire", null);
        } else {
            map.put("neverExpire", String.valueOf(attachment.getNeverExpire()));
        }
        if (attachment.getOptions() == null) {
            map.put("options", null);
        } else {
            map.put("options", String.valueOf(attachment.getOptions()));
        }
        if (attachment.getPriority() == null) {
            map.put("priority", null);
        } else {
            map.put("priority", String.valueOf(attachment.getPriority()));
        }
        if (attachment.getSrc() == null) {
            map.put("src", null);
        } else {
            map.put("src", String.valueOf(attachment.getSrc()));
        }
        if (attachment.getTitle() == null) {
            map.put("title", null);
        } else {
            map.put("title", String.valueOf(attachment.getTitle()));
        }
        if (attachment.getType() == null) {
            map.put("type", null);
        } else {
            map.put("type", String.valueOf(attachment.getType()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(AttachmentSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(AttachmentSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(AttachmentSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class AttachmentJSONParser
    extends BaseJSONParser<Attachment> {
        @Override
        protected Attachment createDTO() {
            return new Attachment();
        }

        protected Attachment[] createDTOArray(int size) {
            return new Attachment[size];
        }

        @Override
        protected void setField(Attachment attachment, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "attachment")) {
                if (jsonParserFieldValue != null) {
                    attachment.setAttachment((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "displayDate")) {
                if (jsonParserFieldValue != null) {
                    attachment.setDisplayDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "expirationDate")) {
                if (jsonParserFieldValue != null) {
                    attachment.setExpirationDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    attachment.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    attachment.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "neverExpire")) {
                if (jsonParserFieldValue != null) {
                    attachment.setNeverExpire((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "options")) {
                if (jsonParserFieldValue != null) {
                    attachment.setOptions(AttachmentSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "priority")) {
                if (jsonParserFieldValue != null) {
                    attachment.setPriority(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "src")) {
                if (jsonParserFieldValue != null) {
                    attachment.setSrc((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "title")) {
                if (jsonParserFieldValue != null) {
                    attachment.setTitle(AttachmentSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "type") && jsonParserFieldValue != null) {
                attachment.setType(Integer.valueOf((String)jsonParserFieldValue));
            }
        }
    }
}

