/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.client.resource.v1_0;

import com.liferay.headless.commerce.admin.catalog.client.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.catalog.client.pagination.Page;
import com.liferay.headless.commerce.admin.catalog.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.catalog.client.problem.Problem;
import com.liferay.headless.commerce.admin.catalog.client.serdes.v1_0.CatalogSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface CatalogResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteCatalogByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse deleteCatalogByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public Catalog getCatalogByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse getCatalogByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public void patchCatalogByExternalReferenceCode(String var1, Catalog var2) throws Exception;

    public HttpInvoker.HttpResponse patchCatalogByExternalReferenceCodeHttpResponse(String var1, Catalog var2) throws Exception;

    public void deleteCatalog(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteCatalogHttpResponse(Long var1) throws Exception;

    public void deleteCatalogBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteCatalogBatchHttpResponse(String var1, Object var2) throws Exception;

    public Catalog getCatalog(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getCatalogHttpResponse(Long var1) throws Exception;

    public void patchCatalog(Long var1, Catalog var2) throws Exception;

    public HttpInvoker.HttpResponse patchCatalogHttpResponse(Long var1, Catalog var2) throws Exception;

    public Page<Catalog> getCatalogsPage(String var1, String var2, Pagination var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse getCatalogsPageHttpResponse(String var1, String var2, Pagination var3, String var4) throws Exception;

    public void postCatalogsPageExportBatch(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    public HttpInvoker.HttpResponse postCatalogsPageExportBatchHttpResponse(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    public Catalog postCatalog(Catalog var1) throws Exception;

    public HttpInvoker.HttpResponse postCatalogHttpResponse(Catalog var1) throws Exception;

    public void postCatalogBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse postCatalogBatchHttpResponse(String var1, Object var2) throws Exception;

    public Catalog getProductByExternalReferenceCodeCatalog(String var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getProductByExternalReferenceCodeCatalogHttpResponse(String var1, Pagination var2) throws Exception;

    public Catalog getProductIdCatalog(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getProductIdCatalogHttpResponse(Long var1, Pagination var2) throws Exception;

    public static class CatalogResourceImpl
    implements CatalogResource {
        private static final Logger _logger = Logger.getLogger(CatalogResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteCatalogByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteCatalogByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Catalog getCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getCatalogByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return CatalogSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getCatalogByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void patchCatalogByExternalReferenceCode(String externalReferenceCode, Catalog catalog) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchCatalogByExternalReferenceCodeHttpResponse(externalReferenceCode, catalog);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse patchCatalogByExternalReferenceCodeHttpResponse(String externalReferenceCode, Catalog catalog) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(catalog.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteCatalog(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteCatalogHttpResponse(id);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteCatalogHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/{id}");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteCatalogBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteCatalogBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteCatalogBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Catalog getCatalog(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getCatalogHttpResponse(id);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return CatalogSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getCatalogHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/{id}");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void patchCatalog(Long id, Catalog catalog) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchCatalogHttpResponse(id, catalog);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse patchCatalogHttpResponse(Long id, Catalog catalog) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(catalog.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalog/{id}");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<Catalog> getCatalogsPage(String search, String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getCatalogsPageHttpResponse(search, filterString, pagination, sortString);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, CatalogSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getCatalogsPageHttpResponse(String search, String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (filterString != null) {
                httpInvoker.parameter("filter", filterString);
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalogs");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postCatalogsPageExportBatch(String search, String filterString, String sortString, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postCatalogsPageExportBatchHttpResponse(search, filterString, sortString, callbackURL, contentType, fieldNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postCatalogsPageExportBatchHttpResponse(String search, String filterString, String sortString, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (filterString != null) {
                httpInvoker.parameter("filter", filterString);
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (contentType != null) {
                httpInvoker.parameter("contentType", String.valueOf(contentType));
            }
            if (fieldNames != null) {
                httpInvoker.parameter("fieldNames", String.valueOf(fieldNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalogs/export-batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Catalog postCatalog(Catalog catalog) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postCatalogHttpResponse(catalog);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return CatalogSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postCatalogHttpResponse(Catalog catalog) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(catalog.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalogs");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postCatalogBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postCatalogBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postCatalogBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/catalogs/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Catalog getProductByExternalReferenceCodeCatalog(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getProductByExternalReferenceCodeCatalogHttpResponse(externalReferenceCode, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return CatalogSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getProductByExternalReferenceCodeCatalogHttpResponse(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/products/by-externalReferenceCode/{externalReferenceCode}/catalog");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Catalog getProductIdCatalog(Long id, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getProductIdCatalogHttpResponse(id, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return CatalogSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getProductIdCatalogHttpResponse(Long id, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-catalog/v1.0/products/{id}/catalog");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private CatalogResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public CatalogResource build() {
            return new CatalogResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

