/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.client.resource.v1_0;

import com.liferay.headless.commerce.admin.catalog.client.dto.v1_0.OptionValue;
import com.liferay.headless.commerce.admin.catalog.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.catalog.client.pagination.Page;
import com.liferay.headless.commerce.admin.catalog.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.catalog.client.problem.Problem;
import com.liferay.headless.commerce.admin.catalog.client.serdes.v1_0.OptionValueSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface OptionValueResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteOptionValueByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse deleteOptionValueByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public OptionValue getOptionValueByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse getOptionValueByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public void patchOptionValueByExternalReferenceCode(String var1, OptionValue var2) throws Exception;

    public HttpInvoker.HttpResponse patchOptionValueByExternalReferenceCodeHttpResponse(String var1, OptionValue var2) throws Exception;

    public void deleteOptionValue(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteOptionValueHttpResponse(Long var1) throws Exception;

    public void deleteOptionValueBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse deleteOptionValueBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public OptionValue getOptionValue(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getOptionValueHttpResponse(Long var1) throws Exception;

    public void patchOptionValue(Long var1, OptionValue var2) throws Exception;

    public HttpInvoker.HttpResponse patchOptionValueHttpResponse(Long var1, OptionValue var2) throws Exception;

    public Page<OptionValue> getOptionByExternalReferenceCodeOptionValuesPage(String var1, String var2, Pagination var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse getOptionByExternalReferenceCodeOptionValuesPageHttpResponse(String var1, String var2, Pagination var3, String var4) throws Exception;

    public OptionValue postOptionByExternalReferenceCodeOptionValue(String var1, OptionValue var2) throws Exception;

    public HttpInvoker.HttpResponse postOptionByExternalReferenceCodeOptionValueHttpResponse(String var1, OptionValue var2) throws Exception;

    public Page<OptionValue> getOptionIdOptionValuesPage(Long var1, String var2, Pagination var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse getOptionIdOptionValuesPageHttpResponse(Long var1, String var2, Pagination var3, String var4) throws Exception;

    public OptionValue postOptionIdOptionValue(Long var1, OptionValue var2) throws Exception;

    public HttpInvoker.HttpResponse postOptionIdOptionValueHttpResponse(Long var1, OptionValue var2) throws Exception;

    public void postOptionIdOptionValueBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse postOptionIdOptionValueBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public static class OptionValueResourceImpl
    implements OptionValueResource {
        private static final Logger _logger = Logger.getLogger(OptionValueResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteOptionValueByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteOptionValueByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteOptionValueByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public OptionValue getOptionValueByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getOptionValueByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return OptionValueSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getOptionValueByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void patchOptionValueByExternalReferenceCode(String externalReferenceCode, OptionValue optionValue) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchOptionValueByExternalReferenceCodeHttpResponse(externalReferenceCode, optionValue);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse patchOptionValueByExternalReferenceCodeHttpResponse(String externalReferenceCode, OptionValue optionValue) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(optionValue.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteOptionValue(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteOptionValueHttpResponse(id);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteOptionValueHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/{id}");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteOptionValueBatch(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteOptionValueBatchHttpResponse(id, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteOptionValueBatchHttpResponse(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/{id}/batch");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public OptionValue getOptionValue(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getOptionValueHttpResponse(id);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return OptionValueSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getOptionValueHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/{id}");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void patchOptionValue(Long id, OptionValue optionValue) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchOptionValueHttpResponse(id, optionValue);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse patchOptionValueHttpResponse(Long id, OptionValue optionValue) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(optionValue.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/optionValues/{id}");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<OptionValue> getOptionByExternalReferenceCodeOptionValuesPage(String externalReferenceCode, String search, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getOptionByExternalReferenceCodeOptionValuesPageHttpResponse(externalReferenceCode, search, pagination, sortString);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, OptionValueSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getOptionByExternalReferenceCodeOptionValuesPageHttpResponse(String externalReferenceCode, String search, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/options/by-externalReferenceCode/{externalReferenceCode}/optionValues");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public OptionValue postOptionByExternalReferenceCodeOptionValue(String externalReferenceCode, OptionValue optionValue) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postOptionByExternalReferenceCodeOptionValueHttpResponse(externalReferenceCode, optionValue);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return OptionValueSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postOptionByExternalReferenceCodeOptionValueHttpResponse(String externalReferenceCode, OptionValue optionValue) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(optionValue.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/options/by-externalReferenceCode/{externalReferenceCode}/optionValues");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<OptionValue> getOptionIdOptionValuesPage(Long id, String search, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getOptionIdOptionValuesPageHttpResponse(id, search, pagination, sortString);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, OptionValueSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getOptionIdOptionValuesPageHttpResponse(Long id, String search, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/options/{id}/optionValues");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public OptionValue postOptionIdOptionValue(Long id, OptionValue optionValue) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postOptionIdOptionValueHttpResponse(id, optionValue);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return OptionValueSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postOptionIdOptionValueHttpResponse(Long id, OptionValue optionValue) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(optionValue.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/options/{id}/optionValues");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postOptionIdOptionValueBatch(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postOptionIdOptionValueBatchHttpResponse(id, callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postOptionIdOptionValueBatchHttpResponse(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-catalog/v1.0/options/{id}/optionValues/batch");
            httpInvoker.path("id", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private OptionValueResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public OptionValueResource build() {
            return new OptionValueResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

