/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.channel.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.CommerceShippingMethodService;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionService;
import com.liferay.commerce.shipping.engine.fixed.util.comparator.CommerceShippingFixedOptionPriorityComparator;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.commerce.util.comparator.CommerceShippingMethodPriorityComparator;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.ShippingMethod;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.ShippingOption;
import com.liferay.headless.commerce.admin.channel.internal.resource.v1_0.BaseShippingMethodResourceImpl;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ShippingMethodResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/shipping-method.properties"}, scope=ServiceScope.PROTOTYPE, service={ShippingMethodResource.class})
public class ShippingMethodResourceImpl
extends BaseShippingMethodResourceImpl {
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingFixedOptionService _commerceShippingFixedOptionService;
    @Reference
    private CommerceShippingMethodService _commerceShippingMethodService;

    @Override
    public Page<ShippingMethod> getChannelShippingMethodsPage(Long channelId, Pagination pagination) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.getCommerceChannel(channelId.longValue());
        return Page.of((Collection)TransformUtil.transform((Collection)this._commerceShippingMethodService.getCommerceShippingMethods(commerceChannel.getGroupId(), -1, -1, (OrderByComparator)new CommerceShippingMethodPriorityComparator()), this::_toShippingMethod), (Pagination)pagination, (long)this._commerceShippingMethodService.getCommerceShippingMethodsCount(commerceChannel.getGroupId()));
    }

    private ShippingOption[] _getShippingOptions(long shippingMethodId) throws PortalException {
        return (ShippingOption[])TransformUtil.transformToArray((Collection)this._commerceShippingFixedOptionService.getCommerceShippingFixedOptions(shippingMethodId, -1, -1, (OrderByComparator)new CommerceShippingFixedOptionPriorityComparator()), commerceShippingFixedOption -> new ShippingOption((CommerceShippingFixedOption)commerceShippingFixedOption){
            final /* synthetic */ CommerceShippingFixedOption val$commerceShippingFixedOption;
            {
                this.val$commerceShippingFixedOption = commerceShippingFixedOption;
                this.description = LanguageUtils.getLanguageIdMap((Map)this.val$commerceShippingFixedOption.getDescriptionMap());
                this.id = this.val$commerceShippingFixedOption.getCommerceShippingFixedOptionId();
                this.name = LanguageUtils.getLanguageIdMap((Map)this.val$commerceShippingFixedOption.getNameMap());
                this.priority = this.val$commerceShippingFixedOption.getPriority();
            }
        }, ShippingOption.class);
    }

    private ShippingMethod _toShippingMethod(final CommerceShippingMethod commerceShippingMethod) throws PortalException {
        final Map commerceShippingEngines = this._commerceShippingEngineRegistry.getCommerceShippingEngines();
        return new ShippingMethod(){
            {
                this.active = commerceShippingMethod.isActive();
                this.engineKey = commerceShippingMethod.getEngineKey();
                this.id = commerceShippingMethod.getCommerceShippingMethodId();
                this.priority = commerceShippingMethod.getPriority();
                this.shippingOptions = ShippingMethodResourceImpl.this._getShippingOptions(commerceShippingMethod.getCommerceShippingMethodId());
                this.setDescription(() -> {
                    if (Validator.isNotNull((Object)commerceShippingMethod.getDescriptionMap())) {
                        return LanguageUtils.getLanguageIdMap((Map)commerceShippingMethod.getNameMap());
                    }
                    CommerceShippingEngine commerceShippingEngine = (CommerceShippingEngine)commerceShippingEngines.get(commerceShippingMethod.getEngineKey());
                    return HashMapBuilder.put((Object)ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLanguageId(), (Object)commerceShippingEngine.getDescription(ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLocale())).build();
                });
                this.setName(() -> {
                    if (Validator.isNotNull((Object)commerceShippingMethod.getNameMap())) {
                        return LanguageUtils.getLanguageIdMap((Map)commerceShippingMethod.getNameMap());
                    }
                    CommerceShippingEngine commerceShippingEngine = (CommerceShippingEngine)commerceShippingEngines.get(commerceShippingMethod.getEngineKey());
                    return HashMapBuilder.put((Object)ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLanguageId(), (Object)commerceShippingEngine.getName(ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLocale())).build();
                });
            }
        };
    }
}

