/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.channel.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.CPTaxCategoryService;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.TaxCategory;
import com.liferay.headless.commerce.admin.channel.internal.dto.v1_0.converter.TaxCategoryDTOConverter;
import com.liferay.headless.commerce.admin.channel.internal.resource.v1_0.BaseTaxCategoryResourceImpl;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.TaxCategoryResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/tax-category.properties"}, scope=ServiceScope.PROTOTYPE, service={TaxCategoryResource.class})
public class TaxCategoryResourceImpl
extends BaseTaxCategoryResourceImpl {
    @Reference
    private CPTaxCategoryService _cpTaxCategoryService;
    @Reference
    private TaxCategoryDTOConverter _taxCategoryDTOConverter;

    @Override
    public Page<TaxCategory> getTaxCategoriesPage(String search, Pagination pagination) throws Exception {
        ArrayList<TaxCategory> taxCategories = new ArrayList<TaxCategory>();
        List cpTaxCategories = this._cpTaxCategoryService.findCPTaxCategoriesByCompanyId(this.contextCompany.getCompanyId(), search, pagination.getStartPosition(), pagination.getEndPosition());
        for (CPTaxCategory cpTaxCategory : cpTaxCategories) {
            taxCategories.add(this._toTaxCategory(cpTaxCategory.getCPTaxCategoryId()));
        }
        int count = this._cpTaxCategoryService.countCPTaxCategoriesByCompanyId(this.contextCompany.getCompanyId(), search);
        return Page.of(taxCategories, (Pagination)pagination, (long)count);
    }

    @Override
    public TaxCategory getTaxCategory(Long id) throws Exception {
        CPTaxCategory cpTaxCategory = this._cpTaxCategoryService.getCPTaxCategory(id.longValue());
        return this._toTaxCategory(cpTaxCategory.getCPTaxCategoryId());
    }

    private TaxCategory _toTaxCategory(Long taxCategoryId) throws Exception {
        return this._taxCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)taxCategoryId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

