/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.inventory.internal.graphql.query.v1_0;

import com.liferay.headless.commerce.admin.inventory.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.inventory.dto.v1_0.WarehouseItem;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseItemResource;
import com.liferay.headless.commerce.admin.inventory.resource.v1_0.WarehouseResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<WarehouseResource> _warehouseResourceComponentServiceObjects;
    private static ComponentServiceObjects<WarehouseItemResource> _warehouseItemResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setWarehouseResourceComponentServiceObjects(ComponentServiceObjects<WarehouseResource> warehouseResourceComponentServiceObjects) {
        _warehouseResourceComponentServiceObjects = warehouseResourceComponentServiceObjects;
    }

    public static void setWarehouseItemResourceComponentServiceObjects(ComponentServiceObjects<WarehouseItemResource> warehouseItemResourceComponentServiceObjects) {
        _warehouseItemResourceComponentServiceObjects = warehouseItemResourceComponentServiceObjects;
    }

    @GraphQLField
    public Warehouse warehousByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (Warehouse)this._applyComponentServiceObjects(_warehouseResourceComponentServiceObjects, this::_populateResourceContext, warehouseResource -> warehouseResource.getWarehousByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField
    public Warehouse warehousId(@GraphQLName(value="id") Long id) throws Exception {
        return (Warehouse)this._applyComponentServiceObjects(_warehouseResourceComponentServiceObjects, this::_populateResourceContext, warehouseResource -> warehouseResource.getWarehousId(id));
    }

    @GraphQLField
    public WarehousePage warehouses(@GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (WarehousePage)this._applyComponentServiceObjects(_warehouseResourceComponentServiceObjects, this::_populateResourceContext, warehouseResource -> new WarehousePage(warehouseResource.getWarehousesPage(this._filterBiFunction.apply(warehouseResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(warehouseResource, sortsString))));
    }

    @GraphQLField
    public WarehouseItem warehouseItemByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (WarehouseItem)this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, this::_populateResourceContext, warehouseItemResource -> warehouseItemResource.getWarehouseItemByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField
    public WarehouseItem warehouseItem(@GraphQLName(value="id") Long id) throws Exception {
        return (WarehouseItem)this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, this::_populateResourceContext, warehouseItemResource -> warehouseItemResource.getWarehouseItem(id));
    }

    @GraphQLField
    public WarehouseItemPage warehousByExternalReferenceCodeWarehouseItems(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (WarehouseItemPage)this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, this::_populateResourceContext, warehouseItemResource -> new WarehouseItemPage(warehouseItemResource.getWarehousByExternalReferenceCodeWarehouseItemsPage(externalReferenceCode, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public WarehouseItemPage warehousIdWarehouseItems(@GraphQLName(value="id") Long id, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (WarehouseItemPage)this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, this::_populateResourceContext, warehouseItemResource -> new WarehouseItemPage(warehouseItemResource.getWarehousIdWarehouseItemsPage(id, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public WarehouseItemPage warehouseItemsUpdated(@GraphQLName(value="end") Date end, @GraphQLName(value="start") Date start, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (WarehouseItemPage)this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, this::_populateResourceContext, warehouseItemResource -> new WarehouseItemPage(warehouseItemResource.getWarehouseItemsUpdatedPage(end, start, Pagination.of((int)page, (int)pageSize))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(WarehouseResource warehouseResource) throws Exception {
        warehouseResource.setContextAcceptLanguage(this._acceptLanguage);
        warehouseResource.setContextCompany(this._company);
        warehouseResource.setContextHttpServletRequest(this._httpServletRequest);
        warehouseResource.setContextHttpServletResponse(this._httpServletResponse);
        warehouseResource.setContextUriInfo(this._uriInfo);
        warehouseResource.setContextUser(this._user);
        warehouseResource.setGroupLocalService(this._groupLocalService);
        warehouseResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(WarehouseItemResource warehouseItemResource) throws Exception {
        warehouseItemResource.setContextAcceptLanguage(this._acceptLanguage);
        warehouseItemResource.setContextCompany(this._company);
        warehouseItemResource.setContextHttpServletRequest(this._httpServletRequest);
        warehouseItemResource.setContextHttpServletResponse(this._httpServletResponse);
        warehouseItemResource.setContextUriInfo(this._uriInfo);
        warehouseItemResource.setContextUser(this._user);
        warehouseItemResource.setGroupLocalService(this._groupLocalService);
        warehouseItemResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="WarehouseItemPage")
    public class WarehouseItemPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<WarehouseItem> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public WarehouseItemPage(Page warehouseItemPage) {
            this.actions = warehouseItemPage.getActions();
            this.items = warehouseItemPage.getItems();
            this.lastPage = warehouseItemPage.getLastPage();
            this.page = warehouseItemPage.getPage();
            this.pageSize = warehouseItemPage.getPageSize();
            this.totalCount = warehouseItemPage.getTotalCount();
        }
    }

    @GraphQLName(value="WarehousePage")
    public class WarehousePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Warehouse> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public WarehousePage(Page warehousePage) {
            this.actions = warehousePage.getActions();
            this.items = warehousePage.getItems();
            this.lastPage = warehousePage.getLastPage();
            this.page = warehousePage.getPage();
            this.pageSize = warehousePage.getPageSize();
            this.totalCount = warehousePage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=WarehouseItem.class)
    public class GetWarehousByExternalReferenceCodeTypeExtension {
        private WarehouseItem _warehouseItem;

        public GetWarehousByExternalReferenceCodeTypeExtension(WarehouseItem warehouseItem) {
            this._warehouseItem = warehouseItem;
        }

        @GraphQLField
        public Warehouse warehousByExternalReferenceCode() throws Exception {
            return (Warehouse)Query.this._applyComponentServiceObjects(_warehouseResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), warehouseResource -> warehouseResource.getWarehousByExternalReferenceCode(this._warehouseItem.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=Warehouse.class)
    public class GetWarehousByExternalReferenceCodeWarehouseItemsPageTypeExtension {
        private Warehouse _warehouse;

        public GetWarehousByExternalReferenceCodeWarehouseItemsPageTypeExtension(Warehouse warehouse) {
            this._warehouse = warehouse;
        }

        @GraphQLField
        public WarehouseItemPage warehousByExternalReferenceCodeWarehouseItems(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (WarehouseItemPage)Query.this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), warehouseItemResource -> new WarehouseItemPage(warehouseItemResource.getWarehousByExternalReferenceCodeWarehouseItemsPage(this._warehouse.getExternalReferenceCode(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=Warehouse.class)
    public class GetWarehouseItemByExternalReferenceCodeTypeExtension {
        private Warehouse _warehouse;

        public GetWarehouseItemByExternalReferenceCodeTypeExtension(Warehouse warehouse) {
            this._warehouse = warehouse;
        }

        @GraphQLField
        public WarehouseItem itemByExternalReferenceCode() throws Exception {
            return (WarehouseItem)Query.this._applyComponentServiceObjects(_warehouseItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), warehouseItemResource -> warehouseItemResource.getWarehouseItemByExternalReferenceCode(this._warehouse.getExternalReferenceCode()));
        }
    }
}

