/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.batch.v1_0;

import com.liferay.batch.engine.BaseBatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.internal.helper.v1_0.OrderHelper;
import com.liferay.headless.commerce.admin.order.internal.helper.v1_0.OrderItemHelper;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"batch.engine.task.item.delegate.name=commerce-ml-order"}, service={BatchEngineTaskItemDelegate.class})
public class CommerceMLOrderBatchEngineTaskItemDelegate
extends BaseBatchEngineTaskItemDelegate<Order> {
    @Reference
    private OrderHelper _orderHelper;
    @Reference
    private OrderItemHelper _orderItemHelper;

    public Class<Order> getItemClass() {
        return Order.class;
    }

    public Page<Order> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        com.liferay.portal.vulcan.pagination.Pagination vulcanPagination = com.liferay.portal.vulcan.pagination.Pagination.of((int)pagination.getPage(), (int)pagination.getPageSize());
        com.liferay.portal.vulcan.pagination.Page<Order> ordersPage = this._orderHelper.getOrdersPage(this.contextCompany.getCompanyId(), filter, vulcanPagination, search, sorts, (UnsafeFunction<Document, Order, Exception>)((UnsafeFunction)document -> this._toOrder(GetterUtil.getLong((String)document.get("entryClassPK")))), false);
        return Page.of((Collection)ordersPage.getItems(), (Pagination)Pagination.of((int)((int)ordersPage.getPage()), (int)((int)ordersPage.getPageSize())), (long)ordersPage.getTotalCount());
    }

    private Order _toOrder(long commerceOrderId) throws Exception {
        Order order = this._orderHelper.toOrder(commerceOrderId, this.contextUser.getLocale());
        com.liferay.portal.vulcan.pagination.Pagination fullPagination = com.liferay.portal.vulcan.pagination.Pagination.of((int)-1, (int)-1);
        com.liferay.portal.vulcan.pagination.Page<OrderItem> orderItemsPage = this._orderItemHelper.getOrderItemsPage(order.getId(), this.contextUser.getLocale(), fullPagination);
        Collection items = orderItemsPage.getItems();
        order.setOrderItems(items.toArray(new OrderItem[0]));
        return order;
    }
}

