/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.exception.NoSuchOrderNoteException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.CommerceOrderNoteService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderNote;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderNoteDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderNoteResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderNoteResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/order-note.properties"}, scope=ServiceScope.PROTOTYPE, service={OrderNoteResource.class})
public class OrderNoteResourceImpl
extends BaseOrderNoteResourceImpl {
    @Reference
    private CommerceOrderNoteService _commerceOrderNoteService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private OrderNoteDTOConverter _orderNoteDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOrderNoteByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderNote == null) {
            throw new NoSuchOrderNoteException("Unable to find OrderNote with externalReferenceCode: " + externalReferenceCode);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<OrderNote> getOrderByExternalReferenceCodeOrderNotesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find Order with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceOrderNotes = this._commerceOrderNoteService.getCommerceOrderNotes(commerceOrder.getCommerceOrderId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceOrderNoteService.getCommerceOrderNotesCount(commerceOrder.getCommerceOrderId());
        return Page.of(this._toOrderNotes(commerceOrderNotes), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<OrderNote> getOrderIdOrderNotesPage(Long id, Pagination pagination) throws Exception {
        List commerceOrderNotes = this._commerceOrderNoteService.getCommerceOrderNotes(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceOrderNoteService.getCommerceOrderNotesCount(id.longValue());
        return Page.of(this._toOrderNotes(commerceOrderNotes), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public OrderNote getOrderNote(Long id) throws Exception {
        return this._orderNoteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)GetterUtil.getLong((Object)id), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public OrderNote getOrderNoteByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderNote == null) {
            throw new NoSuchOrderNoteException("Unable to find OrderNote with externalReferenceCode: " + externalReferenceCode);
        }
        return this._orderNoteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderNote.getCommerceOrderNoteId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public Response patchOrderNote(Long id, OrderNote orderNote) throws Exception {
        this._updateOrderNote(this._commerceOrderNoteService.getCommerceOrderNote(id.longValue()), orderNote);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchOrderNoteByExternalReferenceCode(String externalReferenceCode, OrderNote orderNote) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderNote == null) {
            throw new NoSuchOrderNoteException("Unable to find OrderNote with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateOrderNote(commerceOrderNote, orderNote);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OrderNote postOrderByExternalReferenceCodeOrderNote(String externalReferenceCode, OrderNote orderNote) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrder == null) {
            throw new NoSuchOrderException("Unable to find Order with externalReferenceCode: " + externalReferenceCode);
        }
        return this._addOrUpdateOrderNote(commerceOrder, orderNote);
    }

    @Override
    public OrderNote postOrderIdOrderNote(Long id, OrderNote orderNote) throws Exception {
        return this._addOrUpdateOrderNote(this._commerceOrderService.getCommerceOrder(id.longValue()), orderNote);
    }

    private OrderNote _addOrUpdateOrderNote(CommerceOrder commerceOrder, OrderNote orderNote) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.addOrUpdateCommerceOrderNote(orderNote.getExternalReferenceCode(), GetterUtil.get((Object)orderNote.getId(), (long)0L), commerceOrder.getCommerceOrderId(), orderNote.getContent(), GetterUtil.get((Object)orderNote.getRestricted(), (boolean)false), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
        return this._orderNoteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderNote.getCommerceOrderNoteId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<OrderNote> _toOrderNotes(List<CommerceOrderNote> commerceOrderNotes) throws Exception {
        ArrayList<OrderNote> orders = new ArrayList<OrderNote>();
        for (CommerceOrderNote commerceOrderNote : commerceOrderNotes) {
            orders.add(this._orderNoteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderNote.getCommerceOrderNoteId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return orders;
    }

    private OrderNote _updateOrderNote(CommerceOrderNote commerceOrderNote, OrderNote orderNote) throws Exception {
        commerceOrderNote = this._commerceOrderNoteService.updateCommerceOrderNote(orderNote.getOrderId().longValue(), GetterUtil.get((String)orderNote.getContent(), (String)commerceOrderNote.getContent()), GetterUtil.get((Object)orderNote.getRestricted(), (boolean)commerceOrderNote.isRestricted()));
        return this._orderNoteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderNote.getCommerceOrderNoteId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

