/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.util.v1_0;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.BillingAddress;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryLocalServiceUtil;
import com.liferay.portal.kernel.service.RegionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class BillingAddressUtil {
    public static CommerceOrder addOrUpdateBillingAddress(CommerceAddressService commerceAddressService, CommerceOrderService commerceOrderService, CommerceOrder commerceOrder, BillingAddress billingAddress, ServiceContext serviceContext) throws Exception {
        if (commerceOrder.getBillingAddressId() > 0L) {
            return BillingAddressUtil._updateCommerceOrderBillingAddress(commerceAddressService, commerceOrderService, commerceOrder, billingAddress, serviceContext);
        }
        CommerceAddress commerceAddress = BillingAddressUtil._addCommerceAddress(commerceAddressService, commerceOrder, billingAddress, serviceContext);
        return commerceOrderService.updateBillingAddress(commerceOrder.getCommerceOrderId(), commerceAddress.getName(), commerceAddress.getDescription(), commerceAddress.getStreet1(), commerceAddress.getStreet2(), commerceAddress.getStreet3(), commerceAddress.getCity(), commerceAddress.getZip(), commerceAddress.getRegionId(), commerceAddress.getCountryId(), commerceAddress.getPhoneNumber(), serviceContext);
    }

    private static CommerceAddress _addCommerceAddress(CommerceAddressService commerceAddressService, CommerceOrder commerceOrder, BillingAddress billingAddress, ServiceContext serviceContext) throws Exception {
        Country country = CountryLocalServiceUtil.getCountryByA2((long)commerceOrder.getCompanyId(), (String)billingAddress.getCountryISOCode());
        return commerceAddressService.addCommerceAddress(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), billingAddress.getName(), billingAddress.getDescription(), billingAddress.getStreet1(), billingAddress.getStreet2(), billingAddress.getStreet3(), billingAddress.getCity(), billingAddress.getZip(), BillingAddressUtil._getRegionId(null, country, billingAddress), country.getCountryId(), billingAddress.getPhoneNumber(), false, false, serviceContext);
    }

    private static long _getCountryId(Country country) {
        if (country == null) {
            return 0L;
        }
        return country.getCountryId();
    }

    private static String _getDescription(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getDescription();
    }

    private static String _getPhoneNumber(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getPhoneNumber();
    }

    private static long _getRegionId(CommerceAddress commerceAddress, Country country, BillingAddress billingAddress) throws Exception {
        if (Validator.isNull((String)billingAddress.getRegionISOCode()) && commerceAddress != null) {
            return commerceAddress.getRegionId();
        }
        if (Validator.isNull((String)billingAddress.getRegionISOCode()) || country == null) {
            return 0L;
        }
        Region region = RegionLocalServiceUtil.getRegion((long)country.getCountryId(), (String)billingAddress.getRegionISOCode());
        return region.getRegionId();
    }

    private static String _getStreet2(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getStreet2();
    }

    private static String _getStreet3(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getStreet3();
    }

    private static String _getZip(CommerceAddress commerceAddress) {
        if (commerceAddress == null) {
            return null;
        }
        return commerceAddress.getZip();
    }

    private static CommerceOrder _updateCommerceOrderBillingAddress(CommerceAddressService commerceAddressService, CommerceOrderService commerceOrderService, CommerceOrder commerceOrder, BillingAddress billingAddress, ServiceContext serviceContext) throws Exception {
        CommerceAddress commerceAddress = commerceAddressService.fetchCommerceAddress(commerceOrder.getBillingAddressId());
        Country country = null;
        if (commerceAddress != null) {
            country = commerceAddress.getCountry();
        }
        return commerceOrderService.updateBillingAddress(commerceOrder.getCommerceOrderId(), billingAddress.getName(), GetterUtil.get((String)billingAddress.getDescription(), (String)BillingAddressUtil._getDescription(commerceAddress)), billingAddress.getStreet1(), GetterUtil.get((String)billingAddress.getStreet2(), (String)BillingAddressUtil._getStreet2(commerceAddress)), GetterUtil.get((String)billingAddress.getStreet3(), (String)BillingAddressUtil._getStreet3(commerceAddress)), billingAddress.getCity(), GetterUtil.get((String)billingAddress.getZip(), (String)BillingAddressUtil._getZip(commerceAddress)), BillingAddressUtil._getRegionId(commerceAddress, country, billingAddress), BillingAddressUtil._getCountryId(country), GetterUtil.get((String)billingAddress.getPhoneNumber(), (String)BillingAddressUtil._getPhoneNumber(commerceAddress)), serviceContext);
    }
}

