/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter.ShipmentItemDTOConverter;
import com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0.BaseShipmentItemResourceImpl;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShipmentItemResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/shipment-item.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ShipmentItemResource.class})
public class ShipmentItemResourceImpl
extends BaseShipmentItemResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private ShipmentItemDTOConverter _shipmentItemDTOConverter;

    @Override
    public void deleteShipmentItem(Long shipmentItemId) throws Exception {
        this._commerceShipmentItemService.deleteCommerceShipmentItem(shipmentItemId.longValue(), Boolean.FALSE.booleanValue());
    }

    @Override
    public ShipmentItem getShipmentItem(Long shipmentItemId) throws Exception {
        return this._toShipmentItem(shipmentItemId);
    }

    @Override
    @NestedField(parentClass=Shipment.class, value="shipmentItems")
    public Page<ShipmentItem> getShipmentItemsPage(@NestedFieldId(value="id") Long shipmentId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._commerceShipmentItemService.getCommerceShipmentItems(shipmentId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toShipmentItem), (Pagination)pagination, (long)this._commerceShipmentItemService.getCommerceShipmentItemsCount(shipmentId.longValue()));
    }

    @Override
    public ShipmentItem patchShipmentItem(Long shipmentItemId, ShipmentItem shipmentItem) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.getCommerceShipmentItem(shipmentItemId.longValue());
        this._commerceShipmentItemService.updateCommerceShipmentItem(shipmentItemId.longValue(), GetterUtil.get((Object)shipmentItem.getWarehouseId(), (long)commerceShipmentItem.getCommerceInventoryWarehouseId()), GetterUtil.get((Object)shipmentItem.getQuantity(), (int)commerceShipmentItem.getQuantity()));
        return this._toShipmentItem(shipmentItemId);
    }

    @Override
    public ShipmentItem postShipmentItem(Long shipmentId, ShipmentItem shipmentItem) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.addCommerceShipmentItem(shipmentId.longValue(), shipmentItem.getOrderItemId().longValue(), shipmentItem.getWarehouseId().longValue(), shipmentItem.getQuantity().intValue(), this._serviceContextHelper.getServiceContext(this.contextUser));
        return this._toShipmentItem(commerceShipmentItem);
    }

    private Map<String, Map<String, String>> _getActions(CommerceShipmentItem commerceShipmentItem) {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceShipmentItem.getCommerceShipmentItemId(), "deleteShipmentItem", commerceShipmentItem.getUserId(), "com.liferay.commerce.model.CommerceShipmentItem", commerceShipmentItem.getGroupId())).put((Object)"get", this.addAction("VIEW", commerceShipmentItem.getCommerceShipmentItemId(), "getShipmentItem", commerceShipmentItem.getUserId(), "com.liferay.commerce.model.CommerceShipmentItem", commerceShipmentItem.getGroupId())).put((Object)"update", this.addAction("UPDATE", commerceShipmentItem.getCommerceShipmentItemId(), "patchShipmentItem", commerceShipmentItem.getUserId(), "com.liferay.commerce.model.CommerceShipmentItem", commerceShipmentItem.getGroupId())).build();
    }

    private ShipmentItem _toShipmentItem(CommerceShipmentItem commerceShipmentItem) throws Exception {
        return this._shipmentItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceShipmentItem), this._dtoConverterRegistry, (Object)commerceShipmentItem.getCommerceShipmentItemId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private ShipmentItem _toShipmentItem(long shipmentItemId) throws Exception {
        return this._toShipmentItem(this._commerceShipmentItemService.getCommerceShipmentItem(shipmentItemId));
    }
}

