/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"dto.class.name=com.liferay.commerce.model.CommerceShipment"}, service={DTOConverter.class, ShipmentDTOConverter.class})
public class ShipmentDTOConverter
implements DTOConverter<CommerceShipment, Shipment> {
    @Reference
    private CommerceShipmentService _commerceShipmentService;

    public String getContentType() {
        return Shipment.class.getSimpleName();
    }

    public Shipment toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(((Long)dtoConverterContext.getId()).longValue());
        return new Shipment(){
            {
                this.accountId = commerceShipment.getCommerceAccountId();
                this.actions = dtoConverterContext.getActions();
                this.carrier = commerceShipment.getCarrier();
                this.createDate = commerceShipment.getCreateDate();
                this.expectedDate = commerceShipment.getExpectedDate();
                this.externalReferenceCode = commerceShipment.getExternalReferenceCode();
                this.id = commerceShipment.getCommerceShipmentId();
                this.modifiedDate = commerceShipment.getModifiedDate();
                this.shippingAddressId = commerceShipment.getCommerceAddressId();
                this.shippingDate = commerceShipment.getShippingDate();
                this.shippingMethodId = commerceShipment.getCommerceShippingMethodId();
                this.shippingOptionName = commerceShipment.getShippingOptionName();
                this.trackingNumber = commerceShipment.getTrackingNumber();
                this.userName = commerceShipment.getUserName();
            }
        };
    }
}

