/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0;

import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShipmentResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseShipmentResourceImpl
implements EntityModelResource,
ShipmentResource,
VulcanBatchEngineTaskItemDelegate<Shipment> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<Shipment>, UnsafeConsumer<Shipment, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseShipmentResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Shipment")})
    @GET
    @Path(value="/shipments")
    @Produces(value={"application/json", "application/xml"})
    public Page<Shipment> getShipmentsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="Shipment")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/shipments")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipment(Shipment shipment) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Shipment")})
    @Consumes(value={"application/json"})
    @Path(value="/shipments/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postShipmentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Shipment.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @DELETE
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteShipmentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrive information of the given Shipment.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @GET
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Shipment getShipmentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Shipment patchShipmentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Shipment shipment) throws Exception {
        Shipment existingShipment = this.getShipmentByExternalReferenceCode(externalReferenceCode);
        if (shipment.getAccountId() != null) {
            existingShipment.setAccountId(shipment.getAccountId());
        }
        if (shipment.getActions() != null) {
            existingShipment.setActions(shipment.getActions());
        }
        if (shipment.getCarrier() != null) {
            existingShipment.setCarrier(shipment.getCarrier());
        }
        if (shipment.getCreateDate() != null) {
            existingShipment.setCreateDate(shipment.getCreateDate());
        }
        if (shipment.getExpectedDate() != null) {
            existingShipment.setExpectedDate(shipment.getExpectedDate());
        }
        if (shipment.getExternalReferenceCode() != null) {
            existingShipment.setExternalReferenceCode(shipment.getExternalReferenceCode());
        }
        if (shipment.getModifiedDate() != null) {
            existingShipment.setModifiedDate(shipment.getModifiedDate());
        }
        if (shipment.getOrderId() != null) {
            existingShipment.setOrderId(shipment.getOrderId());
        }
        if (shipment.getShippingAddressId() != null) {
            existingShipment.setShippingAddressId(shipment.getShippingAddressId());
        }
        if (shipment.getShippingDate() != null) {
            existingShipment.setShippingDate(shipment.getShippingDate());
        }
        if (shipment.getShippingMethodId() != null) {
            existingShipment.setShippingMethodId(shipment.getShippingMethodId());
        }
        if (shipment.getShippingOptionName() != null) {
            existingShipment.setShippingOptionName(shipment.getShippingOptionName());
        }
        if (shipment.getTrackingNumber() != null) {
            existingShipment.setTrackingNumber(shipment.getTrackingNumber());
        }
        if (shipment.getUserName() != null) {
            existingShipment.setUserName(shipment.getUserName());
        }
        this.preparePatch(shipment, existingShipment);
        return this.putShipmentByExternalReferenceCode(externalReferenceCode, existingShipment);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Shipment putShipmentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Shipment shipment) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}/status-delivered")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipmentByExternalReferenceCodeStatusDelivered(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}/status-finish-processing")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipmentByExternalReferenceCodeStatusFinishProcessing(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Shipment")})
    @Path(value="/shipments/by-externalReferenceCode/{externalReferenceCode}/status-shipped")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipmentByExternalReferenceCodeStatusShipped(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="shipmentId")})
    @Tags(value={@Tag(name="Shipment")})
    @DELETE
    @Path(value="/shipments/{shipmentId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteShipment(@Parameter(hidden=true) @NotNull @PathParam(value="shipmentId") Long shipmentId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Shipment")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/shipments/batch")
    @Produces(value={"application/json"})
    public Response deleteShipmentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Shipment.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="shipmentId")})
    @Tags(value={@Tag(name="Shipment")})
    @GET
    @Path(value="/shipments/{shipmentId}")
    @Produces(value={"application/json", "application/xml"})
    public Shipment getShipment(@Parameter(hidden=true) @NotNull @PathParam(value="shipmentId") Long shipmentId) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="shipmentId")})
    @Tags(value={@Tag(name="Shipment")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/shipments/{shipmentId}")
    @Produces(value={"application/json", "application/xml"})
    public Shipment patchShipment(@Parameter(hidden=true) @NotNull @PathParam(value="shipmentId") Long shipmentId, Shipment shipment) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="shipmentId")})
    @Tags(value={@Tag(name="Shipment")})
    @Path(value="/shipments/{shipmentId}/status-delivered")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipmentStatusDelivered(@Parameter(hidden=true) @NotNull @PathParam(value="shipmentId") Long shipmentId) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="shipmentId")})
    @Tags(value={@Tag(name="Shipment")})
    @Path(value="/shipments/{shipmentId}/status-finish-processing")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipmentStatusFinishProcessing(@Parameter(hidden=true) @NotNull @PathParam(value="shipmentId") Long shipmentId) throws Exception {
        return new Shipment();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="shipmentId")})
    @Tags(value={@Tag(name="Shipment")})
    @Path(value="/shipments/{shipmentId}/status-shipped")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Shipment postShipmentStatusShipped(@Parameter(hidden=true) @NotNull @PathParam(value="shipmentId") Long shipmentId) throws Exception {
        return new Shipment();
    }

    public void create(Collection<Shipment> shipments, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer shipmentUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            shipmentUnsafeConsumer = shipment -> this.postShipment((Shipment)shipment);
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            shipmentUnsafeConsumer = shipment -> this.putShipmentByExternalReferenceCode(shipment.getExternalReferenceCode(), (Shipment)shipment);
        }
        if (shipmentUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for Shipment");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(shipments, (Object)shipmentUnsafeConsumer);
        } else {
            for (Shipment shipment2 : shipments) {
                shipmentUnsafeConsumer.accept((Object)shipment2);
            }
        }
    }

    public void delete(Collection<Shipment> shipments, Map<String, Serializable> parameters) throws Exception {
        for (Shipment shipment : shipments) {
            this.deleteShipment(shipment.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<Shipment> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getShipmentsPage(search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Shipment> shipments, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer shipmentUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            shipmentUnsafeConsumer = shipment -> this.patchShipment(shipment.getId() != null ? shipment.getId() : Long.parseLong((String)parameters.get("shipmentId")), (Shipment)shipment);
        }
        if (shipmentUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Shipment");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(shipments, (Object)shipmentUnsafeConsumer);
        } else {
            for (Shipment shipment2 : shipments) {
                shipmentUnsafeConsumer.accept((Object)shipment2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<Shipment>, UnsafeConsumer<Shipment, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(Shipment shipment, Shipment existingShipment) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

