/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter.ShipmentDTOConverter;
import com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0.BaseShipmentResourceImpl;
import com.liferay.headless.commerce.admin.shipment.internal.util.v1_0.ShipmentItemUtil;
import com.liferay.headless.commerce.admin.shipment.internal.util.v1_0.ShippingAddressUtil;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShipmentResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/shipment.properties"}, scope=ServiceScope.PROTOTYPE, service={ShipmentResource.class})
public class ShipmentResourceImpl
extends BaseShipmentResourceImpl {
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;
    @Reference
    private CommerceShipmentService _commerceShipmentService;
    @Reference
    private CountryService _countryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private RegionService _regionService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private ShipmentDTOConverter _shipmentDTOConverter;

    @Override
    public void deleteShipment(Long shipmentId) throws Exception {
        this._commerceShipmentService.deleteCommerceShipment(shipmentId.longValue(), Boolean.FALSE.booleanValue());
    }

    @Override
    public void deleteShipmentByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        this._commerceShipmentService.deleteCommerceShipment(commerceShipment.getCommerceShipmentId(), Boolean.FALSE.booleanValue());
    }

    @Override
    public Shipment getShipment(Long shipmentId) throws Exception {
        return this._toShipment(shipmentId);
    }

    @Override
    public Shipment getShipmentByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        return this._toShipment(commerceShipment);
    }

    @Override
    public Page<Shipment> getShipmentsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceShipment.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
                searchContext.setCompanyId(ShipmentResourceImpl.this.contextCompany.getCompanyId());
            }
        }, (Sort[])sorts, document -> this._toShipment(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Shipment patchShipment(Long shipmentId, Shipment shipment) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(shipmentId.longValue());
        this._updateCommerceShipment(commerceShipment, shipment);
        if (!Validator.isBlank((String)shipment.getExternalReferenceCode())) {
            this._commerceShipmentService.updateExternalReferenceCode(shipmentId.longValue(), shipment.getExternalReferenceCode());
        }
        this._updateNestedResources(commerceShipment, shipment);
        return this._toShipment(shipmentId);
    }

    @Override
    public Shipment patchShipmentByExternalReferenceCode(String externalReferenceCode, Shipment shipment) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        this._updateCommerceShipment(commerceShipment, shipment);
        this._updateNestedResources(commerceShipment, shipment);
        return this._toShipment(commerceShipment);
    }

    @Override
    public Shipment postShipment(Shipment shipment) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(shipment.getOrderId().longValue());
        CommerceShipment commerceShipment = this._commerceShipmentService.addCommerceShipment(shipment.getExternalReferenceCode(), commerceOrder.getGroupId(), commerceOrder.getCommerceAccountId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), this._serviceContextHelper.getServiceContext(this.contextUser));
        this._updateCommerceShipment(commerceShipment, shipment);
        this._updateNestedResources(commerceShipment, shipment);
        return this._toShipment(commerceShipment.getCommerceShipmentId());
    }

    @Override
    public Shipment postShipmentByExternalReferenceCodeStatusDelivered(String externalReferenceCode) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        return this._toShipment(this._commerceShipmentService.updateStatus(commerceShipment.getCommerceShipmentId(), 3));
    }

    @Override
    public Shipment postShipmentByExternalReferenceCodeStatusFinishProcessing(String externalReferenceCode) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        return this._toShipment(this._commerceShipmentService.updateStatus(commerceShipment.getCommerceShipmentId(), 1));
    }

    @Override
    public Shipment postShipmentByExternalReferenceCodeStatusShipped(String externalReferenceCode) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        return this._toShipment(this._commerceShipmentService.updateStatus(commerceShipment.getCommerceShipmentId(), 2));
    }

    @Override
    public Shipment postShipmentStatusDelivered(Long shipmentId) throws Exception {
        return this._toShipment(this._commerceShipmentService.updateStatus(shipmentId.longValue(), 3));
    }

    @Override
    public Shipment postShipmentStatusFinishProcessing(Long shipmentId) throws Exception {
        return this._toShipment(this._commerceShipmentService.updateStatus(shipmentId.longValue(), 1));
    }

    @Override
    public Shipment postShipmentStatusShipped(Long shipmentId) throws Exception {
        return this._toShipment(this._commerceShipmentService.updateStatus(shipmentId.longValue(), 2));
    }

    @Override
    public Shipment putShipmentByExternalReferenceCode(String externalReferenceCode, Shipment shipment) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(shipment.getOrderId().longValue());
            commerceShipment = this._commerceShipmentService.addCommerceShipment(shipment.getExternalReferenceCode(), commerceOrder.getGroupId(), commerceOrder.getCommerceAccountId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), this._serviceContextHelper.getServiceContext(this.contextUser));
        }
        this._updateCommerceShipment(commerceShipment, shipment);
        this._updateNestedResources(commerceShipment, shipment);
        return this._toShipment(commerceShipment);
    }

    private Map<String, Map<String, String>> _getActions(CommerceShipment commerceShipment) {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceShipment.getCommerceShipmentId(), "deleteShipment", commerceShipment.getUserId(), "com.liferay.commerce.model.CommerceShipment", commerceShipment.getGroupId())).put((Object)"get", this.addAction("VIEW", commerceShipment.getCommerceShipmentId(), "getShipment", commerceShipment.getUserId(), "com.liferay.commerce.model.CommerceShipment", commerceShipment.getGroupId())).put((Object)"update", this.addAction("UPDATE", commerceShipment.getCommerceShipmentId(), "patchShipment", commerceShipment.getUserId(), "com.liferay.commerce.model.CommerceShipment", commerceShipment.getGroupId())).build();
    }

    private Shipment _toShipment(CommerceShipment commerceShipment) throws Exception {
        return this._toShipment(commerceShipment.getCommerceShipmentId());
    }

    private Shipment _toShipment(long commerceShipmentId) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(commerceShipmentId);
        return this._shipmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceShipment), this._dtoConverterRegistry, (Object)commerceShipmentId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateCommerceShipment(CommerceShipment commerceShipment, Shipment shipment) throws Exception {
        Date shippingDate;
        this._commerceShipmentService.updateCarrierDetails(commerceShipment.getCommerceShipmentId(), GetterUtil.get((String)shipment.getCarrier(), (String)commerceShipment.getCarrier()), GetterUtil.get((String)shipment.getTrackingNumber(), (String)commerceShipment.getTrackingNumber()));
        Date expectedDate = shipment.getExpectedDate();
        if (expectedDate != null) {
            Calendar calendar = CalendarFactoryUtil.getCalendar((long)expectedDate.getTime());
            int expectedDay = calendar.get(5);
            int expectedMonth = calendar.get(2);
            int expectedYear = calendar.get(1);
            int expectedHour = calendar.get(11);
            int expectedMinute = calendar.get(12);
            this._commerceShipmentService.updateExpectedDate(commerceShipment.getCommerceShipmentId(), expectedMonth, expectedDay, expectedYear, expectedHour, expectedMinute);
        }
        if ((shippingDate = shipment.getShippingDate()) != null) {
            Calendar calendar = CalendarFactoryUtil.getCalendar((long)shippingDate.getTime());
            int shippingDay = calendar.get(5);
            int shippingMonth = calendar.get(2);
            int shippingYear = calendar.get(1);
            int shippingHour = calendar.get(11);
            int shippingMinute = calendar.get(12);
            this._commerceShipmentService.updateShippingDate(commerceShipment.getCommerceShipmentId(), shippingMonth, shippingDay, shippingYear, shippingHour, shippingMinute);
        }
    }

    private CommerceShipment _updateNestedResources(CommerceShipment commerceShipment, Shipment shipment) throws Exception {
        ShipmentItem[] shipmentItems;
        ShippingAddress shippingAddress = shipment.getShippingAddress();
        if (shippingAddress != null) {
            ShippingAddressUtil.updateShippingAddress(this._commerceAddressService, this._commerceShipmentService, commerceShipment, this._countryService, this._regionService, shippingAddress, this._serviceContextHelper);
        }
        if ((shipmentItems = shipment.getShipmentItems()) != null) {
            this._commerceShipmentItemService.deleteCommerceShipmentItems(commerceShipment.getCommerceShipmentId(), true);
            for (ShipmentItem shipmentItem : shipmentItems) {
                ShipmentItemUtil.addOrUpdateShipmentItem(shipmentItem.getExternalReferenceCode(), commerceShipment, this._commerceShipmentItemService, shipmentItem, this._serviceContextHelper);
            }
        }
        return commerceShipment;
    }
}

