/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.graphql.query.v1_0;

import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShipmentItemResource;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShipmentResource;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShippingAddressResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<ShipmentResource> _shipmentResourceComponentServiceObjects;
    private static ComponentServiceObjects<ShipmentItemResource> _shipmentItemResourceComponentServiceObjects;
    private static ComponentServiceObjects<ShippingAddressResource> _shippingAddressResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setShipmentResourceComponentServiceObjects(ComponentServiceObjects<ShipmentResource> shipmentResourceComponentServiceObjects) {
        _shipmentResourceComponentServiceObjects = shipmentResourceComponentServiceObjects;
    }

    public static void setShipmentItemResourceComponentServiceObjects(ComponentServiceObjects<ShipmentItemResource> shipmentItemResourceComponentServiceObjects) {
        _shipmentItemResourceComponentServiceObjects = shipmentItemResourceComponentServiceObjects;
    }

    public static void setShippingAddressResourceComponentServiceObjects(ComponentServiceObjects<ShippingAddressResource> shippingAddressResourceComponentServiceObjects) {
        _shippingAddressResourceComponentServiceObjects = shippingAddressResourceComponentServiceObjects;
    }

    @GraphQLField
    public ShipmentPage shipments(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (ShipmentPage)this._applyComponentServiceObjects(_shipmentResourceComponentServiceObjects, this::_populateResourceContext, shipmentResource -> new ShipmentPage(shipmentResource.getShipmentsPage(search, this._filterBiFunction.apply(shipmentResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(shipmentResource, sortsString))));
    }

    @GraphQLField(description="Retrive information of the given Shipment.")
    public @GraphQLField(description="Retrive information of the given Shipment.") Shipment shipmentByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (Shipment)this._applyComponentServiceObjects(_shipmentResourceComponentServiceObjects, this::_populateResourceContext, shipmentResource -> shipmentResource.getShipmentByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField
    public Shipment shipment(@GraphQLName(value="shipmentId") Long shipmentId) throws Exception {
        return (Shipment)this._applyComponentServiceObjects(_shipmentResourceComponentServiceObjects, this::_populateResourceContext, shipmentResource -> shipmentResource.getShipment(shipmentId));
    }

    @GraphQLField
    public ShipmentItem shipmentByExternalReferenceCodeItem(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (ShipmentItem)this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, this::_populateResourceContext, shipmentItemResource -> shipmentItemResource.getShipmentByExternalReferenceCodeItem(externalReferenceCode));
    }

    @GraphQLField
    public ShipmentItem shipmentItem(@GraphQLName(value="shipmentItemId") Long shipmentItemId) throws Exception {
        return (ShipmentItem)this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, this::_populateResourceContext, shipmentItemResource -> shipmentItemResource.getShipmentItem(shipmentItemId));
    }

    @GraphQLField
    public ShipmentItemPage shipmentByExternalReferenceCodeItems(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (ShipmentItemPage)this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, this::_populateResourceContext, shipmentItemResource -> new ShipmentItemPage(shipmentItemResource.getShipmentByExternalReferenceCodeItemsPage(externalReferenceCode, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public ShipmentItemPage shipmentItems(@GraphQLName(value="shipmentId") Long shipmentId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (ShipmentItemPage)this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, this::_populateResourceContext, shipmentItemResource -> new ShipmentItemPage(shipmentItemResource.getShipmentItemsPage(shipmentId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public ShippingAddress shipmentByExternalReferenceCodeShippingAddress(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (ShippingAddress)this._applyComponentServiceObjects(_shippingAddressResourceComponentServiceObjects, this::_populateResourceContext, shippingAddressResource -> shippingAddressResource.getShipmentByExternalReferenceCodeShippingAddress(externalReferenceCode));
    }

    @GraphQLField
    public ShippingAddress shipmentShippingAddress(@GraphQLName(value="shipmentId") Long shipmentId) throws Exception {
        return (ShippingAddress)this._applyComponentServiceObjects(_shippingAddressResourceComponentServiceObjects, this::_populateResourceContext, shippingAddressResource -> shippingAddressResource.getShipmentShippingAddress(shipmentId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(ShipmentResource shipmentResource) throws Exception {
        shipmentResource.setContextAcceptLanguage(this._acceptLanguage);
        shipmentResource.setContextCompany(this._company);
        shipmentResource.setContextHttpServletRequest(this._httpServletRequest);
        shipmentResource.setContextHttpServletResponse(this._httpServletResponse);
        shipmentResource.setContextUriInfo(this._uriInfo);
        shipmentResource.setContextUser(this._user);
        shipmentResource.setGroupLocalService(this._groupLocalService);
        shipmentResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ShipmentItemResource shipmentItemResource) throws Exception {
        shipmentItemResource.setContextAcceptLanguage(this._acceptLanguage);
        shipmentItemResource.setContextCompany(this._company);
        shipmentItemResource.setContextHttpServletRequest(this._httpServletRequest);
        shipmentItemResource.setContextHttpServletResponse(this._httpServletResponse);
        shipmentItemResource.setContextUriInfo(this._uriInfo);
        shipmentItemResource.setContextUser(this._user);
        shipmentItemResource.setGroupLocalService(this._groupLocalService);
        shipmentItemResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ShippingAddressResource shippingAddressResource) throws Exception {
        shippingAddressResource.setContextAcceptLanguage(this._acceptLanguage);
        shippingAddressResource.setContextCompany(this._company);
        shippingAddressResource.setContextHttpServletRequest(this._httpServletRequest);
        shippingAddressResource.setContextHttpServletResponse(this._httpServletResponse);
        shippingAddressResource.setContextUriInfo(this._uriInfo);
        shippingAddressResource.setContextUser(this._user);
        shippingAddressResource.setGroupLocalService(this._groupLocalService);
        shippingAddressResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="ShippingAddressPage")
    public class ShippingAddressPage {
        @GraphQLField
        protected Map<String, Map<String, String>> actions;
        @GraphQLField
        protected Collection<ShippingAddress> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ShippingAddressPage(Page shippingAddressPage) {
            this.actions = shippingAddressPage.getActions();
            this.items = shippingAddressPage.getItems();
            this.lastPage = shippingAddressPage.getLastPage();
            this.page = shippingAddressPage.getPage();
            this.pageSize = shippingAddressPage.getPageSize();
            this.totalCount = shippingAddressPage.getTotalCount();
        }
    }

    @GraphQLName(value="ShipmentItemPage")
    public class ShipmentItemPage {
        @GraphQLField
        protected Map<String, Map<String, String>> actions;
        @GraphQLField
        protected Collection<ShipmentItem> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ShipmentItemPage(Page shipmentItemPage) {
            this.actions = shipmentItemPage.getActions();
            this.items = shipmentItemPage.getItems();
            this.lastPage = shipmentItemPage.getLastPage();
            this.page = shipmentItemPage.getPage();
            this.pageSize = shipmentItemPage.getPageSize();
            this.totalCount = shipmentItemPage.getTotalCount();
        }
    }

    @GraphQLName(value="ShipmentPage")
    public class ShipmentPage {
        @GraphQLField
        protected Map<String, Map<String, String>> actions;
        @GraphQLField
        protected Collection<Shipment> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ShipmentPage(Page shipmentPage) {
            this.actions = shipmentPage.getActions();
            this.items = shipmentPage.getItems();
            this.lastPage = shipmentPage.getLastPage();
            this.page = shipmentPage.getPage();
            this.pageSize = shipmentPage.getPageSize();
            this.totalCount = shipmentPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=Shipment.class)
    public class GetShipmentItemsPageTypeExtension {
        private Shipment _shipment;

        public GetShipmentItemsPageTypeExtension(Shipment shipment) {
            this._shipment = shipment;
        }

        @GraphQLField
        public ShipmentItemPage items(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (ShipmentItemPage)Query.this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shipmentItemResource -> new ShipmentItemPage(shipmentItemResource.getShipmentItemsPage(this._shipment.getId(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=ShipmentItem.class)
    public class GetShipmentByExternalReferenceCodeTypeExtension {
        private ShipmentItem _shipmentItem;

        public GetShipmentByExternalReferenceCodeTypeExtension(ShipmentItem shipmentItem) {
            this._shipmentItem = shipmentItem;
        }

        @GraphQLField(description="Retrive information of the given Shipment.")
        public @GraphQLField(description="Retrive information of the given Shipment.") Shipment shipmentByExternalReferenceCode() throws Exception {
            return (Shipment)Query.this._applyComponentServiceObjects(_shipmentResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shipmentResource -> shipmentResource.getShipmentByExternalReferenceCode(this._shipmentItem.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=ShipmentItem.class)
    public class GetShipmentTypeExtension {
        private ShipmentItem _shipmentItem;

        public GetShipmentTypeExtension(ShipmentItem shipmentItem) {
            this._shipmentItem = shipmentItem;
        }

        @GraphQLField
        public Shipment shipment() throws Exception {
            return (Shipment)Query.this._applyComponentServiceObjects(_shipmentResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shipmentResource -> shipmentResource.getShipment(this._shipmentItem.getShipmentId()));
        }
    }

    @GraphQLTypeExtension(value=Shipment.class)
    public class GetShipmentByExternalReferenceCodeShippingAddressTypeExtension {
        private Shipment _shipment;

        public GetShipmentByExternalReferenceCodeShippingAddressTypeExtension(Shipment shipment) {
            this._shipment = shipment;
        }

        @GraphQLField
        public ShippingAddress byExternalReferenceCodeShippingAddress() throws Exception {
            return (ShippingAddress)Query.this._applyComponentServiceObjects(_shippingAddressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shippingAddressResource -> shippingAddressResource.getShipmentByExternalReferenceCodeShippingAddress(this._shipment.getExternalReferenceCode()));
        }
    }

    @GraphQLTypeExtension(value=Shipment.class)
    public class GetShipmentByExternalReferenceCodeItemsPageTypeExtension {
        private Shipment _shipment;

        public GetShipmentByExternalReferenceCodeItemsPageTypeExtension(Shipment shipment) {
            this._shipment = shipment;
        }

        @GraphQLField
        public ShipmentItemPage byExternalReferenceCodeItems(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (ShipmentItemPage)Query.this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shipmentItemResource -> new ShipmentItemPage(shipmentItemResource.getShipmentByExternalReferenceCodeItemsPage(this._shipment.getExternalReferenceCode(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=Shipment.class)
    public class GetShipmentByExternalReferenceCodeItemTypeExtension {
        private Shipment _shipment;

        public GetShipmentByExternalReferenceCodeItemTypeExtension(Shipment shipment) {
            this._shipment = shipment;
        }

        @GraphQLField
        public ShipmentItem byExternalReferenceCodeItem() throws Exception {
            return (ShipmentItem)Query.this._applyComponentServiceObjects(_shipmentItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shipmentItemResource -> shipmentItemResource.getShipmentByExternalReferenceCodeItem(this._shipment.getExternalReferenceCode()));
        }
    }
}

