/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Status;
import com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceShipment"}, service={DTOConverter.class})
public class ShipmentDTOConverter
implements DTOConverter<CommerceShipment, Shipment> {
    @Reference
    private CommerceShipmentService _commerceShipmentService;
    @Reference
    private Language _language;

    public String getContentType() {
        return Shipment.class.getSimpleName();
    }

    public Shipment toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(((Long)dtoConverterContext.getId()).longValue());
        return new Shipment(){
            {
                this.accountId = commerceShipment.getCommerceAccountId();
                this.actions = dtoConverterContext.getActions();
                this.carrier = commerceShipment.getCarrier();
                this.createDate = commerceShipment.getCreateDate();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CommerceShipment.class.getName(), commerceShipment.getCommerceShipmentId(), commerceShipment.getCompanyId(), dtoConverterContext.getLocale());
                this.expectedDate = commerceShipment.getExpectedDate();
                this.externalReferenceCode = commerceShipment.getExternalReferenceCode();
                this.id = commerceShipment.getCommerceShipmentId();
                this.modifiedDate = commerceShipment.getModifiedDate();
                this.shippingAddressId = commerceShipment.getCommerceAddressId();
                this.shippingDate = commerceShipment.getShippingDate();
                this.shippingMethodId = commerceShipment.getCommerceShippingMethodId();
                this.shippingOptionName = commerceShipment.getShippingOptionName();
                this.status = new Status(){
                    {
                        this.code = commerceShipment.getStatus();
                        this.label = CommerceShipmentConstants.getShipmentStatusLabel((int)commerceShipment.getStatus());
                        this.label_i18n = ShipmentDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), CommerceShipmentConstants.getShipmentStatusLabel((int)commerceShipment.getStatus()));
                    }
                };
                this.trackingNumber = commerceShipment.getTrackingNumber();
                this.trackingURL = commerceShipment.getTrackingURL();
                this.userName = commerceShipment.getUserName();
            }
        };
    }
}

