/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.util.CommerceQuantityFormatter;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceShipmentItem"}, service={DTOConverter.class})
public class ShipmentItemDTOConverter
implements DTOConverter<CommerceShipmentItem, ShipmentItem> {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceQuantityFormatter _commerceQuantityFormatter;
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;

    public String getContentType() {
        return ShipmentItem.class.getSimpleName();
    }

    public ShipmentItem toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.getCommerceShipmentItem(((Long)dtoConverterContext.getId()).longValue());
        return new ShipmentItem(){
            {
                this.actions = dtoConverterContext.getActions();
                this.createDate = commerceShipmentItem.getCreateDate();
                this.externalReferenceCode = commerceShipmentItem.getExternalReferenceCode();
                this.id = commerceShipmentItem.getCommerceShipmentItemId();
                this.modifiedDate = commerceShipmentItem.getModifiedDate();
                this.orderItemId = commerceShipmentItem.getCommerceOrderItemId();
                this.shipmentId = commerceShipmentItem.getCommerceShipmentId();
                this.unitOfMeasureKey = commerceShipmentItem.getUnitOfMeasureKey();
                this.userName = commerceShipmentItem.getUserName();
                this.warehouseId = commerceShipmentItem.getCommerceInventoryWarehouseId();
                this.setQuantity(() -> {
                    CommerceOrderItem commerceOrderItem = ShipmentItemDTOConverter.this._commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
                    if (commerceOrderItem == null) {
                        return null;
                    }
                    return ShipmentItemDTOConverter.this._commerceQuantityFormatter.format(commerceOrderItem.getCPInstanceId(), commerceShipmentItem.getQuantity(), commerceOrderItem.getUnitOfMeasureKey());
                });
                this.setShipmentExternalReferenceCode(() -> {
                    CommerceShipment commerceShipment = commerceShipmentItem.getCommerceShipment();
                    return commerceShipment.getExternalReferenceCode();
                });
            }
        };
    }
}

