/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.util.v1_0;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class ShippingAddressUtil {
    public static CommerceShipment updateShippingAddress(CommerceAddressService commerceAddressService, CommerceShipmentService commerceShipmentService, CommerceShipment commerceShipment, CountryService countryService, RegionService regionService, ShippingAddress shippingAddress, ServiceContextHelper serviceContextHelper) throws Exception {
        CommerceAddress commerceAddress = commerceAddressService.fetchCommerceAddress(commerceShipment.getCommerceAddressId());
        Country country = countryService.fetchCountryByA2(commerceShipment.getCompanyId(), shippingAddress.getCountryISOCode());
        return commerceShipmentService.updateAddress(commerceShipment.getCommerceShipmentId(), GetterUtil.get((String)shippingAddress.getName(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"name")), GetterUtil.get((String)shippingAddress.getDescription(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"description")), GetterUtil.get((String)shippingAddress.getStreet1(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"street1")), GetterUtil.get((String)shippingAddress.getStreet2(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"street2")), GetterUtil.get((String)shippingAddress.getStreet3(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"street3")), GetterUtil.get((String)shippingAddress.getCity(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"city")), GetterUtil.get((String)shippingAddress.getZip(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"zip")), ShippingAddressUtil._getRegionId(commerceAddress, country, regionService, shippingAddress), ShippingAddressUtil._getCountryId(commerceAddress, country, shippingAddress), GetterUtil.get((String)shippingAddress.getPhoneNumber(), (String)BeanPropertiesUtil.getString((Object)commerceAddress, (String)"phoneNumber")), serviceContextHelper.getServiceContext());
    }

    private static long _getCountryId(CommerceAddress commerceAddress, Country country, ShippingAddress shippingAddress) {
        if (Validator.isNull((String)shippingAddress.getCountryISOCode()) && commerceAddress != null) {
            return commerceAddress.getCountryId();
        }
        if (country == null) {
            return 0L;
        }
        return country.getCountryId();
    }

    private static long _getRegionId(CommerceAddress commerceAddress, Country country, RegionService regionService, ShippingAddress shippingAddress) throws Exception {
        if (Validator.isNull((String)shippingAddress.getRegionISOCode()) && commerceAddress != null) {
            return commerceAddress.getRegionId();
        }
        Region region = regionService.fetchRegion(ShippingAddressUtil._getCountryId(commerceAddress, country, shippingAddress), shippingAddress.getRegionISOCode());
        if (region == null) {
            return 0L;
        }
        return region.getRegionId();
    }
}

