/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.internal.helper.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPTaxCategoryException;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.CPTaxCategoryService;
import com.liferay.headless.commerce.admin.site.setting.dto.v1_0.TaxCategory;
import com.liferay.headless.commerce.admin.site.setting.internal.mapper.v1_0.DTOMapper;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TaxCategoryHelper.class})
public class TaxCategoryHelper {
    private static final Log _log = LogFactoryUtil.getLog(TaxCategoryHelper.class);
    @Reference
    private CPTaxCategoryService _cpTaxCategoryService;
    @Reference
    private DTOMapper _dtoMapper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    public TaxCategory addOrUpdateTaxCategory(Long groupId, TaxCategory taxCategory, User user) throws PortalException {
        try {
            CPTaxCategory cpTaxCategory = this.updateTaxCategory(taxCategory.getId(), taxCategory);
            return this._dtoMapper.modelToDTO(cpTaxCategory);
        }
        catch (NoSuchCPTaxCategoryException noSuchCPTaxCategoryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find taxCategory with ID: " + taxCategory.getId()), (Throwable)noSuchCPTaxCategoryException);
            }
            CPTaxCategory cpTaxCategory = this._cpTaxCategoryService.addCPTaxCategory("", LanguageUtils.getLocalizedMap((Map)taxCategory.getName()), LanguageUtils.getLocalizedMap((Map)taxCategory.getDescription()), this._serviceContextHelper.getServiceContext(groupId.longValue(), new long[0], user, true));
            return this._dtoMapper.modelToDTO(cpTaxCategory);
        }
    }

    public void deleteTaxCategory(Long id) throws PortalException {
        this._cpTaxCategoryService.deleteCPTaxCategory(id.longValue());
    }

    public Page<TaxCategory> getTaxCategories(Long companyId, Pagination pagination) throws PortalException {
        List cpTaxCategories = this._cpTaxCategoryService.getCPTaxCategories(companyId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._cpTaxCategoryService.getCPTaxCategoriesCount(companyId.longValue());
        ArrayList<TaxCategory> taxCategories = new ArrayList<TaxCategory>();
        for (CPTaxCategory cpTaxCategory : cpTaxCategories) {
            taxCategories.add(this._dtoMapper.modelToDTO(cpTaxCategory));
        }
        return Page.of(taxCategories, (Pagination)pagination, (long)count);
    }

    public TaxCategory getTaxCategory(Long id) throws PortalException {
        return this._dtoMapper.modelToDTO(this._cpTaxCategoryService.getCPTaxCategory(id.longValue()));
    }

    public CPTaxCategory updateTaxCategory(Long id, TaxCategory taxCategory) throws PortalException {
        CPTaxCategory cpTaxCategory = this._cpTaxCategoryService.getCPTaxCategory(id.longValue());
        return this._cpTaxCategoryService.updateCPTaxCategory(cpTaxCategory.getExternalReferenceCode(), cpTaxCategory.getCPTaxCategoryId(), LanguageUtils.getLocalizedMap((Map)taxCategory.getName()), LanguageUtils.getLocalizedMap((Map)taxCategory.getDescription()));
    }
}

