/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.internal.helper.v1_0;

import com.liferay.commerce.exception.NoSuchWarehouseException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.headless.commerce.admin.site.setting.dto.v1_0.Warehouse;
import com.liferay.headless.commerce.admin.site.setting.internal.mapper.v1_0.DTOMapper;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WarehouseHelper.class})
public class WarehouseHelper {
    private static final Log _log = LogFactoryUtil.getLog(WarehouseHelper.class);
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private DTOMapper _dtoMapper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    public Warehouse addOrUpdateWarehouse(Long groupId, Warehouse warehouse, User user) throws PortalException {
        try {
            CommerceInventoryWarehouse commerceInventoryWarehouse = this.updateWarehouse(warehouse.getId(), warehouse, user);
            return this._dtoMapper.modelToDTO(commerceInventoryWarehouse);
        }
        catch (NoSuchWarehouseException noSuchWarehouseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find availabilityEstimate with ID: " + warehouse.getId()), (Throwable)noSuchWarehouseException);
            }
            CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.addCommerceInventoryWarehouse(null, LanguageUtils.getLocalizedMap((Map)warehouse.getName()), LanguageUtils.getLocalizedMap((Map)warehouse.getDescription()), GetterUtil.get((Object)warehouse.getActive(), (boolean)false), warehouse.getStreet1(), warehouse.getStreet2(), warehouse.getStreet3(), warehouse.getCity(), warehouse.getZip(), "", "", GetterUtil.get((Object)warehouse.getLatitude(), (double)0.0), GetterUtil.get((Object)warehouse.getLongitude(), (double)0.0), this._serviceContextHelper.getServiceContext(groupId.longValue(), new long[0], user, true));
            return this._dtoMapper.modelToDTO(commerceInventoryWarehouse);
        }
    }

    public void deleteWarehouse(Long id) throws PortalException {
        this._commerceInventoryWarehouseService.deleteCommerceInventoryWarehouse(id.longValue());
    }

    public Warehouse getWarehouse(Long id) throws PortalException {
        return this._dtoMapper.modelToDTO(this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(id.longValue()));
    }

    public Page<Warehouse> getWarehouses(Long groupId, Boolean active, Pagination pagination) throws PortalException {
        return null;
    }

    public CommerceInventoryWarehouse updateWarehouse(Long id, Warehouse warehouse, User user) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this._commerceInventoryWarehouseService.getCommerceInventoryWarehouse(id.longValue());
        return this._commerceInventoryWarehouseService.updateCommerceInventoryWarehouse(commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), LanguageUtils.getLocalizedMap((Map)warehouse.getName()), LanguageUtils.getLocalizedMap((Map)warehouse.getDescription()), GetterUtil.get((Object)warehouse.getActive(), (boolean)commerceInventoryWarehouse.isActive()), GetterUtil.get((String)warehouse.getStreet1(), (String)commerceInventoryWarehouse.getStreet1()), GetterUtil.get((String)warehouse.getStreet2(), (String)commerceInventoryWarehouse.getStreet2()), GetterUtil.get((String)warehouse.getStreet3(), (String)commerceInventoryWarehouse.getStreet3()), GetterUtil.get((String)warehouse.getCity(), (String)commerceInventoryWarehouse.getCity()), GetterUtil.get((String)warehouse.getZip(), (String)commerceInventoryWarehouse.getZip()), null, null, GetterUtil.get((Object)warehouse.getLatitude(), (double)commerceInventoryWarehouse.getLatitude()), GetterUtil.get((Object)warehouse.getLongitude(), (double)commerceInventoryWarehouse.getLongitude()), GetterUtil.get((Object)warehouse.getMvccVersion(), (long)commerceInventoryWarehouse.getMvccVersion()), this._serviceContextHelper.getServiceContext(0L, new long[0], user, true));
    }
}

