/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.internal.resource.v1_0;

import com.liferay.commerce.product.constants.CPMeasurementUnitConstants;
import com.liferay.commerce.product.exception.CPMeasurementUnitTypeException;
import com.liferay.commerce.product.exception.DuplicateCPMeasurementUnitExternalReferenceCodeException;
import com.liferay.commerce.product.exception.DuplicateCPMeasurementUnitKeyException;
import com.liferay.commerce.product.exception.NoSuchCPMeasurementUnitException;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.service.CPMeasurementUnitService;
import com.liferay.headless.commerce.admin.site.setting.dto.v1_0.MeasurementUnit;
import com.liferay.headless.commerce.admin.site.setting.internal.resource.v1_0.BaseMeasurementUnitResourceImpl;
import com.liferay.headless.commerce.admin.site.setting.resource.v1_0.MeasurementUnitResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/measurement-unit.properties"}, scope=ServiceScope.PROTOTYPE, service={MeasurementUnitResource.class})
public class MeasurementUnitResourceImpl
extends BaseMeasurementUnitResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(MeasurementUnitResourceImpl.class);
    @Reference
    private CPMeasurementUnitService _cpMeasurementUnitService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.site.setting.internal.dto.v1_0.converter.MeasurementUnitDTOConverter)")
    private DTOConverter<CPMeasurementUnit, MeasurementUnit> _measurementUnitDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteMeasurementUnit(Long id) throws Exception {
        this._findById(id);
        this._cpMeasurementUnitService.deleteCPMeasurementUnit(id.longValue());
    }

    @Override
    public void deleteMeasurementUnitByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPMeasurementUnit cpMeasurementUnit = this._findByExternalReferenceCode(externalReferenceCode);
        this._cpMeasurementUnitService.deleteCPMeasurementUnit(cpMeasurementUnit.getCPMeasurementUnitId());
    }

    @Override
    public void deleteMeasurementUnitByKey(String key) throws Exception {
        CPMeasurementUnit cpMeasurementUnit = this._findByKey(key);
        this._cpMeasurementUnitService.deleteCPMeasurementUnit(cpMeasurementUnit.getCPMeasurementUnitId());
    }

    @Override
    public MeasurementUnit getMeasurementUnit(Long id) throws Exception {
        return this._toMeasurementUnit(this._findById(id));
    }

    @Override
    public MeasurementUnit getMeasurementUnitByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toMeasurementUnit(this._findByExternalReferenceCode(externalReferenceCode));
    }

    @Override
    public MeasurementUnit getMeasurementUnitByKey(String key) throws Exception {
        return this._toMeasurementUnit(this._findByKey(key));
    }

    @Override
    public Page<MeasurementUnit> getMeasurementUnitsByType(String measurementUnitType, Pagination pagination, Sort[] sorts) throws Exception {
        try {
            int type = this._getType(measurementUnitType);
            return Page.of(this.transform(this._cpMeasurementUnitService.getCPMeasurementUnitsByType(this.contextCompany.getCompanyId(), type, pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toMeasurementUnit), (Pagination)pagination, (long)this._cpMeasurementUnitService.getCPMeasurementUnitsCount(this.contextCompany.getCompanyId(), type));
        }
        catch (CPMeasurementUnitTypeException cpMeasurementUnitTypeException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)cpMeasurementUnitTypeException);
            }
            return Page.of(Collections.emptyList());
        }
    }

    @Override
    public Page<MeasurementUnit> getMeasurementUnitsPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of(this.transform(this._cpMeasurementUnitService.getCPMeasurementUnits(this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toMeasurementUnit), (Pagination)pagination, (long)this._cpMeasurementUnitService.getCPMeasurementUnitsCount(this.contextCompany.getCompanyId()));
    }

    @Override
    public Response patchMeasurementUnit(Long id, MeasurementUnit measurementUnit) throws Exception {
        this._updateMeasurementUnit(measurementUnit, this._findById(id));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchMeasurementUnitByExternalReferenceCode(String externalReferenceCode, MeasurementUnit measurementUnit) throws Exception {
        this._updateMeasurementUnit(measurementUnit, this._findByExternalReferenceCode(externalReferenceCode));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchMeasurementUnitByKey(String key, MeasurementUnit measurementUnit) throws Exception {
        this._updateMeasurementUnit(measurementUnit, this._findByKey(key));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public MeasurementUnit postMeasurementUnit(MeasurementUnit measurementUnit) throws Exception {
        try {
            return this._toMeasurementUnit(this._cpMeasurementUnitService.addCPMeasurementUnit(measurementUnit.getExternalReferenceCode(), LanguageUtils.getLocalizedMap((Map)measurementUnit.getName()), measurementUnit.getKey(), measurementUnit.getRate().doubleValue(), this._getPrimary(measurementUnit.getPrimary(), this._getType(measurementUnit.getType())).booleanValue(), measurementUnit.getPriority().doubleValue(), this._getType(measurementUnit.getType()), this._serviceContextHelper.getServiceContext(this.contextUser)));
        }
        catch (Exception exception) {
            if (exception instanceof DuplicateCPMeasurementUnitExternalReferenceCodeException) {
                throw new DuplicateCPMeasurementUnitExternalReferenceCodeException("There is another measurement unit with external reference code " + measurementUnit.getExternalReferenceCode());
            }
            if (exception instanceof DuplicateCPMeasurementUnitKeyException) {
                throw new DuplicateCPMeasurementUnitKeyException("There is another measurement unit with key " + measurementUnit.getKey());
            }
            throw new Exception(exception.getMessage(), exception.getCause());
        }
    }

    private CPMeasurementUnit _findByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitService.fetchCPMeasurementUnitByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpMeasurementUnit == null) {
            throw new NoSuchCPMeasurementUnitException("Unable to find measurement unit with external reference code " + externalReferenceCode);
        }
        return cpMeasurementUnit;
    }

    private CPMeasurementUnit _findById(Long id) throws Exception {
        CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitService.fetchCPMeasurementUnit(id.longValue());
        if (cpMeasurementUnit == null) {
            throw new NoSuchCPMeasurementUnitException("Unable to find measurement unit with id " + id);
        }
        return cpMeasurementUnit;
    }

    private CPMeasurementUnit _findByKey(String key) throws Exception {
        CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitService.fetchCPMeasurementUnitByKey(this.contextCompany.getCompanyId(), key);
        if (cpMeasurementUnit == null) {
            throw new NoSuchCPMeasurementUnitException("Unable to find measurement unit with key " + key);
        }
        return cpMeasurementUnit;
    }

    private Boolean _getPrimary(Boolean primary, int type) throws Exception {
        CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitService.fetchPrimaryCPMeasurementUnitByType(this.contextCompany.getCompanyId(), type);
        if (cpMeasurementUnit == null) {
            return Boolean.TRUE;
        }
        if (primary == null) {
            return Boolean.FALSE;
        }
        return primary;
    }

    private int _getType(String measurementUnitType) throws Exception {
        if (Validator.isNumber((String)measurementUnitType) && CPMeasurementUnitConstants.typesMap.containsKey(GetterUtil.getInteger((String)measurementUnitType))) {
            return GetterUtil.getInteger((String)measurementUnitType);
        }
        if (!CPMeasurementUnitConstants.typesMap.containsValue(measurementUnitType)) {
            throw new CPMeasurementUnitTypeException("Unable to find measurement unit with type " + measurementUnitType);
        }
        for (Map.Entry entry : CPMeasurementUnitConstants.typesMap.entrySet()) {
            if (!StringUtil.equalsIgnoreCase((String)measurementUnitType, (String)((String)entry.getValue()))) continue;
            return (Integer)entry.getKey();
        }
        return -1;
    }

    private MeasurementUnit _toMeasurementUnit(CPMeasurementUnit cpMeasurementUnit) throws Exception {
        return (MeasurementUnit)this._measurementUnitDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)cpMeasurementUnit, "deleteMeasurementUnit")).put((Object)"get", this.addAction("VIEW", (GroupedModel)cpMeasurementUnit, "getMeasurementUnit")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)cpMeasurementUnit, "patchMeasurementUnit")).build(), this._dtoConverterRegistry, (Object)cpMeasurementUnit.getCPMeasurementUnitId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateMeasurementUnit(MeasurementUnit measurementUnit, CPMeasurementUnit cpMeasurementUnit) throws Exception {
        this._cpMeasurementUnitService.updateCPMeasurementUnit(GetterUtil.get((String)measurementUnit.getExternalReferenceCode(), (String)cpMeasurementUnit.getExternalReferenceCode()), cpMeasurementUnit.getCPMeasurementUnitId(), LanguageUtils.getLocalizedMap((Map)measurementUnit.getName()), GetterUtil.get((String)measurementUnit.getKey(), (String)cpMeasurementUnit.getKey()), GetterUtil.get((Object)measurementUnit.getRate(), (double)cpMeasurementUnit.getRate()), GetterUtil.get((Object)measurementUnit.getPrimary(), (boolean)cpMeasurementUnit.isPrimary()), GetterUtil.get((Object)measurementUnit.getPriority(), (double)cpMeasurementUnit.getPriority()), this._getType(measurementUnit.getType()), this._serviceContextHelper.getServiceContext(this.contextUser));
    }
}

