/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Status;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Summary;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart"}, service={CartDTOConverter.class, DTOConverter.class})
public class CartDTOConverter
implements DTOConverter<CommerceOrder, Cart> {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;

    public String getContentType() {
        return Cart.class.getSimpleName();
    }

    public Cart toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(((Long)dtoConverterContext.getId()).longValue());
        final ExpandoBridge expandoBridge = commerceOrder.getExpandoBridge();
        final Locale locale = dtoConverterContext.getLocale();
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
        final String commerceOrderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)commerceOrder.getOrderStatus());
        final String commerceOrderStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)CommerceOrderConstants.getOrderStatusLabel((int)commerceOrder.getOrderStatus()));
        final String commerceOrderWorkflowStatusLabel = WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus());
        final String commerceOrderWorkflowStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus()));
        final String commerceOrderPaymentStatusLabel = CommerceOrderConstants.getPaymentStatusLabel((int)commerceOrder.getPaymentStatus());
        final String commerceOrderPaymentStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)CommerceOrderConstants.getPaymentStatusLabel((int)commerceOrder.getPaymentStatus()));
        Cart cart = new Cart(){
            {
                this.account = commerceOrder.getCommerceAccountName();
                this.accountId = commerceOrder.getCommerceAccountId();
                this.author = commerceOrder.getUserName();
                this.billingAddressId = commerceOrder.getBillingAddressId();
                this.couponCode = commerceOrder.getCouponCode();
                this.createDate = commerceOrder.getCreateDate();
                this.customFields = expandoBridge.getAttributes();
                this.id = commerceOrder.getCommerceOrderId();
                this.lastPriceUpdateDate = commerceOrder.getLastPriceUpdateDate();
                this.modifiedDate = commerceOrder.getModifiedDate();
                this.orderStatusInfo = CartDTOConverter.this._getOrderStatusInfo(commerceOrder.getOrderStatus(), commerceOrderStatusLabel, commerceOrderStatusLabelI18n);
                this.orderUUID = commerceOrder.getUuid();
                this.paymentMethod = commerceOrder.getCommercePaymentMethodKey();
                this.paymentStatus = commerceOrder.getPaymentStatus();
                this.paymentStatusInfo = CartDTOConverter.this._getPaymentStatusInfo(commerceOrder.getPaymentStatus(), commerceOrderPaymentStatusLabel, commerceOrderPaymentStatusLabelI18n);
                this.paymentStatusLabel = commerceOrderPaymentStatusLabel;
                this.printedNote = commerceOrder.getPrintedNote();
                this.purchaseOrderNumber = commerceOrder.getPurchaseOrderNumber();
                this.shippingAddressId = commerceOrder.getShippingAddressId();
                this.status = commerceOrderWorkflowStatusLabel;
                this.summary = CartDTOConverter.this._getSummary(commerceOrder, locale);
                this.workflowStatusInfo = CartDTOConverter.this._getWorkflowStatusInfo(commerceOrder.getStatus(), commerceOrderWorkflowStatusLabel, commerceOrderWorkflowStatusLabelI18n);
            }
        };
        String paymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (paymentMethodKey != null && !paymentMethodKey.isEmpty()) {
            String commerceOrderPaymentMethodName = this._commercePaymentEngine.getPaymentMethodName(paymentMethodKey, locale);
            cart.setPaymentMethodLabel(commerceOrderPaymentMethodName);
        }
        return cart;
    }

    private String _formatPrice(BigDecimal price, CommerceCurrency commerceCurrency, Locale locale) throws Exception {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return this._commercePriceFormatter.format(commerceCurrency, price, locale);
    }

    private String[] _getFormattedDiscountPercentages(BigDecimal[] discountPercentages, Locale locale) throws Exception {
        ArrayList<String> formattedDiscountPercentages = new ArrayList<String>();
        for (BigDecimal percentage : discountPercentages) {
            formattedDiscountPercentages.add(this._commercePriceFormatter.format(percentage, locale));
        }
        return formattedDiscountPercentages.toArray(new String[0]);
    }

    private Status _getOrderStatusInfo(final int orderStatus, final String commerceOrderStatusLabel, final String commerceOrderStatusLabelI18n) {
        return new Status(){
            {
                this.code = orderStatus;
                this.label = commerceOrderStatusLabel;
                this.label_i18n = commerceOrderStatusLabelI18n;
            }
        };
    }

    private Status _getPaymentStatusInfo(final int paymentStatus, final String commerceOrderPaymentStatusLabel, final String commerceOrderPaymentStatusLabelI18n) {
        return new Status(){
            {
                this.code = paymentStatus;
                this.label = commerceOrderPaymentStatusLabel;
                this.label_i18n = commerceOrderPaymentStatusLabelI18n;
            }
        };
    }

    private Summary _getSummary(final CommerceOrder commerceOrder, final Locale locale) throws Exception {
        final CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        final CommerceMoney commerceOrderPriceShippingValueCommerceMoney = commerceOrder.getShippingMoney();
        final BigDecimal commerceOrderPriceShippingValuePrice = commerceOrderPriceShippingValueCommerceMoney.getPrice();
        final CommerceMoney commerceOrderShippingValueWithTaxAmountCommerceMoney = commerceOrder.getShippingWithTaxAmountMoney();
        BigDecimal commerceOrderPriceShippingValueWithTaxAmountPrice = commerceOrderPriceShippingValuePrice;
        if (!commerceOrderShippingValueWithTaxAmountCommerceMoney.isEmpty()) {
            commerceOrderPriceShippingValueWithTaxAmountPrice = commerceOrderShippingValueWithTaxAmountCommerceMoney.getPrice();
        }
        final CommerceMoney commerceOrderPriceSubtotalCommerceMoney = commerceOrder.getSubtotalMoney();
        BigDecimal orderPriceSubtotalPrice = commerceOrderPriceSubtotalCommerceMoney.getPrice();
        final CommerceMoney commerceOrderPriceTotalCommerceMoney = commerceOrder.getTotalMoney();
        BigDecimal orderPriceTotalPrice = commerceOrderPriceTotalCommerceMoney.getPrice();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        if (Objects.equals(commerceChannel.getPriceDisplayType(), "tax-included")) {
            orderPriceSubtotalPrice = commerceOrder.getSubtotalWithTaxAmount();
            orderPriceTotalPrice = commerceOrder.getTotalWithTaxAmount();
        }
        final BigDecimal finalOrderPriceShippingValueWithTaxAmountPrice = commerceOrderPriceShippingValueWithTaxAmountPrice;
        final BigDecimal finalOrderPriceSubtotalPrice = orderPriceSubtotalPrice;
        final BigDecimal finalOrderPriceTotalPrice = orderPriceTotalPrice;
        Summary summary = new Summary(){
            {
                this.currency = commerceCurrency.getName(locale);
                this.itemsQuantity = CartDTOConverter.this._commerceOrderItemService.getCommerceOrderItemsQuantity(commerceOrder.getCommerceOrderId());
                this.shippingValue = commerceOrderPriceShippingValuePrice.doubleValue();
                this.shippingValueFormatted = commerceOrderPriceShippingValueCommerceMoney.format(locale);
                this.shippingValueWithTaxAmount = finalOrderPriceShippingValueWithTaxAmountPrice.doubleValue();
                this.shippingValueWithTaxAmountFormatted = commerceOrderShippingValueWithTaxAmountCommerceMoney.format(locale);
                this.subtotal = finalOrderPriceSubtotalPrice.doubleValue();
                this.subtotalFormatted = commerceOrderPriceSubtotalCommerceMoney.format(locale);
                this.total = finalOrderPriceTotalPrice.doubleValue();
                this.totalFormatted = commerceOrderPriceTotalCommerceMoney.format(locale);
            }
        };
        BigDecimal taxAmount = commerceOrder.getTaxAmount();
        if (taxAmount != null) {
            summary.setTaxValue(Double.valueOf(taxAmount.doubleValue()));
            summary.setTaxValueFormatted(this._formatPrice(taxAmount, commerceCurrency, locale));
        }
        this._setShippingDiscountOnSummary(commerceOrder, commerceCurrency, locale, commerceChannel.getPriceDisplayType(), summary);
        this._setSubtotalDiscountOnSummary(commerceOrder, commerceCurrency, locale, commerceChannel.getPriceDisplayType(), summary);
        this._setTotalDiscountOnSummary(commerceOrder, commerceCurrency, locale, commerceChannel.getPriceDisplayType(), summary);
        return summary;
    }

    private Status _getWorkflowStatusInfo(final int orderStatus, final String commerceOrderWorkflowStatusLabel, final String commerceOrderWorkflowStatusLabelI18n) {
        return new Status(){
            {
                this.code = orderStatus;
                this.label = commerceOrderWorkflowStatusLabel;
                this.label_i18n = commerceOrderWorkflowStatusLabelI18n;
            }
        };
    }

    private void _setShippingDiscountOnSummary(CommerceOrder commerceOrder, CommerceCurrency commerceCurrency, Locale locale, String priceDisplayType, Summary summary) throws Exception {
        BigDecimal shippingDiscountAmount = commerceOrder.getShippingDiscountAmount();
        if (shippingDiscountAmount == null) {
            return;
        }
        BigDecimal shippingDiscountPercentageLevel1 = commerceOrder.getShippingDiscountPercentageLevel1();
        BigDecimal shippingDiscountPercentageLevel2 = commerceOrder.getShippingDiscountPercentageLevel2();
        BigDecimal shippingDiscountPercentageLevel3 = commerceOrder.getShippingDiscountPercentageLevel3();
        BigDecimal shippingDiscountPercentageLevel4 = commerceOrder.getShippingDiscountPercentageLevel4();
        if (Objects.equals(priceDisplayType, "tax-included")) {
            shippingDiscountAmount = commerceOrder.getShippingDiscountWithTaxAmount();
            shippingDiscountPercentageLevel1 = commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount();
            shippingDiscountPercentageLevel2 = commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount();
            shippingDiscountPercentageLevel3 = commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount();
            shippingDiscountPercentageLevel4 = commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount();
        }
        summary.setShippingDiscountPercentages(this._getFormattedDiscountPercentages(new BigDecimal[]{shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4}, locale));
        summary.setShippingDiscountValue(Double.valueOf(shippingDiscountAmount.doubleValue()));
        summary.setShippingDiscountValueFormatted(this._formatPrice(shippingDiscountAmount, commerceCurrency, locale));
    }

    private void _setSubtotalDiscountOnSummary(CommerceOrder commerceOrder, CommerceCurrency commerceCurrency, Locale locale, String priceDisplayType, Summary summary) throws Exception {
        BigDecimal subtotalDiscountAmount = commerceOrder.getSubtotalDiscountAmount();
        if (subtotalDiscountAmount == null) {
            return;
        }
        BigDecimal subtotalDiscountPercentageLevel1 = commerceOrder.getSubtotalDiscountPercentageLevel1();
        BigDecimal subtotalDiscountPercentageLevel2 = commerceOrder.getSubtotalDiscountPercentageLevel2();
        BigDecimal subtotalDiscountPercentageLevel3 = commerceOrder.getSubtotalDiscountPercentageLevel3();
        BigDecimal subtotalDiscountPercentageLevel4 = commerceOrder.getSubtotalDiscountPercentageLevel4();
        if (Objects.equals(priceDisplayType, "tax-included")) {
            subtotalDiscountAmount = commerceOrder.getSubtotalDiscountWithTaxAmount();
            subtotalDiscountPercentageLevel1 = commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount();
            subtotalDiscountPercentageLevel2 = commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount();
            subtotalDiscountPercentageLevel3 = commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount();
            subtotalDiscountPercentageLevel4 = commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount();
        }
        summary.setSubtotalDiscountPercentages(this._getFormattedDiscountPercentages(new BigDecimal[]{subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4}, locale));
        summary.setSubtotalDiscountValue(Double.valueOf(subtotalDiscountAmount.doubleValue()));
        summary.setSubtotalDiscountValueFormatted(this._formatPrice(subtotalDiscountAmount, commerceCurrency, locale));
    }

    private void _setTotalDiscountOnSummary(CommerceOrder commerceOrder, CommerceCurrency commerceCurrency, Locale locale, String priceDisplayType, Summary summary) throws Exception {
        BigDecimal totalDiscountAmount = commerceOrder.getTotalDiscountAmount();
        if (totalDiscountAmount == null) {
            return;
        }
        BigDecimal totalDiscountPercentageLevel1 = commerceOrder.getTotalDiscountPercentageLevel1();
        BigDecimal totalDiscountPercentageLevel2 = commerceOrder.getTotalDiscountPercentageLevel2();
        BigDecimal totalDiscountPercentageLevel3 = commerceOrder.getTotalDiscountPercentageLevel3();
        BigDecimal totalDiscountPercentageLevel4 = commerceOrder.getTotalDiscountPercentageLevel4();
        if (Objects.equals(priceDisplayType, "tax-included")) {
            totalDiscountAmount = commerceOrder.getTotalDiscountWithTaxAmount();
            totalDiscountPercentageLevel1 = commerceOrder.getTotalDiscountPercentageLevel1WithTaxAmount();
            totalDiscountPercentageLevel2 = commerceOrder.getTotalDiscountPercentageLevel2WithTaxAmount();
            totalDiscountPercentageLevel3 = commerceOrder.getTotalDiscountPercentageLevel3WithTaxAmount();
            totalDiscountPercentageLevel4 = commerceOrder.getTotalDiscountPercentageLevel4WithTaxAmount();
        }
        summary.setTotalDiscountPercentages(this._getFormattedDiscountPercentages(new BigDecimal[]{totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4}, locale));
        summary.setTotalDiscountValue(Double.valueOf(totalDiscountAmount.doubleValue()));
        summary.setTotalDiscountValueFormatted(this._formatPrice(totalDiscountAmount, commerceCurrency, locale));
    }
}

