/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderItemPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartItem;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Price;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Settings;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartItem"}, service={CartItemDTOConverter.class, DTOConverter.class})
public class CartItemDTOConverter
implements DTOConverter<CommerceOrderItem, CartItem> {
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public String getContentType() {
        return CartItem.class.getSimpleName();
    }

    public CartItem toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(((Long)dtoConverterContext.getId()).longValue());
        final Locale locale = dtoConverterContext.getLocale();
        final ExpandoBridge expandoBridge = commerceOrderItem.getExpandoBridge();
        final String languageId = LanguageUtil.getLanguageId((Locale)locale);
        return new CartItem(){
            {
                this.customFields = expandoBridge.getAttributes();
                this.errorMessages = CartItemDTOConverter.this._getErrorMessages(commerceOrderItem, locale);
                this.id = commerceOrderItem.getCommerceOrderItemId();
                this.name = commerceOrderItem.getName(languageId);
                this.options = commerceOrderItem.getJson();
                this.parentCartItemId = commerceOrderItem.getParentCommerceOrderItemId();
                this.price = CartItemDTOConverter.this._getPrice(commerceOrderItem, locale);
                this.productId = commerceOrderItem.getCProductId();
                this.quantity = commerceOrderItem.getQuantity();
                this.settings = CartItemDTOConverter.this._getSettings(commerceOrderItem.getCPInstanceId());
                this.sku = commerceOrderItem.getSku();
                this.skuId = commerceOrderItem.getCPInstanceId();
                this.subscription = commerceOrderItem.isSubscription();
                this.thumbnail = CartItemDTOConverter.this._cpInstanceHelper.getCPInstanceThumbnailSrc(commerceOrderItem.getCPInstanceId());
            }
        };
    }

    private String[] _getErrorMessages(CommerceOrderItem commerceOrderItem, Locale locale) {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
            return new String[]{LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-product-is-no-longer-available")};
        }
        return null;
    }

    private Price _getPrice(CommerceOrderItem commerceOrderItem, final Locale locale) throws Exception {
        CommerceMoney finalPriceCommerceMoney;
        BigDecimal finalPrice;
        BigDecimal discountAmount;
        CommerceMoney discountAmountCommerceMoney;
        BigDecimal unitPromoPrice;
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        final CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        CommerceOrderItemPrice commerceOrderItemPrice = this._commerceOrderPriceCalculation.getCommerceOrderItemPricePerUnit(commerceCurrency, commerceOrderItem);
        final CommerceMoney unitPriceCommerceMoney = commerceOrderItemPrice.getUnitPrice();
        final BigDecimal unitPrice = unitPriceCommerceMoney.getPrice();
        Price price = new Price(){
            {
                this.currency = commerceCurrency.getName(locale);
                this.price = unitPrice.doubleValue();
                this.priceFormatted = unitPriceCommerceMoney.format(locale);
            }
        };
        CommerceMoney promoPriceCommerceMoney = commerceOrderItemPrice.getPromoPrice();
        if (promoPriceCommerceMoney != null && (unitPromoPrice = promoPriceCommerceMoney.getPrice()) != null) {
            price.setPromoPrice(Double.valueOf(unitPromoPrice.doubleValue()));
            price.setPromoPriceFormatted(promoPriceCommerceMoney.format(locale));
        }
        if ((discountAmountCommerceMoney = commerceOrderItemPrice.getDiscountAmount()) != null && (discountAmount = discountAmountCommerceMoney.getPrice()) != null) {
            price.setDiscount(Double.valueOf(discountAmount.doubleValue()));
            price.setDiscountFormatted(discountAmountCommerceMoney.format(locale));
            price.setDiscountPercentage(this._commercePriceFormatter.format(commerceOrderItemPrice.getDiscountPercentage(), locale));
            BigDecimal discountPercentageLevel1 = commerceOrderItemPrice.getDiscountPercentageLevel1();
            BigDecimal discountPercentageLevel2 = commerceOrderItemPrice.getDiscountPercentageLevel2();
            BigDecimal discountPercentageLevel3 = commerceOrderItemPrice.getDiscountPercentageLevel3();
            BigDecimal discountPercentageLevel4 = commerceOrderItemPrice.getDiscountPercentageLevel4();
            price.setDiscountPercentageLevel1(Double.valueOf(discountPercentageLevel1.doubleValue()));
            price.setDiscountPercentageLevel2(Double.valueOf(discountPercentageLevel2.doubleValue()));
            price.setDiscountPercentageLevel3(Double.valueOf(discountPercentageLevel3.doubleValue()));
            price.setDiscountPercentageLevel4(Double.valueOf(discountPercentageLevel4.doubleValue()));
        }
        if ((finalPrice = (finalPriceCommerceMoney = commerceOrderItemPrice.getFinalPrice()).getPrice()) != null) {
            price.setFinalPriceFormatted(finalPriceCommerceMoney.format(locale));
            price.setFinalPrice(Double.valueOf(finalPrice.doubleValue()));
        }
        return price;
    }

    private Settings _getSettings(long cpInstanceId) {
        Settings settings = new Settings();
        int minOrderQuantity = 1;
        int maxOrderQuantity = 10000;
        int multipleQuantity = 1;
        CPDefinitionInventory cpDefinitionInventory = null;
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance != null) {
            cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        }
        if (cpDefinitionInventory != null) {
            minOrderQuantity = cpDefinitionInventory.getMinOrderQuantity();
            maxOrderQuantity = cpDefinitionInventory.getMaxOrderQuantity();
            multipleQuantity = cpDefinitionInventory.getMultipleOrderQuantity();
            int[] allowedOrderQuantitiesArray = cpDefinitionInventory.getAllowedOrderQuantitiesArray();
            if (allowedOrderQuantitiesArray != null && allowedOrderQuantitiesArray.length > 0) {
                settings.setAllowedQuantities(ArrayUtil.toArray((int[])allowedOrderQuantitiesArray));
            }
        }
        settings.setMinQuantity(Integer.valueOf(minOrderQuantity));
        settings.setMaxQuantity(Integer.valueOf(maxOrderQuantity));
        settings.setMultipleQuantity(Integer.valueOf(multipleQuantity));
        return settings;
    }
}

