/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.graphql.query.v1_0;

import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Address;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartComment;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartItem;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.PaymentMethod;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.ShippingMethod;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.AddressResource;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.CartCommentResource;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.CartItemResource;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.CartResource;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.PaymentMethodResource;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.ShippingMethodResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<AddressResource> _addressResourceComponentServiceObjects;
    private static ComponentServiceObjects<CartResource> _cartResourceComponentServiceObjects;
    private static ComponentServiceObjects<CartCommentResource> _cartCommentResourceComponentServiceObjects;
    private static ComponentServiceObjects<CartItemResource> _cartItemResourceComponentServiceObjects;
    private static ComponentServiceObjects<PaymentMethodResource> _paymentMethodResourceComponentServiceObjects;
    private static ComponentServiceObjects<ShippingMethodResource> _shippingMethodResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setAddressResourceComponentServiceObjects(ComponentServiceObjects<AddressResource> addressResourceComponentServiceObjects) {
        _addressResourceComponentServiceObjects = addressResourceComponentServiceObjects;
    }

    public static void setCartResourceComponentServiceObjects(ComponentServiceObjects<CartResource> cartResourceComponentServiceObjects) {
        _cartResourceComponentServiceObjects = cartResourceComponentServiceObjects;
    }

    public static void setCartCommentResourceComponentServiceObjects(ComponentServiceObjects<CartCommentResource> cartCommentResourceComponentServiceObjects) {
        _cartCommentResourceComponentServiceObjects = cartCommentResourceComponentServiceObjects;
    }

    public static void setCartItemResourceComponentServiceObjects(ComponentServiceObjects<CartItemResource> cartItemResourceComponentServiceObjects) {
        _cartItemResourceComponentServiceObjects = cartItemResourceComponentServiceObjects;
    }

    public static void setPaymentMethodResourceComponentServiceObjects(ComponentServiceObjects<PaymentMethodResource> paymentMethodResourceComponentServiceObjects) {
        _paymentMethodResourceComponentServiceObjects = paymentMethodResourceComponentServiceObjects;
    }

    public static void setShippingMethodResourceComponentServiceObjects(ComponentServiceObjects<ShippingMethodResource> shippingMethodResourceComponentServiceObjects) {
        _shippingMethodResourceComponentServiceObjects = shippingMethodResourceComponentServiceObjects;
    }

    @GraphQLField(description="Retrive cart billing address.")
    public @GraphQLField(description="Retrive cart billing address.") Address cartBillingAddres(@GraphQLName(value="cartId") Long cartId) throws Exception {
        return (Address)this._applyComponentServiceObjects(_addressResourceComponentServiceObjects, this::_populateResourceContext, addressResource -> addressResource.getCartBillingAddres(cartId));
    }

    @GraphQLField(description="Retrive cart billing address.")
    public @GraphQLField(description="Retrive cart billing address.") Address cartShippingAddres(@GraphQLName(value="cartId") Long cartId) throws Exception {
        return (Address)this._applyComponentServiceObjects(_addressResourceComponentServiceObjects, this::_populateResourceContext, addressResource -> addressResource.getCartShippingAddres(cartId));
    }

    @GraphQLField(description="Retrive information of the given Cart.")
    public @GraphQLField(description="Retrive information of the given Cart.") Cart cart(@GraphQLName(value="cartId") Long cartId) throws Exception {
        return (Cart)this._applyComponentServiceObjects(_cartResourceComponentServiceObjects, this::_populateResourceContext, cartResource -> cartResource.getCart(cartId));
    }

    @GraphQLField(description="Retrieves carts for specific account in the given channel.")
    public @GraphQLField(description="Retrieves carts for specific account in the given channel.") CartPage channelCarts(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CartPage)this._applyComponentServiceObjects(_cartResourceComponentServiceObjects, this::_populateResourceContext, cartResource -> new CartPage(cartResource.getChannelCartsPage(channelId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public CartComment cartComment(@GraphQLName(value="cartCommentId") Long cartCommentId) throws Exception {
        return (CartComment)this._applyComponentServiceObjects(_cartCommentResourceComponentServiceObjects, this::_populateResourceContext, cartCommentResource -> cartCommentResource.getCartComment(cartCommentId));
    }

    @GraphQLField
    public CartCommentPage cartComments(@GraphQLName(value="cartId") Long cartId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CartCommentPage)this._applyComponentServiceObjects(_cartCommentResourceComponentServiceObjects, this::_populateResourceContext, cartCommentResource -> new CartCommentPage(cartCommentResource.getCartCommentsPage(cartId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrive information of the given Cart")
    public @GraphQLField(description="Retrive information of the given Cart") CartItem cartItem(@GraphQLName(value="cartItemId") Long cartItemId) throws Exception {
        return (CartItem)this._applyComponentServiceObjects(_cartItemResourceComponentServiceObjects, this::_populateResourceContext, cartItemResource -> cartItemResource.getCartItem(cartItemId));
    }

    @GraphQLField(description="Retrive cart items of a Cart.")
    public @GraphQLField(description="Retrive cart items of a Cart.") CartItemPage cartItems(@GraphQLName(value="cartId") Long cartId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CartItemPage)this._applyComponentServiceObjects(_cartItemResourceComponentServiceObjects, this::_populateResourceContext, cartItemResource -> new CartItemPage(cartItemResource.getCartItemsPage(cartId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrive payment methods available for the Cart.")
    public @GraphQLField(description="Retrive payment methods available for the Cart.") PaymentMethodPage cartPaymentMethods(@GraphQLName(value="cartId") Long cartId) throws Exception {
        return (PaymentMethodPage)this._applyComponentServiceObjects(_paymentMethodResourceComponentServiceObjects, this::_populateResourceContext, paymentMethodResource -> new PaymentMethodPage(paymentMethodResource.getCartPaymentMethodsPage(cartId)));
    }

    @GraphQLField(description="Retrive payment methods available for the Cart.")
    public @GraphQLField(description="Retrive payment methods available for the Cart.") ShippingMethodPage cartShippingMethods(@GraphQLName(value="cartId") Long cartId) throws Exception {
        return (ShippingMethodPage)this._applyComponentServiceObjects(_shippingMethodResourceComponentServiceObjects, this::_populateResourceContext, shippingMethodResource -> new ShippingMethodPage(shippingMethodResource.getCartShippingMethodsPage(cartId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(AddressResource addressResource) throws Exception {
        addressResource.setContextAcceptLanguage(this._acceptLanguage);
        addressResource.setContextCompany(this._company);
        addressResource.setContextHttpServletRequest(this._httpServletRequest);
        addressResource.setContextHttpServletResponse(this._httpServletResponse);
        addressResource.setContextUriInfo(this._uriInfo);
        addressResource.setContextUser(this._user);
        addressResource.setGroupLocalService(this._groupLocalService);
        addressResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(CartResource cartResource) throws Exception {
        cartResource.setContextAcceptLanguage(this._acceptLanguage);
        cartResource.setContextCompany(this._company);
        cartResource.setContextHttpServletRequest(this._httpServletRequest);
        cartResource.setContextHttpServletResponse(this._httpServletResponse);
        cartResource.setContextUriInfo(this._uriInfo);
        cartResource.setContextUser(this._user);
        cartResource.setGroupLocalService(this._groupLocalService);
        cartResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(CartCommentResource cartCommentResource) throws Exception {
        cartCommentResource.setContextAcceptLanguage(this._acceptLanguage);
        cartCommentResource.setContextCompany(this._company);
        cartCommentResource.setContextHttpServletRequest(this._httpServletRequest);
        cartCommentResource.setContextHttpServletResponse(this._httpServletResponse);
        cartCommentResource.setContextUriInfo(this._uriInfo);
        cartCommentResource.setContextUser(this._user);
        cartCommentResource.setGroupLocalService(this._groupLocalService);
        cartCommentResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(CartItemResource cartItemResource) throws Exception {
        cartItemResource.setContextAcceptLanguage(this._acceptLanguage);
        cartItemResource.setContextCompany(this._company);
        cartItemResource.setContextHttpServletRequest(this._httpServletRequest);
        cartItemResource.setContextHttpServletResponse(this._httpServletResponse);
        cartItemResource.setContextUriInfo(this._uriInfo);
        cartItemResource.setContextUser(this._user);
        cartItemResource.setGroupLocalService(this._groupLocalService);
        cartItemResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(PaymentMethodResource paymentMethodResource) throws Exception {
        paymentMethodResource.setContextAcceptLanguage(this._acceptLanguage);
        paymentMethodResource.setContextCompany(this._company);
        paymentMethodResource.setContextHttpServletRequest(this._httpServletRequest);
        paymentMethodResource.setContextHttpServletResponse(this._httpServletResponse);
        paymentMethodResource.setContextUriInfo(this._uriInfo);
        paymentMethodResource.setContextUser(this._user);
        paymentMethodResource.setGroupLocalService(this._groupLocalService);
        paymentMethodResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ShippingMethodResource shippingMethodResource) throws Exception {
        shippingMethodResource.setContextAcceptLanguage(this._acceptLanguage);
        shippingMethodResource.setContextCompany(this._company);
        shippingMethodResource.setContextHttpServletRequest(this._httpServletRequest);
        shippingMethodResource.setContextHttpServletResponse(this._httpServletResponse);
        shippingMethodResource.setContextUriInfo(this._uriInfo);
        shippingMethodResource.setContextUser(this._user);
        shippingMethodResource.setGroupLocalService(this._groupLocalService);
        shippingMethodResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLTypeExtension(value=CartItem.class)
    public class ParentCartItemCartItemIdTypeExtension {
        private CartItem _cartItem;

        public ParentCartItemCartItemIdTypeExtension(CartItem cartItem) {
            this._cartItem = cartItem;
        }

        @GraphQLField(description="Retrive information of the given Cart")
        public @GraphQLField(description="Retrive information of the given Cart") CartItem parentCartItem() throws Exception {
            if (this._cartItem.getParentCartItemId() == null) {
                return null;
            }
            return (CartItem)Query.this._applyComponentServiceObjects(_cartItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), cartItemResource -> cartItemResource.getCartItem(this._cartItem.getParentCartItemId()));
        }
    }

    @GraphQLName(value="ShippingMethodPage")
    public class ShippingMethodPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<ShippingMethod> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ShippingMethodPage(Page shippingMethodPage) {
            this.actions = shippingMethodPage.getActions();
            this.items = shippingMethodPage.getItems();
            this.lastPage = shippingMethodPage.getLastPage();
            this.page = shippingMethodPage.getPage();
            this.pageSize = shippingMethodPage.getPageSize();
            this.totalCount = shippingMethodPage.getTotalCount();
        }
    }

    @GraphQLName(value="PaymentMethodPage")
    public class PaymentMethodPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<PaymentMethod> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public PaymentMethodPage(Page paymentMethodPage) {
            this.actions = paymentMethodPage.getActions();
            this.items = paymentMethodPage.getItems();
            this.lastPage = paymentMethodPage.getLastPage();
            this.page = paymentMethodPage.getPage();
            this.pageSize = paymentMethodPage.getPageSize();
            this.totalCount = paymentMethodPage.getTotalCount();
        }
    }

    @GraphQLName(value="CartItemPage")
    public class CartItemPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<CartItem> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CartItemPage(Page cartItemPage) {
            this.actions = cartItemPage.getActions();
            this.items = cartItemPage.getItems();
            this.lastPage = cartItemPage.getLastPage();
            this.page = cartItemPage.getPage();
            this.pageSize = cartItemPage.getPageSize();
            this.totalCount = cartItemPage.getTotalCount();
        }
    }

    @GraphQLName(value="CartCommentPage")
    public class CartCommentPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<CartComment> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CartCommentPage(Page cartCommentPage) {
            this.actions = cartCommentPage.getActions();
            this.items = cartCommentPage.getItems();
            this.lastPage = cartCommentPage.getLastPage();
            this.page = cartCommentPage.getPage();
            this.pageSize = cartCommentPage.getPageSize();
            this.totalCount = cartCommentPage.getTotalCount();
        }
    }

    @GraphQLName(value="CartPage")
    public class CartPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Cart> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CartPage(Page cartPage) {
            this.actions = cartPage.getActions();
            this.items = cartPage.getItems();
            this.lastPage = cartPage.getLastPage();
            this.page = cartPage.getPage();
            this.pageSize = cartPage.getPageSize();
            this.totalCount = cartPage.getTotalCount();
        }
    }

    @GraphQLName(value="AddressPage")
    public class AddressPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Address> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AddressPage(Page addressPage) {
            this.actions = addressPage.getActions();
            this.items = addressPage.getItems();
            this.lastPage = addressPage.getLastPage();
            this.page = addressPage.getPage();
            this.pageSize = addressPage.getPageSize();
            this.totalCount = addressPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=Cart.class)
    public class GetCartBillingAddresTypeExtension {
        private Cart _cart;

        public GetCartBillingAddresTypeExtension(Cart cart) {
            this._cart = cart;
        }

        @GraphQLField(description="Retrive cart billing address.")
        public @GraphQLField(description="Retrive cart billing address.") Address billingAddres() throws Exception {
            return (Address)Query.this._applyComponentServiceObjects(_addressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), addressResource -> addressResource.getCartBillingAddres(this._cart.getId()));
        }
    }

    @GraphQLTypeExtension(value=Cart.class)
    public class GetCartItemsPageTypeExtension {
        private Cart _cart;

        public GetCartItemsPageTypeExtension(Cart cart) {
            this._cart = cart;
        }

        @GraphQLField(description="Retrive cart items of a Cart.")
        public @GraphQLField(description="Retrive cart items of a Cart.") CartItemPage items(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (CartItemPage)Query.this._applyComponentServiceObjects(_cartItemResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), cartItemResource -> new CartItemPage(cartItemResource.getCartItemsPage(this._cart.getId(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=Cart.class)
    public class GetCartShippingMethodsPageTypeExtension {
        private Cart _cart;

        public GetCartShippingMethodsPageTypeExtension(Cart cart) {
            this._cart = cart;
        }

        @GraphQLField(description="Retrive payment methods available for the Cart.")
        public @GraphQLField(description="Retrive payment methods available for the Cart.") ShippingMethodPage shippingMethods() throws Exception {
            return (ShippingMethodPage)Query.this._applyComponentServiceObjects(_shippingMethodResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), shippingMethodResource -> new ShippingMethodPage(shippingMethodResource.getCartShippingMethodsPage(this._cart.getId())));
        }
    }

    @GraphQLTypeExtension(value=Cart.class)
    public class GetCartShippingAddresTypeExtension {
        private Cart _cart;

        public GetCartShippingAddresTypeExtension(Cart cart) {
            this._cart = cart;
        }

        @GraphQLField(description="Retrive cart billing address.")
        public @GraphQLField(description="Retrive cart billing address.") Address shippingAddres() throws Exception {
            return (Address)Query.this._applyComponentServiceObjects(_addressResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), addressResource -> addressResource.getCartShippingAddres(this._cart.getId()));
        }
    }

    @GraphQLTypeExtension(value=Cart.class)
    public class GetCartCommentsPageTypeExtension {
        private Cart _cart;

        public GetCartCommentsPageTypeExtension(Cart cart) {
            this._cart = cart;
        }

        @GraphQLField
        public CartCommentPage comments(@GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
            return (CartCommentPage)Query.this._applyComponentServiceObjects(_cartCommentResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), cartCommentResource -> new CartCommentPage(cartCommentResource.getCartCommentsPage(this._cart.getId(), Pagination.of((int)page, (int)pageSize))));
        }
    }

    @GraphQLTypeExtension(value=Cart.class)
    public class GetCartPaymentMethodsPageTypeExtension {
        private Cart _cart;

        public GetCartPaymentMethodsPageTypeExtension(Cart cart) {
            this._cart = cart;
        }

        @GraphQLField(description="Retrive payment methods available for the Cart.")
        public @GraphQLField(description="Retrive payment methods available for the Cart.") PaymentMethodPage paymentMethods() throws Exception {
            return (PaymentMethodPage)Query.this._applyComponentServiceObjects(_paymentMethodResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), paymentMethodResource -> new PaymentMethodPage(paymentMethodResource.getCartPaymentMethodsPage(this._cart.getId())));
        }
    }
}

