/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Address;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart;
import com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0.AddressDTOConverter;
import com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0.BaseAddressResourceImpl;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.AddressResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/address.properties"}, scope=ServiceScope.PROTOTYPE, service={AddressResource.class, NestedFieldSupport.class})
public class AddressResourceImpl
extends BaseAddressResourceImpl
implements NestedFieldSupport {
    @Reference
    private AddressDTOConverter _addressDTOConverter;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceOrderService _commerceOrderService;

    @Override
    @NestedField(parentClass=Cart.class, value="billingAddress")
    public Address getCartBillingAddres(@NestedFieldId(value="id") Long cartId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(commerceOrder.getBillingAddressId());
        return this._addressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Cart.class, value="shippingAddress")
    public Address getCartShippingAddres(@NestedFieldId(value="id") Long cartId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(commerceOrder.getShippingAddressId());
        return this._addressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

