/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.CommerceOrderNoteService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartComment;
import com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0.NoteDTOConverter;
import com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0.BaseCartCommentResourceImpl;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.CartCommentResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/cart-comment.properties"}, scope=ServiceScope.PROTOTYPE, service={CartCommentResource.class, NestedFieldSupport.class})
public class CartCommentResourceImpl
extends BaseCartCommentResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceOrderNoteService _commerceOrderNoteService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private NoteDTOConverter _noteDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteCartComment(Long commentId) throws Exception {
        this._commerceOrderNoteService.deleteCommerceOrderNote(commentId.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public CartComment getCartComment(Long commentId) throws Exception {
        return this._toOrderNote(GetterUtil.getLong((Object)commentId));
    }

    @Override
    @NestedField(parentClass=Cart.class, value="notes")
    public Page<CartComment> getCartCommentsPage(@NestedFieldId(value="id") Long cartId, Pagination pagination) throws Exception {
        List commerceOrderNotes = this._commerceOrderNoteService.getCommerceOrderNotes(cartId.longValue(), false);
        int totalItems = this._commerceOrderNoteService.getCommerceOrderNotesCount(cartId.longValue(), false);
        return Page.of(this._toOrderNotes(commerceOrderNotes), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public CartComment postCartComment(Long cartId, CartComment cartComment) throws Exception {
        return this._addOrUpdateOrderNote(this._commerceOrderService.getCommerceOrder(cartId.longValue()), cartComment);
    }

    @Override
    public CartComment putCartComment(Long commentId, CartComment cartComment) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.getCommerceOrderNote(commentId.longValue());
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderNote.getCommerceOrderId());
        cartComment.setId(commentId);
        return this._addOrUpdateOrderNote(commerceOrder, cartComment);
    }

    private CartComment _addOrUpdateOrderNote(CommerceOrder commerceOrder, CartComment cartComment) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.addOrUpdateCommerceOrderNote(null, GetterUtil.get((Object)cartComment.getId(), (long)0L), commerceOrder.getCommerceOrderId(), cartComment.getContent(), GetterUtil.get((Object)cartComment.getRestricted(), (boolean)false), this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId()));
        return this._toOrderNote(commerceOrderNote.getCommerceOrderNoteId());
    }

    private CartComment _toOrderNote(Long commerceOrderNoteId) throws Exception {
        return this._noteDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderNoteId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<CartComment> _toOrderNotes(List<CommerceOrderNote> commerceOrderNotes) throws Exception {
        ArrayList<CartComment> orders = new ArrayList<CartComment>();
        for (CommerceOrderNote commerceOrderNote : commerceOrderNotes) {
            orders.add(this._toOrderNote(commerceOrderNote.getCommerceOrderNoteId()));
        }
        return orders;
    }
}

