/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartItem;
import com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0.CartItemDTOConverter;
import com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0.BaseCartItemResourceImpl;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.CartItemResource;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/cart-item.properties"}, scope=ServiceScope.PROTOTYPE, service={CartItemResource.class, NestedFieldSupport.class})
public class CartItemResourceImpl
extends BaseCartItemResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CartItemDTOConverter _orderItemDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteCartItem(Long cartItemId) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(cartItemId.longValue());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
        this._commerceOrderItemService.deleteCommerceOrderItem(cartItemId.longValue(), commerceContext);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public CartItem getCartItem(Long cartItemId) throws Exception {
        return this._toCartItem(this._commerceOrderItemService.getCommerceOrderItem(cartItemId.longValue()));
    }

    @Override
    @NestedField(parentClass=Cart.class, value="cartItems")
    public Page<CartItem> getCartItemsPage(@NestedFieldId(value="id") Long cartId, Pagination pagination) throws Exception {
        return Page.of(this._toCartItems(this._commerceOrderItemService.getCommerceOrderItems(cartId.longValue(), -1, -1)));
    }

    @Override
    public CartItem patchCartItem(Long cartItemId, CartItem cartItem) throws Exception {
        return super.patchCartItem(cartItemId, cartItem);
    }

    @Override
    public CartItem postCartItem(Long cartId, CartItem cartItem) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId());
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), cartId.longValue(), commerceOrder.getCommerceAccountId());
        return this._toCartItem(this._commerceOrderItemService.addOrUpdateCommerceOrderItem(commerceOrder.getCommerceOrderId(), cartItem.getSkuId().longValue(), cartItem.getOptions(), cartItem.getQuantity().intValue(), 0, commerceContext, serviceContext));
    }

    @Override
    public CartItem putCartItem(Long cartItemId, CartItem cartItem) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(cartItemId.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceOrderItem.getGroupId());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
        return this._toCartItem(this._commerceOrderItemService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), cartItem.getQuantity().intValue(), commerceContext, serviceContext));
    }

    private List<CartItem> _handleProductBundle(List<CartItem> cartItems) {
        HashMap<Long, CartItem> cartItemMap = new HashMap<Long, CartItem>();
        for (CartItem cartItem : cartItems) {
            cartItemMap.put(cartItem.getId(), cartItem);
        }
        for (CartItem cartItem : cartItems) {
            CartItem parent;
            Long parentId = cartItem.getParentCartItemId();
            if (parentId == null || (parent = (CartItem)cartItemMap.get(parentId)) == null) continue;
            if (parent.getCartItems() == null) {
                parent.setCartItems(new CartItem[0]);
            }
            parent.setCartItems((CartItem[])ArrayUtil.append((Object[])parent.getCartItems(), (Object)cartItem));
            cartItemMap.remove(cartItem.getId());
        }
        return new ArrayList<CartItem>(cartItemMap.values());
    }

    private CartItem _toCartItem(CommerceOrderItem commerceOrderItem) throws Exception {
        return this._orderItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderItem.getCommerceOrderItemId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<CartItem> _toCartItems(List<CommerceOrderItem> commerceOrderItems) throws Exception {
        ArrayList<CartItem> cartItems = new ArrayList<CartItem>();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            cartItems.add(this._toCartItem(commerceOrderItem));
        }
        return this._handleProductBundle(cartItems);
    }
}

