/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.exception.CommerceOrderBillingAddressException;
import com.liferay.commerce.exception.CommerceOrderGuestCheckoutException;
import com.liferay.commerce.exception.CommerceOrderShippingAddressException;
import com.liferay.commerce.exception.CommerceOrderShippingMethodException;
import com.liferay.commerce.exception.CommerceOrderStatusException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Address;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.Cart;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CartItem;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.CouponCode;
import com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0.CartDTOConverter;
import com.liferay.headless.commerce.delivery.cart.internal.dto.v1_0.CartItemDTOConverter;
import com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0.BaseCartResourceImpl;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.CartResource;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/cart.properties"}, scope=ServiceScope.PROTOTYPE, service={CartResource.class})
public class CartResourceImpl
extends BaseCartResourceImpl {
    @Reference
    private CartDTOConverter _cartDTOConverter;
    @Reference
    private CartItemDTOConverter _cartItemDTOConverter;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    @Reference
    private CommerceShippingHelper _commerceShippingHelper;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CountryService _countryService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private RegionLocalService _regionLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteCart(Long cartId) throws Exception {
        this._commerceOrderService.deleteCommerceOrder(cartId.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Cart getCart(Long cartId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        return this._toCart(commerceOrder);
    }

    @Override
    public Page<Cart> getChannelCartsPage(Long channelId, Pagination pagination) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        List commerceOrders = this._commerceOrderService.getUserPendingCommerceOrders(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), null, pagination.getStartPosition(), pagination.getEndPosition());
        long pendingCommerceOrdersCount = this._commerceOrderService.getPendingCommerceOrdersCount(this.contextCompany.getCompanyId(), commerceChannel.getGroupId());
        return Page.of(this._toCarts(commerceOrders), (Pagination)pagination, (long)pendingCommerceOrdersCount);
    }

    @Override
    public Cart patchCart(Long cartId, Cart cart) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        this._updateOrder(commerceOrder, cart);
        return this._toCart(commerceOrder);
    }

    @Override
    public Cart postCartCheckout(Long cartId) throws Exception {
        Cart cart;
        block7: {
            CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
            cart = this._validateOrder(commerceOrder);
            if (cart.getValid().booleanValue()) {
                try {
                    commerceOrder = this._commerceOrderEngine.checkoutCommerceOrder(commerceOrder, this.contextUser.getUserId());
                    cart = this._toCart(commerceOrder);
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof CommerceOrderBillingAddressException) {
                        cart.setValid(Boolean.valueOf(false));
                        cart.setErrorMessages(new String[]{"Invalid billing address"});
                    }
                    if (exception.getCause() instanceof CommerceOrderGuestCheckoutException) {
                        cart.setValid(Boolean.valueOf(false));
                        cart.setErrorMessages(new String[]{"Invalid guest checkout"});
                    }
                    if (exception.getCause() instanceof CommerceOrderShippingAddressException) {
                        cart.setValid(Boolean.valueOf(false));
                        cart.setErrorMessages(new String[]{"Invalid shipping address"});
                    }
                    if (exception.getCause() instanceof CommerceOrderShippingMethodException) {
                        cart.setValid(Boolean.valueOf(false));
                        cart.setErrorMessages(new String[]{"Invalid shipping method"});
                    }
                    if (!(exception.getCause() instanceof CommerceOrderStatusException)) break block7;
                    cart.setValid(Boolean.valueOf(false));
                    cart.setErrorMessages(new String[]{"Invalid cart status"});
                }
            }
        }
        return cart;
    }

    @Override
    public Cart postCartCouponCode(Long cartId, CouponCode couponCode) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
        return this._toCart(this._commerceOrderService.applyCouponCode(cartId.longValue(), couponCode.getCode(), commerceContext));
    }

    @Override
    public Cart postChannelCart(Long channelId, Cart cart) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        CommerceOrder commerceOrder = this._addCommerceOrder(cart, commerceChannel.getGroupId(), this.contextUser.getUserId());
        this._updateOrder(commerceOrder, cart);
        return this._toCart(commerceOrder);
    }

    @Override
    public Cart putCart(Long cartId, Cart cart) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        this._updateOrder(commerceOrder, cart);
        return this._toCart(commerceOrder);
    }

    private CommerceAddress _addCommerceAddress(CommerceOrder commerceOrder, Address address, int type, ServiceContext serviceContext) throws Exception {
        Country country = this._countryService.getCountryByA2(commerceOrder.getCompanyId(), address.getCountryISOCode());
        return this._commerceAddressService.addCommerceAddress(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), address.getName(), address.getDescription(), address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), this._getRegionId(null, country, address), country.getCountryId(), address.getPhoneNumber(), type, serviceContext);
    }

    private CommerceOrder _addCommerceOrder(Cart cart, long commerceChannelGroupId, long userId) throws Exception {
        long commerceCurrencyId = 0L;
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(this.contextCompany.getCompanyId(), cart.getCurrencyCode());
        if (commerceCurrency != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        CommerceAccount commerceAccount = this._commerceAccountService.getCommerceAccount(cart.getAccountId().longValue());
        return this._commerceOrderService.addCommerceOrder(userId, commerceChannelGroupId, commerceAccount.getCommerceAccountId(), commerceCurrencyId);
    }

    private void _addOrUpdateBillingAddress(CommerceOrder commerceOrder, Address address, int type, CommerceContext commerceContext, ServiceContext serviceContext) throws Exception {
        if (commerceOrder.getBillingAddressId() > 0L) {
            this._updateCommerceOrderAddress(commerceOrder, address, type, serviceContext);
        } else {
            CommerceAddress commerceAddress = this._addCommerceAddress(commerceOrder, address, type, serviceContext);
            commerceOrder.setBillingAddressId(commerceAddress.getCommerceAddressId());
        }
        this._commerceOrderService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommercePaymentMethodKey(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), commerceContext);
    }

    private void _addOrUpdateCommerceOrderItem(CartItem cartItem, CommerceOrder commerceOrder, CommerceContext commerceContext, ServiceContext serviceContext) throws Exception {
        CPInstance cpInstance = null;
        if (cartItem.getSkuId() != null) {
            cpInstance = this._cpInstanceLocalService.getCPInstance(cartItem.getSkuId().longValue());
        }
        this._commerceOrderItemService.addOrUpdateCommerceOrderItem(commerceOrder.getCommerceOrderId(), cpInstance.getCPInstanceId(), cartItem.getOptions(), GetterUtil.get((Object)cartItem.getQuantity(), (int)1), 0, commerceContext, serviceContext);
    }

    private void _addOrUpdateNestedResources(Cart cart, CommerceOrder commerceOrder, CommerceContext commerceContext) throws Exception {
        Address shippingAddress;
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceOrder.getGroupId());
        CartItem[] orderItems = cart.getCartItems();
        if (orderItems != null) {
            this._commerceOrderItemService.deleteCommerceOrderItems(commerceOrder.getCommerceOrderId());
            for (CartItem cartItem : orderItems) {
                this._addOrUpdateCommerceOrderItem(cartItem, commerceOrder, commerceContext, serviceContext);
            }
            commerceOrder = this._commerceOrderService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        }
        commerceOrder.setBillingAddressId((long)GetterUtil.get((Object)cart.getBillingAddressId(), (int)0));
        commerceOrder.setShippingAddressId((long)GetterUtil.get((Object)cart.getShippingAddressId(), (int)0));
        boolean useAsBilling = GetterUtil.get((Object)cart.getUseAsBilling(), (boolean)false);
        int type = 3;
        if (useAsBilling) {
            type = 2;
        }
        if ((shippingAddress = cart.getShippingAddress()) != null) {
            commerceOrder = this._addOrUpdateShippingAddress(commerceOrder, shippingAddress, type, commerceContext, serviceContext);
        }
        if (useAsBilling) {
            this._commerceOrderService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), commerceOrder.getShippingAddressId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommercePaymentMethodKey(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), commerceContext);
        } else {
            Address billingAddress = cart.getBillingAddress();
            if (billingAddress != null) {
                this._addOrUpdateBillingAddress(commerceOrder, billingAddress, 1, commerceContext, serviceContext);
            }
        }
    }

    private CommerceOrder _addOrUpdateShippingAddress(CommerceOrder commerceOrder, Address address, int type, CommerceContext commerceContext, ServiceContext serviceContext) throws Exception {
        if (commerceOrder.getShippingAddressId() > 0L) {
            this._updateCommerceOrderAddress(commerceOrder, address, type, serviceContext);
        } else {
            CommerceAddress commerceAddress = this._addCommerceAddress(commerceOrder, address, type, serviceContext);
            commerceOrder.setShippingAddressId(commerceAddress.getCommerceAddressId());
        }
        return this._commerceOrderService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommercePaymentMethodKey(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), commerceContext);
    }

    private long _getRegionId(CommerceAddress commerceAddress, Country country, Address address) throws Exception {
        if (Validator.isNull((String)address.getRegionISOCode()) && commerceAddress != null) {
            return commerceAddress.getRegionId();
        }
        if (Validator.isNull((String)address.getRegionISOCode()) || country == null) {
            return 0L;
        }
        Region region = this._regionLocalService.getRegion(country.getCountryId(), address.getRegionISOCode());
        return region.getRegionId();
    }

    private CartItem[] _getValidatedCommerceOrderItems(CommerceOrder commerceOrder, Cart cart) throws Exception {
        ArrayList<CartItem> cartItems = new ArrayList<CartItem>();
        Map commerceOrderValidatorResults = this._commerceOrderValidatorRegistry.getCommerceOrderValidatorResults(null, commerceOrder);
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            CartItem cartItem = this._cartItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrderItem.getCommerceOrderItemId(), this.contextAcceptLanguage.getPreferredLocale()));
            if (commerceOrderValidatorResults.containsKey(commerceOrderItem.getCommerceOrderItemId())) {
                List commerceOrderItemValidatorResults = (List)commerceOrderValidatorResults.get(commerceOrderItem.getCommerceOrderItemId());
                Stream commerceOrderValidatorResultStream = commerceOrderItemValidatorResults.stream();
                boolean cartItemValid = commerceOrderValidatorResultStream.map(commerceOrderItemValidatorResult -> commerceOrderItemValidatorResult.isValid()).reduce(true, Boolean::logicalAnd);
                cartItem.setValid(Boolean.valueOf(cartItemValid));
                cart.setValid(Boolean.valueOf(cartItemValid));
                commerceOrderValidatorResultStream = commerceOrderItemValidatorResults.stream();
                cartItem.setErrorMessages((String[])commerceOrderValidatorResultStream.map(commerceOrderItemValidatorResult -> commerceOrderItemValidatorResult.getLocalizedMessage()).toArray(String[]::new));
            }
            cartItems.add(cartItem);
        }
        return cartItems.toArray(new CartItem[0]);
    }

    private Cart _toCart(CommerceOrder commerceOrder) throws Exception {
        return this._cartDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceOrder.getCommerceOrderId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<Cart> _toCarts(List<CommerceOrder> commerceOrders) throws Exception {
        ArrayList<Cart> carts = new ArrayList<Cart>();
        for (CommerceOrder commerceOrder : commerceOrders) {
            carts.add(this._toCart(commerceOrder));
        }
        return carts;
    }

    private void _updateCommerceOrderAddress(CommerceOrder commerceOrder, Address address, int type, ServiceContext serviceContext) throws Exception {
        CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(commerceOrder.getShippingAddressId());
        Country country = commerceAddress.getCountry();
        this._commerceAddressService.updateCommerceAddress(commerceAddress.getCommerceAddressId(), address.getName(), GetterUtil.get((String)address.getDescription(), (String)commerceAddress.getDescription()), address.getStreet1(), GetterUtil.get((String)address.getStreet2(), (String)commerceAddress.getStreet2()), GetterUtil.get((String)address.getStreet3(), (String)commerceAddress.getStreet3()), address.getCity(), GetterUtil.get((String)address.getZip(), (String)commerceAddress.getZip()), this._getRegionId(commerceAddress, country, address), country.getCountryId(), GetterUtil.get((String)address.getPhoneNumber(), (String)commerceAddress.getPhoneNumber()), type, serviceContext);
    }

    private void _updateOrder(CommerceOrder commerceOrder, Cart cart) throws Exception {
        long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceOrder.getGroupId(), cart.getShippingMethod());
        if (commerceShippingMethod != null) {
            commerceShippingMethodId = commerceShippingMethod.getCommerceShippingMethodId();
        }
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceOrder.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
        commerceOrder = this._commerceOrderService.updateCommerceOrder(commerceOrder.getCommerceOrderId(), GetterUtil.get((Object)cart.getBillingAddressId(), (long)commerceOrder.getBillingAddressId()), GetterUtil.get((Object)cart.getShippingAddressId(), (long)commerceOrder.getShippingAddressId()), GetterUtil.get((String)cart.getPaymentMethod(), (String)commerceOrder.getCommercePaymentMethodKey()), commerceShippingMethodId, GetterUtil.get((String)cart.getShippingOption(), (String)commerceOrder.getShippingOptionName()), commerceOrder.getPurchaseOrderNumber(), commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), commerceOrder.getAdvanceStatus(), commerceContext);
        Map customFields = cart.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommerceOrder.class, (long)commerceOrder.getPrimaryKey(), (Map)customFields);
        }
        this._addOrUpdateNestedResources(cart, commerceOrder, commerceContext);
    }

    private Cart _validateOrder(CommerceOrder commerceOrder) throws Exception {
        ArrayList errorMessages = new ArrayList();
        Cart cart = this._toCart(commerceOrder);
        cart.setValid(Boolean.valueOf(true));
        if (!errorMessages.isEmpty()) {
            cart.setValid(Boolean.valueOf(false));
            cart.setErrorMessages(errorMessages.toArray(new String[0]));
        }
        CartItem[] validatedCartItems = this._getValidatedCommerceOrderItems(commerceOrder, cart);
        cart.setCartItems(validatedCartItems);
        return cart;
    }
}

