/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.PaymentMethod;
import com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0.BasePaymentMethodResourceImpl;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.PaymentMethodResource;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/payment-method.properties"}, scope=ServiceScope.PROTOTYPE, service={PaymentMethodResource.class})
public class PaymentMethodResourceImpl
extends BasePaymentMethodResourceImpl {
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;

    @Override
    public Page<PaymentMethod> getCartPaymentMethodsPage(Long cartId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        return Page.of(this.transform(this._commercePaymentEngine.getEnabledCommercePaymentMethodsForOrder(commerceOrder.getGroupId(), cartId.longValue()), this::_toPaymentMethod));
    }

    private PaymentMethod _toPaymentMethod(final CommercePaymentMethod commercePaymentMethod) {
        final Locale locale = this.contextAcceptLanguage.getPreferredLocale();
        return new PaymentMethod(){
            {
                this.description = commercePaymentMethod.getDescription(locale);
                this.key = commercePaymentMethod.getKey();
                this.name = commercePaymentMethod.getName(locale);
            }
        };
    }
}

