/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOption;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.commerce.util.comparator.CommerceShippingOptionLabelComparator;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.ShippingMethod;
import com.liferay.headless.commerce.delivery.cart.dto.v1_0.ShippingOption;
import com.liferay.headless.commerce.delivery.cart.internal.resource.v1_0.BaseShippingMethodResourceImpl;
import com.liferay.headless.commerce.delivery.cart.resource.v1_0.ShippingMethodResource;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/shipping-method.properties"}, scope=ServiceScope.PROTOTYPE, service={ShippingMethodResource.class})
public class ShippingMethodResourceImpl
extends BaseShippingMethodResourceImpl {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;

    @Override
    public Page<ShippingMethod> getCartShippingMethodsPage(Long cartId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(cartId.longValue());
        CommerceAddress shippingCommerceAddress = commerceOrder.getShippingAddress();
        if (shippingCommerceAddress != null) {
            CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
            return Page.of(this.transform(this._commerceShippingMethodLocalService.getCommerceShippingMethods(commerceChannel.getGroupId(), shippingCommerceAddress.getCountryId(), true), shippingMethod -> this._toShippingMethod((CommerceShippingMethod)shippingMethod, commerceChannel, commerceOrder)));
        }
        return super.getCartShippingMethodsPage(cartId);
    }

    private ShippingOption[] _getShippingOptions(CommerceShippingMethod commerceShippingMethod, CommerceChannel commerceChannel, CommerceOrder commerceOrder) throws PortalException {
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), this.contextUser.getUserId(), commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId());
        CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(commerceShippingMethod.getEngineKey());
        List commerceShippingOptions = commerceShippingEngine.getCommerceShippingOptions(commerceContext, commerceOrder, this.contextAcceptLanguage.getPreferredLocale());
        return (ShippingOption[])this.transformToArray(ListUtil.sort((List)commerceShippingOptions, (Comparator)new CommerceShippingOptionLabelComparator()), shippingOption -> this._toShippingOption((CommerceShippingOption)shippingOption, commerceContext), ShippingOption.class);
    }

    private ShippingMethod _toShippingMethod(final CommerceShippingMethod commerceShippingMethod, final CommerceChannel commerceChannel, final CommerceOrder commerceOrder) throws PortalException {
        return new ShippingMethod(){
            {
                this.description = commerceShippingMethod.getDescription(ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = commerceShippingMethod.getCommerceShippingMethodId();
                this.name = commerceShippingMethod.getName(ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.shippingOptions = ShippingMethodResourceImpl.this._getShippingOptions(commerceShippingMethod, commerceChannel, commerceOrder);
            }
        };
    }

    private ShippingOption _toShippingOption(final CommerceShippingOption commerceShippingOption, final CommerceContext commerceContext) throws PortalException {
        final BigDecimal commerceShippingOptionAmount = commerceShippingOption.getAmount();
        return new ShippingOption(){
            {
                this.amount = commerceShippingOptionAmount.doubleValue();
                this.amountFormatted = ShippingMethodResourceImpl.this._commercePriceFormatter.format(commerceContext.getCommerceCurrency(), commerceShippingOption.getAmount(), ShippingMethodResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.label = commerceShippingOption.getLabel();
                this.name = commerceShippingOption.getName();
            }
        };
    }
}

