/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.client.serdes.v1_0;

import com.liferay.headless.commerce.delivery.catalog.client.dto.v1_0.Sku;
import com.liferay.headless.commerce.delivery.catalog.client.json.BaseJSONParser;
import com.liferay.headless.commerce.delivery.catalog.client.serdes.v1_0.AvailabilitySerDes;
import com.liferay.headless.commerce.delivery.catalog.client.serdes.v1_0.PriceSerDes;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class SkuSerDes {
    public static Sku toDTO(String json) {
        SkuJSONParser skuJSONParser = new SkuJSONParser();
        return (Sku)skuJSONParser.parseToDTO(json);
    }

    public static Sku[] toDTOs(String json) {
        SkuJSONParser skuJSONParser = new SkuJSONParser();
        return (Sku[])skuJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Sku sku) {
        if (sku == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (sku.getAllowedOrderQuantities() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"allowedOrderQuantities\": ");
            sb.append("[");
            for (int i = 0; i < sku.getAllowedOrderQuantities().length; ++i) {
                sb.append("\"");
                sb.append(SkuSerDes._escape(sku.getAllowedOrderQuantities()[i]));
                sb.append("\"");
                if (i + 1 >= sku.getAllowedOrderQuantities().length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (sku.getAvailability() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availability\": ");
            sb.append(String.valueOf(sku.getAvailability()));
        }
        if (sku.getDepth() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"depth\": ");
            sb.append(sku.getDepth());
        }
        if (sku.getDisplayDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(sku.getDisplayDate()));
            sb.append("\"");
        }
        if (sku.getExpirationDate() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"expirationDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(sku.getExpirationDate()));
            sb.append("\"");
        }
        if (sku.getGtin() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"gtin\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getGtin()));
            sb.append("\"");
        }
        if (sku.getHeight() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"height\": ");
            sb.append(sku.getHeight());
        }
        if (sku.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(sku.getId());
        }
        if (sku.getManufacturerPartNumber() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"manufacturerPartNumber\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getManufacturerPartNumber()));
            sb.append("\"");
        }
        if (sku.getMaxOrderQuantity() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"maxOrderQuantity\": ");
            sb.append(sku.getMaxOrderQuantity());
        }
        if (sku.getMinOrderQuantity() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"minOrderQuantity\": ");
            sb.append(sku.getMinOrderQuantity());
        }
        if (sku.getNeverExpire() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"neverExpire\": ");
            sb.append(sku.getNeverExpire());
        }
        if (sku.getOptions() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"options\": ");
            sb.append(SkuSerDes._toJSON(sku.getOptions()));
        }
        if (sku.getPrice() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"price\": ");
            sb.append(String.valueOf(sku.getPrice()));
        }
        if (sku.getPublished() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"published\": ");
            sb.append(sku.getPublished());
        }
        if (sku.getPurchasable() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"purchasable\": ");
            sb.append(sku.getPurchasable());
        }
        if (sku.getSku() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sku\": ");
            sb.append("\"");
            sb.append(SkuSerDes._escape(sku.getSku()));
            sb.append("\"");
        }
        if (sku.getWeight() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"weight\": ");
            sb.append(sku.getWeight());
        }
        if (sku.getWidth() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"width\": ");
            sb.append(sku.getWidth());
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        SkuJSONParser skuJSONParser = new SkuJSONParser();
        return skuJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Sku sku) {
        if (sku == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (sku.getAllowedOrderQuantities() == null) {
            map.put("allowedOrderQuantities", null);
        } else {
            map.put("allowedOrderQuantities", String.valueOf(sku.getAllowedOrderQuantities()));
        }
        if (sku.getAvailability() == null) {
            map.put("availability", null);
        } else {
            map.put("availability", String.valueOf(sku.getAvailability()));
        }
        if (sku.getDepth() == null) {
            map.put("depth", null);
        } else {
            map.put("depth", String.valueOf(sku.getDepth()));
        }
        if (sku.getDisplayDate() == null) {
            map.put("displayDate", null);
        } else {
            map.put("displayDate", liferayToJSONDateFormat.format(sku.getDisplayDate()));
        }
        if (sku.getExpirationDate() == null) {
            map.put("expirationDate", null);
        } else {
            map.put("expirationDate", liferayToJSONDateFormat.format(sku.getExpirationDate()));
        }
        if (sku.getGtin() == null) {
            map.put("gtin", null);
        } else {
            map.put("gtin", String.valueOf(sku.getGtin()));
        }
        if (sku.getHeight() == null) {
            map.put("height", null);
        } else {
            map.put("height", String.valueOf(sku.getHeight()));
        }
        if (sku.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(sku.getId()));
        }
        if (sku.getManufacturerPartNumber() == null) {
            map.put("manufacturerPartNumber", null);
        } else {
            map.put("manufacturerPartNumber", String.valueOf(sku.getManufacturerPartNumber()));
        }
        if (sku.getMaxOrderQuantity() == null) {
            map.put("maxOrderQuantity", null);
        } else {
            map.put("maxOrderQuantity", String.valueOf(sku.getMaxOrderQuantity()));
        }
        if (sku.getMinOrderQuantity() == null) {
            map.put("minOrderQuantity", null);
        } else {
            map.put("minOrderQuantity", String.valueOf(sku.getMinOrderQuantity()));
        }
        if (sku.getNeverExpire() == null) {
            map.put("neverExpire", null);
        } else {
            map.put("neverExpire", String.valueOf(sku.getNeverExpire()));
        }
        if (sku.getOptions() == null) {
            map.put("options", null);
        } else {
            map.put("options", String.valueOf(sku.getOptions()));
        }
        if (sku.getPrice() == null) {
            map.put("price", null);
        } else {
            map.put("price", String.valueOf(sku.getPrice()));
        }
        if (sku.getPublished() == null) {
            map.put("published", null);
        } else {
            map.put("published", String.valueOf(sku.getPublished()));
        }
        if (sku.getPurchasable() == null) {
            map.put("purchasable", null);
        } else {
            map.put("purchasable", String.valueOf(sku.getPurchasable()));
        }
        if (sku.getSku() == null) {
            map.put("sku", null);
        } else {
            map.put("sku", String.valueOf(sku.getSku()));
        }
        if (sku.getWeight() == null) {
            map.put("weight", null);
        } else {
            map.put("weight", String.valueOf(sku.getWeight()));
        }
        if (sku.getWidth() == null) {
            map.put("width", null);
        } else {
            map.put("width", String.valueOf(sku.getWidth()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(SkuSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(SkuSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SkuSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class SkuJSONParser
    extends BaseJSONParser<Sku> {
        @Override
        protected Sku createDTO() {
            return new Sku();
        }

        protected Sku[] createDTOArray(int size) {
            return new Sku[size];
        }

        @Override
        protected void setField(Sku sku, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "allowedOrderQuantities")) {
                if (jsonParserFieldValue != null) {
                    sku.setAllowedOrderQuantities(this.toStrings((Object[])jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "availability")) {
                if (jsonParserFieldValue != null) {
                    sku.setAvailability(AvailabilitySerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "depth")) {
                if (jsonParserFieldValue != null) {
                    sku.setDepth(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "displayDate")) {
                if (jsonParserFieldValue != null) {
                    sku.setDisplayDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "expirationDate")) {
                if (jsonParserFieldValue != null) {
                    sku.setExpirationDate(this.toDate((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "gtin")) {
                if (jsonParserFieldValue != null) {
                    sku.setGtin((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "height")) {
                if (jsonParserFieldValue != null) {
                    sku.setHeight(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    sku.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "manufacturerPartNumber")) {
                if (jsonParserFieldValue != null) {
                    sku.setManufacturerPartNumber((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "maxOrderQuantity")) {
                if (jsonParserFieldValue != null) {
                    sku.setMaxOrderQuantity(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "minOrderQuantity")) {
                if (jsonParserFieldValue != null) {
                    sku.setMinOrderQuantity(Integer.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "neverExpire")) {
                if (jsonParserFieldValue != null) {
                    sku.setNeverExpire((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "options")) {
                if (jsonParserFieldValue != null) {
                    sku.setOptions(SkuSerDes.toMap((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "price")) {
                if (jsonParserFieldValue != null) {
                    sku.setPrice(PriceSerDes.toDTO((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "published")) {
                if (jsonParserFieldValue != null) {
                    sku.setPublished((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "purchasable")) {
                if (jsonParserFieldValue != null) {
                    sku.setPurchasable((Boolean)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "sku")) {
                if (jsonParserFieldValue != null) {
                    sku.setSku((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "weight")) {
                if (jsonParserFieldValue != null) {
                    sku.setWeight(Double.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "width") && jsonParserFieldValue != null) {
                sku.setWidth(Double.valueOf((String)jsonParserFieldValue));
            }
        }
    }
}

