/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItemShipment;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.Status;
import com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderItemShipmentDTOConverterContext;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItemShipment"}, service={DTOConverter.class})
public class PlacedOrderItemShipmentDTOConverter
implements DTOConverter<CommerceShipment, PlacedOrderItemShipment> {
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;
    @Reference
    private CommerceShipmentLocalService _commerceShipmentLocalService;
    @Reference
    private Language _language;

    public String getContentType() {
        return PlacedOrderItemShipment.class.getSimpleName();
    }

    public PlacedOrderItemShipment toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final PlacedOrderItemShipmentDTOConverterContext placedOrderItemShipmentDTOConverterContext = (PlacedOrderItemShipmentDTOConverterContext)dtoConverterContext;
        Long commerceShipmentItemId = (Long)placedOrderItemShipmentDTOConverterContext.getId();
        final Locale locale = dtoConverterContext.getLocale();
        final CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.getCommerceShipmentItem(commerceShipmentItemId.longValue());
        final CommerceShipment commerceShipment = this._commerceShipmentLocalService.getCommerceShipment(commerceShipmentItem.getCommerceShipmentId());
        return new PlacedOrderItemShipment(){
            {
                this.accountId = commerceShipment.getCommerceAccountId();
                this.author = commerceShipment.getUserName();
                this.carrier = commerceShipment.getCarrier();
                this.createDate = commerceShipment.getCreateDate();
                this.estimatedDeliveryDate = commerceShipment.getExpectedDate();
                this.estimatedShippingDate = commerceShipment.getShippingDate();
                this.id = commerceShipment.getCommerceShipmentId();
                this.modifiedDate = commerceShipment.getModifiedDate();
                this.quantity = commerceShipmentItem.getQuantity();
                this.shippingAddressId = commerceShipment.getCommerceAddressId();
                this.shippingMethodId = commerceShipment.getCommerceShippingMethodId();
                this.shippingOptionName = commerceShipment.getShippingOptionName();
                this.status = new Status(){
                    {
                        this.code = commerceShipment.getStatus();
                        this.label = CommerceShipmentConstants.getShipmentStatusLabel((int)commerceShipment.getStatus());
                        this.label_i18n = PlacedOrderItemShipmentDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)locale), CommerceShipmentConstants.getShipmentStatusLabel((int)commerceShipment.getStatus()));
                    }
                };
                this.supplierShipment = placedOrderItemShipmentDTOConverterContext.isSupplierShipment();
                this.trackingNumber = commerceShipment.getTrackingNumber();
                this.trackingURL = commerceShipment.getTrackingURL();
            }
        };
    }
}

