/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.CommerceOrderNoteService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrder;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderComment;
import com.liferay.headless.commerce.delivery.order.internal.resource.v1_0.BasePlacedOrderCommentResourceImpl;
import com.liferay.headless.commerce.delivery.order.resource.v1_0.PlacedOrderCommentResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/placed-order-comment.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, PlacedOrderCommentResource.class})
public class PlacedOrderCommentResourceImpl
extends BasePlacedOrderCommentResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceOrderNoteService _commerceOrderNoteService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderCommentDTOConverter)")
    private DTOConverter<CommerceOrderNote, PlacedOrderComment> _placedOrderCommentDTOConverter;

    @Override
    public PlacedOrderComment getPlacedOrderComment(Long placedOrderCommentId) throws Exception {
        CommerceOrderNote commerceOrderNote = this._commerceOrderNoteService.getCommerceOrderNote(placedOrderCommentId.longValue());
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderNote.getCommerceOrderId());
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        return this._toPlacedOrderComment(placedOrderCommentId);
    }

    @Override
    @NestedField(parentClass=PlacedOrder.class, value="placedOrderComments")
    public Page<PlacedOrderComment> getPlacedOrderPlacedOrderCommentsPage(@NestedFieldId(value="id") Long orderId, Pagination pagination) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(orderId.longValue());
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        return Page.of(this.transform(this._commerceOrderNoteService.getCommerceOrderNotes(orderId.longValue(), pagination.getStartPosition(), pagination.getEndPosition()), commerceOrderNote -> this._toPlacedOrderComment(commerceOrderNote.getCommerceOrderNoteId())), (Pagination)pagination, (long)this._commerceOrderNoteService.getCommerceOrderNotesCount(orderId.longValue()));
    }

    private PlacedOrderComment _toPlacedOrderComment(Long commerceOrderNoteId) throws Exception {
        return (PlacedOrderComment)this._placedOrderCommentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceOrderNoteId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

