/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItem;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItemShipment;
import com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderItemShipmentDTOConverterContext;
import com.liferay.headless.commerce.delivery.order.internal.resource.v1_0.BasePlacedOrderItemShipmentResourceImpl;
import com.liferay.headless.commerce.delivery.order.resource.v1_0.PlacedOrderItemShipmentResource;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/placed-order-item-shipment.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, PlacedOrderItemShipmentResource.class})
public class PlacedOrderItemShipmentResourceImpl
extends BasePlacedOrderItemShipmentResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;
    @Reference(target="(component.name=com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderItemShipmentDTOConverter)")
    private DTOConverter<CommerceShipment, PlacedOrderItemShipment> _placedOrderItemShipmentDTOConverter;

    @Override
    @NestedField(parentClass=PlacedOrderItem.class, value="placedOrderItemShipments")
    public Page<PlacedOrderItemShipment> getPlacedOrderItemPlacedOrderItemShipmentsPage(@NestedFieldId(value="id") Long placedOrderItemId) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(placedOrderItemId.longValue());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        return Page.of(this._toPlaceOrderItemShipment(placedOrderItemId));
    }

    private List<PlacedOrderItemShipment> _toPlaceOrderItemShipment(long placedOrderItemId) throws Exception {
        List commerceShipmentItems = this._commerceShipmentItemService.getCommerceShipmentItemsByCommerceOrderItemId(placedOrderItemId);
        if (ListUtil.isNotEmpty((List)commerceShipmentItems)) {
            return this.transform(commerceShipmentItems, commerceShipmentItem -> (PlacedOrderItemShipment)this._placedOrderItemShipmentDTOConverter.toDTO((DTOConverterContext)new PlacedOrderItemShipmentDTOConverterContext(commerceShipmentItem.getCommerceShipmentItemId(), this.contextAcceptLanguage.getPreferredLocale(), false)));
        }
        List supplierCommerceOrderItems = this._commerceOrderItemService.getSupplierCommerceOrderItems(placedOrderItemId, -1, -1);
        ArrayList supplierCommerceShipmentItems = new ArrayList();
        for (CommerceOrderItem supplierCommerceOrderItem : supplierCommerceOrderItems) {
            CommerceOrder supplierCommerceOrder = supplierCommerceOrderItem.getCommerceOrder();
            if (supplierCommerceOrder.isOpen()) continue;
            supplierCommerceShipmentItems.addAll(this._commerceShipmentItemService.getCommerceShipmentItemsByCommerceOrderItemId(supplierCommerceOrderItem.getCommerceOrderItemId()));
        }
        return this.transform(supplierCommerceShipmentItems, supplierCommerceShipmentItem -> (PlacedOrderItemShipment)this._placedOrderItemShipmentDTOConverter.toDTO((DTOConverterContext)new PlacedOrderItemShipmentDTOConverterContext(supplierCommerceShipmentItem.getCommerceShipmentItemId(), this.contextAcceptLanguage.getPreferredLocale(), true)));
    }
}

