/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderAddress;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderAddress"}, service={DTOConverter.class})
public class PlacedOrderAddressDTOConverter
implements DTOConverter<CommerceAddress, PlacedOrderAddress> {
    @Reference
    private CommerceAddressService _commerceAddressService;

    public String getContentType() {
        return PlacedOrderAddress.class.getSimpleName();
    }

    public PlacedOrderAddress toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(((Long)dtoConverterContext.getId()).longValue());
        final Country addressCountry = commerceAddress.getCountry();
        Region addressRegion = commerceAddress.getRegion();
        final Locale locale = dtoConverterContext.getLocale();
        PlacedOrderAddress placedOrderAddress = new PlacedOrderAddress(){
            {
                this.city = commerceAddress.getCity();
                this.country = addressCountry.getTitle(locale);
                this.countryISOCode = addressCountry.getA2();
                this.description = commerceAddress.getDescription();
                this.id = commerceAddress.getCommerceAddressId();
                this.latitude = commerceAddress.getLatitude();
                this.longitude = commerceAddress.getLongitude();
                this.name = commerceAddress.getName();
                this.phoneNumber = commerceAddress.getPhoneNumber();
                this.street1 = commerceAddress.getStreet1();
                this.street2 = commerceAddress.getStreet2();
                this.street3 = commerceAddress.getStreet3();
                this.typeId = commerceAddress.getType();
                this.zip = commerceAddress.getZip();
            }
        };
        if (addressRegion != null) {
            placedOrderAddress.setRegion(addressRegion.getName());
            placedOrderAddress.setRegionISOCode(this._getRegionISOCode(addressRegion));
        }
        return placedOrderAddress;
    }

    private String _getRegionISOCode(Region region) {
        if (region == null) {
            return "";
        }
        return region.getRegionCode();
    }
}

