/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CPDefinitionInventoryConstants;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderItemPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.type.virtual.order.model.CommerceVirtualOrderItem;
import com.liferay.commerce.product.type.virtual.order.service.CommerceVirtualOrderItemService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.util.CommerceQuantityFormatter;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItem;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.Price;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.Settings;
import com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderItemDTOConverterContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItem"}, service={DTOConverter.class})
public class PlacedOrderItemDTOConverter
implements DTOConverter<CommerceOrderItem, PlacedOrderItem> {
    private static final Log _log = LogFactoryUtil.getLog(PlacedOrderItemDTOConverter.class);
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceQuantityFormatter _commerceQuantityFormatter;
    @Reference
    private CommerceVirtualOrderItemService _commerceVirtualOrderItemService;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private Language _language;

    public String getContentType() {
        return PlacedOrderItem.class.getSimpleName();
    }

    public PlacedOrderItem toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final PlacedOrderItemDTOConverterContext placedOrderItemDTOConverterContext = (PlacedOrderItemDTOConverterContext)dtoConverterContext;
        final CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(((Long)placedOrderItemDTOConverterContext.getId()).longValue());
        final Locale locale = placedOrderItemDTOConverterContext.getLocale();
        final ExpandoBridge expandoBridge = commerceOrderItem.getExpandoBridge();
        return new PlacedOrderItem(){
            {
                this.adaptiveMediaImageHTMLTag = PlacedOrderItemDTOConverter.this._cpInstanceHelper.getCPInstanceAdaptiveMediaImageHTMLTag(placedOrderItemDTOConverterContext.getAccountId(), commerceOrderItem.getCompanyId(), commerceOrderItem.getCPInstanceId());
                this.customFields = expandoBridge.getAttributes();
                this.errorMessages = PlacedOrderItemDTOConverter.this._getErrorMessages(commerceOrderItem, locale);
                this.id = commerceOrderItem.getCommerceOrderItemId();
                this.name = commerceOrderItem.getName(PlacedOrderItemDTOConverter.this._language.getLanguageId(locale));
                this.options = commerceOrderItem.getJson();
                this.parentOrderItemId = commerceOrderItem.getParentCommerceOrderItemId();
                this.price = PlacedOrderItemDTOConverter.this._getPrice(commerceOrderItem, locale);
                this.productId = commerceOrderItem.getCProductId();
                this.productURLs = LanguageUtils.getLanguageIdMap((Map)PlacedOrderItemDTOConverter.this._cpDefinitionLocalService.getUrlTitleMap(commerceOrderItem.getCPDefinitionId()));
                this.quantity = PlacedOrderItemDTOConverter.this._commerceQuantityFormatter.format(commerceOrderItem.getCPInstanceId(), commerceOrderItem.getQuantity(), commerceOrderItem.getUnitOfMeasureKey());
                this.replacedSku = commerceOrderItem.getReplacedSku();
                this.settings = PlacedOrderItemDTOConverter.this._getSettings(commerceOrderItem.getCPInstanceId());
                this.sku = commerceOrderItem.getSku();
                this.skuId = commerceOrderItem.getCPInstanceId();
                this.subscription = commerceOrderItem.isSubscription();
                this.thumbnail = PlacedOrderItemDTOConverter.this._cpInstanceHelper.getCPInstanceThumbnailSrc(placedOrderItemDTOConverterContext.getAccountId(), commerceOrderItem.getCPInstanceId());
                this.unitOfMeasureKey = commerceOrderItem.getUnitOfMeasureKey();
                this.setVirtualItemURLs(() -> {
                    try {
                        CommerceVirtualOrderItem commerceVirtualOrderItem = PlacedOrderItemDTOConverter.this._commerceVirtualOrderItemService.fetchCommerceVirtualOrderItemByCommerceOrderItemId(commerceOrderItem.getCommerceOrderItemId());
                        if (commerceVirtualOrderItem == null) {
                            return null;
                        }
                        String url = commerceVirtualOrderItem.getUrl();
                        if (Validator.isBlank((String)url)) {
                            url = PlacedOrderItemDTOConverter.this._commerceMediaResolver.getDownloadVirtualOrderItemURL(commerceVirtualOrderItem.getCommerceVirtualOrderItemId());
                        }
                        return new String[]{url};
                    }
                    catch (PortalException portalException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)portalException);
                        }
                        return null;
                    }
                });
            }
        };
    }

    private String[] _getErrorMessages(CommerceOrderItem commerceOrderItem, Locale locale) {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
            return new String[]{this._language.get(resourceBundle, "the-product-is-no-longer-available")};
        }
        return null;
    }

    private Price _getPrice(CommerceOrderItem commerceOrderItem, final Locale locale) throws Exception {
        CommerceMoney finalPriceCommerceMoney;
        BigDecimal finalPrice;
        BigDecimal discountAmount;
        CommerceMoney discountAmountCommerceMoney;
        BigDecimal unitPromoPrice;
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        final CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        CommerceOrderItemPrice commerceOrderItemPrice = this._commerceOrderPriceCalculation.getCommerceOrderItemPricePerUnit(commerceCurrency, commerceOrderItem);
        final CommerceMoney unitPriceCommerceMoney = commerceOrderItemPrice.getUnitPrice();
        final BigDecimal unitPrice = unitPriceCommerceMoney.getPrice();
        Price price = new Price(){
            {
                this.currency = commerceCurrency.getName(locale);
                this.price = unitPrice.doubleValue();
                this.priceFormatted = unitPriceCommerceMoney.format(locale);
            }
        };
        CommerceMoney promoPriceCommerceMoney = commerceOrderItemPrice.getPromoPrice();
        if (promoPriceCommerceMoney != null && (unitPromoPrice = promoPriceCommerceMoney.getPrice()) != null) {
            price.setPromoPrice(Double.valueOf(unitPromoPrice.doubleValue()));
            price.setPromoPriceFormatted(promoPriceCommerceMoney.format(locale));
        }
        if ((discountAmountCommerceMoney = commerceOrderItemPrice.getDiscountAmount()) != null && (discountAmount = discountAmountCommerceMoney.getPrice()) != null) {
            price.setDiscount(Double.valueOf(discountAmount.doubleValue()));
            price.setDiscountFormatted(discountAmountCommerceMoney.format(locale));
            price.setDiscountPercentage(this._commercePriceFormatter.format(commerceOrderItemPrice.getDiscountPercentage(), locale));
            BigDecimal discountPercentageLevel1 = commerceOrderItemPrice.getDiscountPercentageLevel1();
            BigDecimal discountPercentageLevel2 = commerceOrderItemPrice.getDiscountPercentageLevel2();
            BigDecimal discountPercentageLevel3 = commerceOrderItemPrice.getDiscountPercentageLevel3();
            BigDecimal discountPercentageLevel4 = commerceOrderItemPrice.getDiscountPercentageLevel4();
            price.setDiscountPercentageLevel1(Double.valueOf(discountPercentageLevel1.doubleValue()));
            price.setDiscountPercentageLevel2(Double.valueOf(discountPercentageLevel2.doubleValue()));
            price.setDiscountPercentageLevel3(Double.valueOf(discountPercentageLevel3.doubleValue()));
            price.setDiscountPercentageLevel4(Double.valueOf(discountPercentageLevel4.doubleValue()));
        }
        if ((finalPrice = (finalPriceCommerceMoney = commerceOrderItemPrice.getFinalPrice()).getPrice()) != null) {
            price.setFinalPriceFormatted(finalPriceCommerceMoney.format(locale));
            price.setFinalPrice(Double.valueOf(finalPrice.doubleValue()));
        }
        return price;
    }

    private Settings _getSettings(long cpInstanceId) {
        Settings settings = new Settings();
        BigDecimal minOrderQuantity = CPDefinitionInventoryConstants.DEFAULT_MIN_ORDER_QUANTITY;
        BigDecimal maxOrderQuantity = CPDefinitionInventoryConstants.DEFAULT_MAX_ORDER_QUANTITY;
        BigDecimal multipleQuantity = CPDefinitionInventoryConstants.DEFAULT_MULTIPLE_ORDER_QUANTITY;
        CPDefinitionInventory cpDefinitionInventory = null;
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance != null) {
            cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        }
        if (cpDefinitionInventory != null) {
            minOrderQuantity = cpDefinitionInventory.getMinOrderQuantity();
            maxOrderQuantity = cpDefinitionInventory.getMaxOrderQuantity();
            multipleQuantity = cpDefinitionInventory.getMultipleOrderQuantity();
            BigDecimal[] allowedOrderQuantitiesArray = cpDefinitionInventory.getAllowedOrderQuantitiesArray();
            if (allowedOrderQuantitiesArray != null && allowedOrderQuantitiesArray.length > 0) {
                settings.setAllowedQuantities(allowedOrderQuantitiesArray);
            }
        }
        if (minOrderQuantity != null) {
            settings.setMinQuantity(BigDecimalUtil.stripTrailingZeros((BigDecimal)minOrderQuantity));
        }
        if (maxOrderQuantity != null) {
            settings.setMaxQuantity(BigDecimalUtil.stripTrailingZeros((BigDecimal)maxOrderQuantity));
        }
        if (multipleQuantity != null) {
            settings.setMultipleQuantity(BigDecimalUtil.stripTrailingZeros((BigDecimal)multipleQuantity));
        }
        return settings;
    }
}

