/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrder;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrderItem;
import com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderItemDTOConverterContext;
import com.liferay.headless.commerce.delivery.order.internal.resource.v1_0.BasePlacedOrderItemResourceImpl;
import com.liferay.headless.commerce.delivery.order.resource.v1_0.PlacedOrderItemResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/placed-order-item.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={PlacedOrderItemResource.class})
public class PlacedOrderItemResourceImpl
extends BasePlacedOrderItemResourceImpl {
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference(target="(component.name=com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderItemDTOConverter)")
    private DTOConverter<CommerceOrderItem, PlacedOrderItem> _placedOrderItemDTOConverter;

    @Override
    public PlacedOrderItem getPlacedOrderItem(Long placedOrderItemId) throws Exception {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemService.getCommerceOrderItem(placedOrderItemId.longValue());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        return this._toPlacedOrderItem(commerceOrder.getCommerceAccountId(), commerceOrderItem);
    }

    @Override
    @NestedField(parentClass=PlacedOrder.class, value="placedOrderItems")
    public Page<PlacedOrderItem> getPlacedOrderPlacedOrderItemsPage(@NestedFieldId(value="id") Long placedOrderId, Long skuId, Pagination pagination) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(placedOrderId.longValue());
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        return Page.of(this._filterPlacedOrderItems(this.transform(this._commerceOrderItemService.getCommerceOrderItems(placedOrderId.longValue(), -1, -1), commerceOrderItem -> {
            if (skuId != null && !Objects.equals(commerceOrderItem.getCPInstanceId(), skuId)) {
                return null;
            }
            return this._toPlacedOrderItem(commerceOrder.getCommerceAccountId(), (CommerceOrderItem)commerceOrderItem);
        })));
    }

    private List<PlacedOrderItem> _filterPlacedOrderItems(List<PlacedOrderItem> placedOrderItems) {
        HashMap<Long, PlacedOrderItem> placedOrderItemMap = new HashMap<Long, PlacedOrderItem>();
        for (PlacedOrderItem placedOrderItem : placedOrderItems) {
            placedOrderItemMap.put(placedOrderItem.getId(), placedOrderItem);
        }
        for (PlacedOrderItem placedOrderItem : placedOrderItems) {
            PlacedOrderItem parentOrderItem;
            Long parentOrderItemId = placedOrderItem.getParentOrderItemId();
            if (parentOrderItemId == null || (parentOrderItem = (PlacedOrderItem)placedOrderItemMap.get(parentOrderItemId)) == null) continue;
            if (parentOrderItem.getPlacedOrderItems() == null) {
                parentOrderItem.setPlacedOrderItems(new PlacedOrderItem[0]);
            }
            parentOrderItem.setPlacedOrderItems((PlacedOrderItem[])ArrayUtil.append((Object[])parentOrderItem.getPlacedOrderItems(), (Object)placedOrderItem));
            placedOrderItemMap.remove(placedOrderItem.getId());
        }
        return new ArrayList<PlacedOrderItem>(placedOrderItemMap.values());
    }

    private PlacedOrderItem _toPlacedOrderItem(long commerceAccountId, CommerceOrderItem commerceOrderItem) throws Exception {
        return (PlacedOrderItem)this._placedOrderItemDTOConverter.toDTO((DTOConverterContext)new PlacedOrderItemDTOConverterContext(commerceAccountId, commerceOrderItem.getCommerceOrderItemId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

