/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.CommerceCheckoutStep;
import com.liferay.commerce.util.CommerceCheckoutStepRegistry;
import com.liferay.headless.commerce.delivery.order.dto.v1_0.PlacedOrder;
import com.liferay.headless.commerce.delivery.order.internal.resource.v1_0.BasePlacedOrderResourceImpl;
import com.liferay.headless.commerce.delivery.order.resource.v1_0.PlacedOrderResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.security.Key;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/placed-order.properties"}, scope=ServiceScope.PROTOTYPE, service={PlacedOrderResource.class})
public class PlacedOrderResourceImpl
extends BasePlacedOrderResourceImpl {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCheckoutStepRegistry _commerceCheckoutStepRegistry;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private Encryptor _encryptor;
    @Reference(target="(component.name=com.liferay.headless.commerce.delivery.order.internal.dto.v1_0.converter.PlacedOrderDTOConverter)")
    private DTOConverter<CommerceOrder, PlacedOrder> _placedOrderDTOConverter;
    @Reference
    private Portal _portal;

    @Override
    public Page<PlacedOrder> getChannelAccountPlacedOrdersPage(Long accountId, Long channelId, Pagination pagination) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        return Page.of(this.transform(this._commerceOrderService.getPlacedCommerceOrders(commerceChannel.getGroupId(), accountId.longValue(), null, pagination.getStartPosition(), pagination.getEndPosition()), commerceOrder -> this._toPlacedOrder(commerceOrder.getCommerceOrderId())), (Pagination)pagination, (long)this._commerceOrderService.getPlacedCommerceOrdersCount(commerceChannel.getGroupId(), accountId.longValue(), null));
    }

    @Override
    public PlacedOrder getPlacedOrder(Long placedOrderId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(placedOrderId.longValue());
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        return this._toPlacedOrder(commerceOrder.getCommerceOrderId());
    }

    @Override
    public String getPlacedOrderPaymentURL(Long placedOrderId, String callbackURL) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(placedOrderId.longValue());
        if (commerceOrder.isOpen()) {
            throw new NoSuchOrderException();
        }
        this._initThemeDisplay(commerceOrder);
        StringBundler sb = new StringBundler(14);
        sb.append(this._portal.getPortalURL(this.contextHttpServletRequest));
        sb.append(this._portal.getPathModule());
        sb.append('/');
        sb.append("commerce-payment");
        sb.append("?groupId=");
        sb.append(commerceOrder.getGroupId());
        sb.append("&");
        if (commerceOrder.isGuestOrder()) {
            sb.append("guestToken=");
            Key key = this.contextCompany.getKeyObj();
            sb.append(this._encryptor.encrypt(key, String.valueOf(commerceOrder.getCommerceOrderId())));
            sb.append("&");
        }
        sb.append("nextStep=");
        if (Validator.isNotNull((String)callbackURL)) {
            sb.append(callbackURL);
        } else {
            sb.append(URLCodec.encodeURL((String)this._getPlacedOrderConfirmationCheckoutStepURL(commerceOrder)));
        }
        sb.append("&uuid=");
        sb.append(commerceOrder.getUuid());
        return sb.toString();
    }

    private String _getPlacedOrderConfirmationCheckoutStepURL(CommerceOrder commerceOrder) throws Exception {
        return PortletURLBuilder.create((PortletURL)PortletProviderUtil.getPortletURL((HttpServletRequest)this.contextHttpServletRequest, (String)"com_liferay_commerce_checkout_web_internal_portlet_CommerceCheckoutPortlet", (PortletProvider.Action)PortletProvider.Action.VIEW)).setParameter("checkoutStepName", () -> {
            CommerceCheckoutStep commerceCheckoutStep = this._commerceCheckoutStepRegistry.getCommerceCheckoutStep("order-confirmation");
            return commerceCheckoutStep.getName();
        }).setParameter("commerceOrderUuid", commerceOrder.getUuid()).buildString();
    }

    private void _initThemeDisplay(CommerceOrder commerceOrder) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            return;
        }
        ServicePreAction servicePreAction = new ServicePreAction();
        DummyHttpServletResponse httpServletResponse = new DummyHttpServletResponse();
        servicePreAction.servicePre(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse);
        themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        themeDisplay.setScopeGroupId(commerceChannel.getSiteGroupId());
    }

    private PlacedOrder _toPlacedOrder(long commerceOrderId) throws Exception {
        return (PlacedOrder)this._placedOrderDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceOrderId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

