/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.AxisServletBase;
import org.apache.axis.transport.http.FilterPrintWriter;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;

public class AxisServlet
extends AxisServletBase {
    protected static Log log = LogFactory.getLog(AxisServlet.class.getName());
    private static Log tlog = LogFactory.getLog("org.apache.axis.TIME");
    private static Log exceptionLog = LogFactory.getLog("org.apache.axis.EXCEPTIONS");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "axis.jws.servletClassDir";
    public static final String INIT_PROPERTY_DISABLE_SERVICES_LIST = "axis.disableServiceList";
    public static final String INIT_PROPERTY_SERVICES_PATH = "axis.servicesPath";
    private String transportName;
    private Handler transport;
    private ServletSecurityProvider securityProvider = null;
    private String servicesPath;
    private static boolean isDebug = false;
    private boolean enableList = false;
    private boolean disableServicesList = false;
    private String jwsClassDir = null;
    private static final String[] _ATTRIBUTE_ESCAPES = new String[256];

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        ServletContext context = this.getServletConfig().getServletContext();
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)"In servlet init");
        }
        this.transportName = this.getOption(context, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(context, INIT_PROPERTY_JWS_CLASS_DIR, null);
        this.disableServicesList = JavaUtils.isTrue(this.getOption(context, INIT_PROPERTY_DISABLE_SERVICES_LIST, "false"));
        this.servicesPath = this.getOption(context, INIT_PROPERTY_SERVICES_PATH, "/services/");
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
        this.initQueryStringHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (isDebug) {
            log.debug((Object)"Enter: doGet()");
        }
        FilterPrintWriter writer = new FilterPrintWriter(response);
        try {
            boolean hasNoPath;
            boolean isJWSPage;
            AxisServer engine = this.getEngine();
            ServletContext servletContext = this.getServletConfig().getServletContext();
            String pathInfo = request.getPathInfo();
            String realpath = servletContext.getRealPath(request.getServletPath());
            if (realpath == null) {
                realpath = request.getServletPath();
            }
            if (isJWSPage = request.getRequestURI().endsWith(".jws")) {
                pathInfo = request.getServletPath();
            }
            if (this.processQuery(request, response, writer)) {
                return;
            }
            boolean bl = hasNoPath = pathInfo == null || pathInfo.equals("");
            if (!this.disableServicesList) {
                if (hasNoPath) {
                    this.reportAvailableServices(response, writer, request);
                } else if (realpath != null) {
                    MessageContext msgContext = this.createMessageContext(engine, request, response);
                    String url = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
                    msgContext.setProperty("transport.url", url);
                    String serviceName = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
                    SOAPService s = engine.getService(serviceName);
                    if (s == null) {
                        if (isJWSPage) {
                            this.reportCantGetJWSService(request, response, writer);
                        } else {
                            this.reportCantGetAxisService(request, response, writer);
                        }
                    } else {
                        this.reportServiceInfo(response, writer, s, serviceName);
                    }
                }
            } else {
                response.setContentType("text/html; charset=utf-8");
                ((PrintWriter)writer).println("<html><h1>Axis HTTP Servlet</h1>");
                ((PrintWriter)writer).println(Messages.getMessage("reachedServlet00"));
                ((PrintWriter)writer).println("<p>" + Messages.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                ((PrintWriter)writer).println("</html>");
            }
        }
        catch (AxisFault fault) {
            this.reportTroubleInGet(fault, response, writer);
        }
        catch (Exception e) {
            this.reportTroubleInGet(e, response, writer);
        }
        finally {
            ((PrintWriter)writer).close();
            if (isDebug) {
                log.debug((Object)"Exit: doGet()");
            }
        }
    }

    private void reportTroubleInGet(Throwable exception, HttpServletResponse response, PrintWriter writer) {
        response.setContentType("text/html; charset=utf-8");
        response.setStatus(500);
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
        if (exception instanceof AxisFault) {
            AxisFault fault = (AxisFault)exception;
            this.processAxisFault(fault);
            this.writeFault(writer, fault);
        } else {
            this.logException(exception);
            writer.println("<pre>Exception - " + exception + "<br>");
            if (this.isDevelopment()) {
                writer.println(JavaUtils.stackToString(exception));
            }
            writer.println("</pre>");
        }
    }

    protected void processAxisFault(AxisFault fault) {
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null) {
            exceptionLog.info((Object)Messages.getMessage("axisFault00"), (Throwable)fault);
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (exceptionLog.isDebugEnabled()) {
            exceptionLog.debug((Object)Messages.getMessage("axisFault00"), (Throwable)fault);
        }
        if (!this.isDevelopment()) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    protected void logException(Throwable e) {
        exceptionLog.info((Object)Messages.getMessage("exception00"), e);
    }

    private void writeFault(PrintWriter writer, AxisFault axisFault) {
        String localizedMessage = XMLUtils.xmlEncodeString(axisFault.getLocalizedMessage());
        writer.println("<pre>Fault - " + localizedMessage + "<br>");
        writer.println(axisFault.dumpToString());
        writer.println("</pre>");
    }

    protected void reportServiceInfo(HttpServletResponse response, PrintWriter writer, SOAPService service, String serviceName) {
        response.setContentType("text/html; charset=utf-8");
        writer.println("<h1>" + service.getName() + "</h1>");
        writer.println("<p>" + Messages.getMessage("axisService00") + "</p>");
        writer.println("<i>" + Messages.getMessage("perhaps00") + "</i>");
    }

    protected void reportNoWSDL(HttpServletResponse res, PrintWriter writer, String moreDetailCode, AxisFault axisFault) {
    }

    protected void reportAvailableServices(HttpServletResponse response, PrintWriter writer, HttpServletRequest request) throws ConfigurationException, AxisFault {
        Iterator i;
        AxisServer engine = this.getEngine();
        response.setContentType("text/html; charset=utf-8");
        writer.println("<h2>And now... Some Services</h2>");
        try {
            i = engine.getConfig().getDeployedServices();
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)configException.getContainedException();
            }
            throw configException;
        }
        String defaultBaseURL = this.getWebappBase(request) + this.servicesPath;
        writer.println("<ul>");
        while (i.hasNext()) {
            ServiceDesc sd = (ServiceDesc)i.next();
            StringBuffer sb = new StringBuffer();
            sb.append("<li>");
            String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            String endpointURL = sd.getEndpointURL();
            String baseURL = endpointURL == null ? defaultBaseURL : endpointURL;
            sb.append(baseURL);
            sb.append(name);
            sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
            writer.println(sb.toString());
            ArrayList operations = sd.getOperations();
            if (operations.isEmpty()) continue;
            writer.println("<ul>");
            for (OperationDesc desc : operations) {
                writer.println("<li>" + desc.getName());
            }
            writer.println("</ul>");
        }
        writer.println("</ul>");
    }

    protected void reportCantGetAxisService(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) {
        response.setStatus(404);
        response.setContentType("text/html; charset=utf-8");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noService06") + "</p>");
    }

    protected void reportCantGetJWSService(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) {
        String requestPath = request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "");
        String realpath = this.getServletConfig().getServletContext().getRealPath(requestPath);
        log.debug((Object)("JWS real path: " + realpath));
        boolean foundJWSFile = new File(realpath).exists() && realpath.endsWith(".jws");
        response.setContentType("text/html; charset=utf-8");
        if (foundJWSFile) {
            response.setStatus(200);
            writer.println(Messages.getMessage("foundJWS00") + "<p>");
            String url = request.getRequestURI();
            String urltext = Messages.getMessage("foundJWS01");
            writer.println("<a href='" + this.escapeHREF(url) + "?wsdl'>" + urltext + "</a>");
        } else {
            response.setStatus(404);
            writer.println(Messages.getMessage("noService06"));
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String contentType;
        Message responseMsg;
        MessageContext msgContext;
        String soapAction;
        long t4;
        long t3;
        long t2;
        long t1;
        long t0;
        block32: {
            t0 = 0L;
            t1 = 0L;
            t2 = 0L;
            t3 = 0L;
            t4 = 0L;
            soapAction = null;
            msgContext = null;
            if (isDebug) {
                log.debug((Object)"Enter: doPost()");
            }
            if (tlog.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
            }
            responseMsg = null;
            contentType = null;
            try {
                AxisServer engine = this.getEngine();
                if (engine == null) {
                    ServletException se = new ServletException(Messages.getMessage("noEngine00"));
                    log.debug((Object)"No Engine!", (Throwable)se);
                    throw se;
                }
                res.setBufferSize(8192);
                msgContext = this.createMessageContext(engine, req, res);
                if (this.securityProvider != null) {
                    if (isDebug) {
                        log.debug((Object)("securityProvider:" + this.securityProvider));
                    }
                    msgContext.setProperty("securityProvider", this.securityProvider);
                }
                Message requestMsg = new Message(req.getInputStream(), false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
                MimeHeaders requestMimeHeaders = requestMsg.getMimeHeaders();
                Enumeration e = req.getHeaderNames();
                while (e.hasMoreElements()) {
                    String headerName = (String)e.nextElement();
                    Enumeration f = req.getHeaders(headerName);
                    while (f.hasMoreElements()) {
                        String headerValue = (String)f.nextElement();
                        requestMimeHeaders.addHeader(headerName, headerValue);
                    }
                }
                if (isDebug) {
                    log.debug((Object)("Request Message:" + requestMsg));
                }
                msgContext.setRequestMessage(requestMsg);
                String url = HttpUtils.getRequestURL((HttpServletRequest)req).toString();
                msgContext.setProperty("transport.url", url);
                try {
                    String requestEncoding = (String)requestMsg.getProperty("javax.xml.soap.character-set-encoding");
                    if (requestEncoding != null) {
                        msgContext.setProperty("javax.xml.soap.character-set-encoding", requestEncoding);
                    }
                }
                catch (SOAPException f) {
                    // empty catch block
                }
                try {
                    soapAction = this.getSoapAction(req);
                    if (soapAction != null) {
                        msgContext.setUseSOAPAction(true);
                        msgContext.setSOAPActionURI(soapAction);
                    }
                    msgContext.setSession(new AxisHttpSession(req));
                    if (tlog.isDebugEnabled()) {
                        t1 = System.currentTimeMillis();
                    }
                    if (isDebug) {
                        log.debug((Object)"Invoking Axis Engine.");
                    }
                    engine.invoke(msgContext);
                    if (isDebug) {
                        log.debug((Object)"Return from Axis Engine.");
                    }
                    if (tlog.isDebugEnabled()) {
                        t2 = System.currentTimeMillis();
                    }
                    responseMsg = msgContext.getResponseMessage();
                }
                catch (AxisFault fault) {
                    this.processAxisFault(fault);
                    this.configureResponseFromAxisFault(res, fault);
                    responseMsg = msgContext.getResponseMessage();
                    if (responseMsg == null) {
                        responseMsg = new Message(fault);
                        ((SOAPPart)responseMsg.getSOAPPart()).getMessage().setMessageContext(msgContext);
                    }
                }
                catch (Exception e2) {
                    responseMsg = msgContext.getResponseMessage();
                    res.setStatus(500);
                    responseMsg = this.convertExceptionToAxisFault(e2, responseMsg);
                    ((SOAPPart)responseMsg.getSOAPPart()).getMessage().setMessageContext(msgContext);
                }
                catch (Throwable t) {
                    this.logException(t);
                    responseMsg = msgContext.getResponseMessage();
                    res.setStatus(500);
                    responseMsg = new Message(new AxisFault(t.toString(), t));
                    ((SOAPPart)responseMsg.getSOAPPart()).getMessage().setMessageContext(msgContext);
                }
            }
            catch (AxisFault fault) {
                this.processAxisFault(fault);
                this.configureResponseFromAxisFault(res, fault);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg != null) break block32;
                responseMsg = new Message(fault);
                ((SOAPPart)responseMsg.getSOAPPart()).getMessage().setMessageContext(msgContext);
            }
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        if (responseMsg != null) {
            MimeHeaders responseMimeHeaders = responseMsg.getMimeHeaders();
            Iterator i = responseMimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader responseMimeHeader = (MimeHeader)i.next();
                res.addHeader(responseMimeHeader.getName(), responseMimeHeader.getValue());
            }
            String responseEncoding = (String)msgContext.getProperty("javax.xml.soap.character-set-encoding");
            if (responseEncoding != null) {
                try {
                    responseMsg.setProperty("javax.xml.soap.character-set-encoding", responseEncoding);
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
            }
            contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
            this.sendResponse(contentType, res, responseMsg);
        } else {
            res.setStatus(202);
        }
        if (isDebug) {
            log.debug((Object)"Response sent.");
            log.debug((Object)"Exit: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("axisServlet.doPost: " + soapAction + " pre=" + (t1 - t0) + " invoke=" + (t2 - t1) + " post=" + (t3 - t2) + " send=" + (t4 - t3) + " " + msgContext.getTargetService() + "." + (msgContext.getOperation() == null ? "" : msgContext.getOperation().getName())));
        }
    }

    private void configureResponseFromAxisFault(HttpServletResponse response, AxisFault fault) {
        int status = this.getHttpServletResponseStatus(fault);
        if (status == 401) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        response.setStatus(status);
    }

    private Message convertExceptionToAxisFault(Exception exception, Message responseMsg) {
        this.logException(exception);
        if (responseMsg == null) {
            AxisFault fault = AxisFault.makeFault(exception);
            this.processAxisFault(fault);
            responseMsg = new Message(fault);
        }
        return responseMsg;
    }

    protected int getHttpServletResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String contentType, HttpServletResponse res, Message responseMsg) throws AxisFault, IOException {
        if (responseMsg == null) {
            res.setStatus(204);
            if (isDebug) {
                log.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug((Object)("Returned Content-Type:" + contentType));
            }
            try {
                res.setContentType(contentType);
                responseMsg.writeTo((OutputStream)res.getOutputStream());
            }
            catch (SOAPException e) {
                this.logException(e);
            }
        }
        if (!res.isCommitted()) {
            res.flushBuffer();
        }
    }

    private MessageContext createMessageContext(AxisEngine engine, HttpServletRequest req, HttpServletResponse res) {
        MessageContext msgContext = new MessageContext(engine);
        String requestPath = AxisServlet.getRequestPath(req);
        if (isDebug) {
            log.debug((Object)("MessageContext:" + msgContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location")));
            log.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + requestPath));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath())));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr()));
            log.debug((Object)("configPath:" + String.valueOf(this.getWebInfPath())));
        }
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("jws.classDir", this.jwsClassDir);
        msgContext.setProperty("home.dir", this.getHomeDir());
        msgContext.setProperty("path", requestPath);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.getWebInfPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, req.getPathInfo());
        msgContext.setProperty("Authorization", req.getHeader("Authorization"));
        msgContext.setProperty("remoteaddr", req.getRemoteAddr());
        ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty("servletEndpointContext", sec);
        String realpath = this.getServletConfig().getServletContext().getRealPath(requestPath);
        if (realpath != null) {
            msgContext.setProperty("realpath", realpath);
        }
        msgContext.setProperty("configPath", this.getWebInfPath());
        return msgContext;
    }

    private String getSoapAction(HttpServletRequest req) throws AxisFault {
        int index;
        String contentType;
        String soapAction = req.getHeader("SOAPAction");
        if (soapAction == null && (contentType = req.getHeader("Content-Type")) != null && (index = contentType.indexOf("action")) != -1) {
            soapAction = contentType.substring(index + 7);
        }
        if (isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + soapAction));
        }
        if (soapAction == null) {
            AxisFault af = new AxisFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            exceptionLog.error((Object)Messages.getMessage("genFault00"), (Throwable)af);
            throw af;
        }
        if (soapAction.startsWith("\"") && soapAction.endsWith("\"") && soapAction.length() >= 2) {
            int end = soapAction.length() - 1;
            soapAction = soapAction.substring(1, end);
        }
        if (soapAction.length() == 0) {
            soapAction = req.getContextPath();
        }
        return soapAction;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    public void initQueryStringHandlers() {
        try {
            this.transport = this.getEngine().getTransport(this.transportName);
            if (this.transport == null) {
                this.transport = new SimpleTargetedChain();
                this.transport.setOption("qs.list", "org.apache.axis.transport.http.QSListHandler");
                this.transport.setOption("qs.method", "org.apache.axis.transport.http.QSMethodHandler");
                this.transport.setOption("qs.wsdl", "org.apache.axis.transport.http.QSWSDLHandler");
                return;
            }
            boolean defaultQueryStrings = true;
            String useDefaults = (String)this.transport.getOption("useDefaultQueryStrings");
            if (useDefaults != null && useDefaults.toLowerCase().equals("false")) {
                defaultQueryStrings = false;
            }
            if (defaultQueryStrings) {
                this.transport.setOption("qs.list", "org.apache.axis.transport.http.QSListHandler");
                this.transport.setOption("qs.method", "org.apache.axis.transport.http.QSMethodHandler");
                this.transport.setOption("qs.wsdl", "org.apache.axis.transport.http.QSWSDLHandler");
            }
        }
        catch (AxisFault e) {
            this.transport = new SimpleTargetedChain();
            this.transport.setOption("qs.list", "org.apache.axis.transport.http.QSListHandler");
            this.transport.setOption("qs.method", "org.apache.axis.transport.http.QSMethodHandler");
            this.transport.setOption("qs.wsdl", "org.apache.axis.transport.http.QSWSDLHandler");
            return;
        }
    }

    private String escapeAttribute(String attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < attribute.length(); ++i) {
            char c = attribute.charAt(i);
            if (c < _ATTRIBUTE_ESCAPES.length) {
                String replacement = _ATTRIBUTE_ESCAPES[c];
                if (replacement == null) continue;
                if (sb == null) {
                    sb = new StringBuilder(attribute.length() + 64);
                }
                if (i > lastReplacementIndex) {
                    sb.append(attribute, lastReplacementIndex, i);
                }
                sb.append(replacement);
                lastReplacementIndex = i + 1;
                continue;
            }
            if (AxisServlet.isValidXmlCharacter(c) && !this.isUnicodeCompatibilityCharacter(c)) continue;
            if (sb == null) {
                sb = new StringBuilder(attribute.length() + 64);
            }
            if (i > lastReplacementIndex) {
                sb.append(attribute, lastReplacementIndex, i);
            }
            sb.append(' ');
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return attribute;
        }
        if (lastReplacementIndex < attribute.length()) {
            sb.append(attribute, lastReplacementIndex, attribute.length());
        }
        return sb.toString();
    }

    private String escapeHREF(String href) {
        if (href == null) {
            return null;
        }
        if (href.length() == 0) {
            return "";
        }
        char c = href.charAt(0);
        if (c == '\\' || c == '/') {
            return this.escapeAttribute(href);
        }
        if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'z' && c != 'd' && c != 'j') {
            return this.escapeAttribute(href);
        }
        int index = href.indexOf(":");
        if (index > -1) {
            href = this.replaceFirst(href, ":", "%3a", index);
        }
        return this.escapeAttribute(href);
    }

    private boolean isUnicodeCompatibilityCharacter(char c) {
        return c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef';
    }

    private boolean processQuery(HttpServletRequest request, HttpServletResponse response, PrintWriter writer) throws AxisFault {
        String path = request.getServletPath();
        String queryString = request.getQueryString();
        AxisServer engine = this.getEngine();
        Iterator i = this.transport.getOptions().keySet().iterator();
        if (queryString == null) {
            return false;
        }
        String servletURI = request.getContextPath() + path;
        String reqURI = request.getRequestURI();
        String serviceName = servletURI.length() + 1 < reqURI.length() ? reqURI.substring(servletURI.length() + 1) : "";
        while (i.hasNext()) {
            String queryHandler = (String)i.next();
            if (!queryHandler.startsWith("qs.")) continue;
            String handlerName = queryHandler.substring(queryHandler.indexOf(".") + 1).toLowerCase();
            int length = 0;
            boolean firstParamFound = false;
            while (!firstParamFound && length < queryString.length()) {
                char ch;
                if ((ch = queryString.charAt(length++)) != '&' && ch != '=') continue;
                firstParamFound = true;
                --length;
            }
            if (length < queryString.length()) {
                queryString = queryString.substring(0, length);
            }
            if (!queryString.toLowerCase().equals(handlerName)) continue;
            if (this.transport.getOption(queryHandler).equals("")) {
                return false;
            }
            try {
                MessageContext msgContext = this.createMessageContext(engine, request, response);
                Class<?> plugin = Class.forName((String)this.transport.getOption(queryHandler));
                Method pluginMethod = plugin.getDeclaredMethod("invoke", msgContext.getClass());
                String url = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
                msgContext.setProperty("transport.url", url);
                msgContext.setProperty("transport.http.plugin.serviceName", serviceName);
                msgContext.setProperty("transport.http.plugin.pluginName", handlerName);
                msgContext.setProperty("transport.http.plugin.isDevelopment", new Boolean(this.isDevelopment()));
                msgContext.setProperty("transport.http.plugin.enableList", new Boolean(this.enableList));
                msgContext.setProperty("transport.http.plugin.engine", engine);
                msgContext.setProperty("transport.http.plugin.writer", writer);
                msgContext.setProperty("transport.http.plugin.log", log);
                msgContext.setProperty("transport.http.plugin.exceptionLog", exceptionLog);
                pluginMethod.invoke(plugin.newInstance(), msgContext);
                writer.close();
                return true;
            }
            catch (InvocationTargetException ie) {
                this.reportTroubleInGet(ie.getTargetException(), response, writer);
                return true;
            }
            catch (Exception e) {
                this.reportTroubleInGet(e, response, writer);
                return true;
            }
        }
        return false;
    }

    private String replaceFirst(String s, String oldSub, String newSub, int fromIndex) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.indexOf(oldSub, fromIndex);
        if (y >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(s.substring(0, y));
            sb.append(newSub);
            sb.append(s.substring(y + oldSub.length()));
            return sb.toString();
        }
        return s;
    }

    private static String getRequestPath(HttpServletRequest request) {
        return request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "");
    }

    private static boolean isValidXmlCharacter(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || Character.isSurrogate(c) || c == '\t' || c == '\n' || c == '\r';
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            if (!AxisServlet.isValidXmlCharacter(c)) {
                AxisServlet._ATTRIBUTE_ESCAPES[i] = " ";
            }
            AxisServlet._ATTRIBUTE_ESCAPES[38] = "&amp;";
            AxisServlet._ATTRIBUTE_ESCAPES[39] = "&#39;";
            AxisServlet._ATTRIBUTE_ESCAPES[62] = "&gt;";
            AxisServlet._ATTRIBUTE_ESCAPES[60] = "&lt;";
            AxisServlet._ATTRIBUTE_ESCAPES[34] = "&quot;";
        }
    }
}

