/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;

public class ContextListenerTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<EventListener, AtomicReference<ListenerRegistration>> {
    private ContextController contextController;

    public ContextListenerTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<ListenerRegistration> addingService(ServiceReference<EventListener> serviceReference) {
        if (serviceReference.getProperty("osgi.http.whiteboard.listener") == null) {
            return null;
        }
        if (!this.contextController.matches(serviceReference)) {
            return null;
        }
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return null;
        }
        AtomicReference<ListenerRegistration> result = new AtomicReference<ListenerRegistration>();
        try {
            Object listenerObj = serviceReference.getProperty("osgi.http.whiteboard.listener");
            if (!Boolean.class.isInstance(listenerObj) && !String.class.isInstance(listenerObj)) {
                throw new HttpWhiteboardFailureException("osgi.http.whiteboard.listener=" + listenerObj + " is not a valid option. Ignoring!", 6);
            }
            Boolean listener = listenerObj instanceof Boolean ? (Boolean)listenerObj : Boolean.parseBoolean((String)listenerObj);
            if (!listener.booleanValue()) {
                return result;
            }
            result.set(this.contextController.addListenerRegistration(serviceReference));
        }
        catch (HttpWhiteboardFailureException hwfe) {
            this.httpServiceRuntime.log(hwfe.getMessage(), hwfe);
            this.recordFailedListenerDTO(serviceReference, hwfe.getFailureReason());
        }
        catch (Exception e) {
            this.httpServiceRuntime.log(e.getMessage(), e);
            this.recordFailedListenerDTO(serviceReference, 4);
        }
        return result;
    }

    public void modifiedService(ServiceReference<EventListener> serviceReference, AtomicReference<ListenerRegistration> listenerRegistration) {
        this.removedService(serviceReference, listenerRegistration);
        this.addingService((ServiceReference)serviceReference);
    }

    public void removedService(ServiceReference<EventListener> serviceReference, AtomicReference<ListenerRegistration> listenerReference) {
        ListenerRegistration listenerRegistration = listenerReference.get();
        if (listenerRegistration != null) {
            listenerRegistration.destroy();
        }
        this.contextController.getHttpServiceRuntime().removeFailedListenerDTO(serviceReference);
    }

    private void recordFailedListenerDTO(ServiceReference<EventListener> serviceReference, int failureReason) {
        FailedListenerDTO failedListenerDTO = new FailedListenerDTO();
        failedListenerDTO.failureReason = failureReason;
        failedListenerDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedListenerDTO.servletContextId = this.contextController.getServiceId();
        failedListenerDTO.types = StringPlus.from(serviceReference.getProperty("objectClass")).toArray(new String[0]);
        this.contextController.getHttpServiceRuntime().recordFailedListenerDTO(serviceReference, failedListenerDTO);
    }
}

