/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpServletResponseWrapperImpl
extends HttpServletResponseWrapper {
    private int status = -1;
    private String message;
    private boolean completed;

    public HttpServletResponseWrapperImpl(HttpServletResponse response) {
        super(response);
    }

    public boolean isCommitted() {
        if (this.status != -1) {
            return true;
        }
        return super.isCommitted();
    }

    public void sendError(int status) {
        this.status = status;
    }

    public void sendError(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        if (this.status == -1) {
            return super.getStatus();
        }
        return this.status;
    }

    public int getInternalStatus() {
        return this.status;
    }

    public void flushBuffer() throws IOException {
        if (this.status != -1) {
            HttpServletResponse wrappedResponse = (HttpServletResponse)this.getResponse();
            wrappedResponse.sendError(this.status, this.getMessage());
        }
        super.flushBuffer();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public static HttpServletResponseWrapperImpl findHttpRuntimeResponse(HttpServletResponse response) {
        while (response instanceof HttpServletResponseWrapper) {
            if (response instanceof HttpServletResponseWrapperImpl) {
                return (HttpServletResponseWrapperImpl)response;
            }
            response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        }
        return null;
    }

    private class InternalOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream originalOutputStream;

        public InternalOutputStream(ServletOutputStream originalOutputStream) {
            this.originalOutputStream = originalOutputStream;
        }

        public void close() throws IOException {
            this.originalOutputStream.close();
        }

        public void flush() throws IOException {
            if (HttpServletResponseWrapperImpl.this.getInternalStatus() != -1) {
                HttpServletResponse wrappedResponse = (HttpServletResponse)HttpServletResponseWrapperImpl.this.getResponse();
                wrappedResponse.sendError(HttpServletResponseWrapperImpl.this.getInternalStatus(), HttpServletResponseWrapperImpl.this.getMessage());
            }
            this.originalOutputStream.flush();
        }

        public boolean isReady() {
            return this.originalOutputStream.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.originalOutputStream.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            this.originalOutputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            this.originalOutputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (HttpServletResponseWrapperImpl.this.isCompleted()) {
                return;
            }
            this.originalOutputStream.write(b, off, len);
        }
    }
}

