/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.framework.ContextFinder;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainerAdaptor;
import org.eclipse.osgi.internal.framework.EquinoxEventPublisher;
import org.eclipse.osgi.internal.framework.StorageSaver;
import org.eclipse.osgi.internal.framework.legacy.PackageAdminImpl;
import org.eclipse.osgi.internal.framework.legacy.StartLevelImpl;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.location.EquinoxLocations;
import org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.storage.Storage;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class EquinoxContainer
implements ThreadFactory,
Runnable {
    public static final String NAME = "org.eclipse.osgi";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final EquinoxConfiguration equinoxConfig;
    private final EquinoxLogServices logServices;
    private final Storage storage;
    private final PackageAdmin packageAdmin;
    private final StartLevel startLevel;
    private final Set<String> bootDelegation;
    private final String[] bootDelegationStems;
    private final boolean bootDelegateAll;
    private final boolean isProcessClassRecursionSupportedByAll;
    private final EquinoxEventPublisher eventPublisher;
    private volatile ServiceRegistry serviceRegistry;
    private volatile ContextFinder contextFinder;
    private volatile ServiceTracker<SignedContentFactory, SignedContentFactory> signedContentFactory;
    private volatile ScheduledExecutorService executor;
    private volatile StorageSaver storageSaver;

    public EquinoxContainer(Map<String, ?> configuration) {
        this.equinoxConfig = new EquinoxConfiguration(configuration, new HookRegistry(this));
        this.logServices = new EquinoxLogServices(this.equinoxConfig);
        this.equinoxConfig.logMessages(this.logServices);
        this.equinoxConfig.getHookRegistry().initialize();
        try {
            this.storage = Storage.createStorage(this);
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing storage.", e);
        }
        catch (BundleException e) {
            throw new RuntimeException("Error initializing storage.", e);
        }
        this.packageAdmin = new PackageAdminImpl(this.storage.getModuleContainer());
        this.startLevel = new StartLevelImpl(this.storage.getModuleContainer());
        this.eventPublisher = new EquinoxEventPublisher(this);
        String bootDelegationProp = this.equinoxConfig.getConfiguration("org.osgi.framework.bootdelegation");
        String[] bootPackages = ManifestElement.getArrayFromList(bootDelegationProp, ",");
        HashSet<String> exactMatch = new HashSet<String>(bootPackages.length);
        ArrayList<String> stemMatch = new ArrayList<String>(bootPackages.length);
        boolean delegateAllValue = false;
        for (int i = 0; i < bootPackages.length; ++i) {
            if (bootPackages[i].equals("*")) {
                delegateAllValue = true;
                exactMatch.clear();
                stemMatch.clear();
                break;
            }
            if (bootPackages[i].endsWith("*")) {
                if (bootPackages[i].length() <= 2 || !bootPackages[i].endsWith(".*")) continue;
                stemMatch.add(bootPackages[i].substring(0, bootPackages[i].length() - 1));
                continue;
            }
            exactMatch.add(bootPackages[i]);
        }
        this.bootDelegateAll = delegateAllValue;
        this.bootDelegation = exactMatch;
        this.bootDelegationStems = stemMatch.isEmpty() ? null : stemMatch.toArray(new String[stemMatch.size()]);
        boolean supportRecursion = true;
        for (ClassLoaderHook hook : this.equinoxConfig.getHookRegistry().getClassLoaderHooks()) {
            supportRecursion &= hook.isProcessClassRecursionSupported();
        }
        this.isProcessClassRecursionSupportedByAll = supportRecursion;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public EquinoxConfiguration getConfiguration() {
        return this.equinoxConfig;
    }

    public EquinoxLocations getLocations() {
        return this.equinoxConfig.getEquinoxLocations();
    }

    public EquinoxLogServices getLogServices() {
        return this.logServices;
    }

    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    public StartLevel getStartLevel() {
        return this.startLevel;
    }

    public SignedContentFactory getSignedContentFactory() {
        ServiceTracker<SignedContentFactory, SignedContentFactory> current = this.signedContentFactory;
        return current == null ? null : current.getService();
    }

    public boolean isBootDelegationPackage(String name) {
        if (this.bootDelegateAll) {
            return true;
        }
        if (this.bootDelegation.contains(name)) {
            return true;
        }
        if (this.bootDelegationStems != null) {
            for (int i = 0; i < this.bootDelegationStems.length; ++i) {
                if (!name.startsWith(this.bootDelegationStems[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isProcessClassRecursionSupportedByAll() {
        return this.isProcessClassRecursionSupportedByAll;
    }

    void init() {
        this.eventPublisher.init();
        this.serviceRegistry = new ServiceRegistry(this);
        this.initializeContextFinder();
        this.executor = Executors.newScheduledThreadPool(1, this);
        this.executor.execute(this);
        this.storageSaver = new StorageSaver(this);
    }

    void close() {
        this.serviceRegistry = null;
        StorageSaver currentSaver = this.storageSaver;
        Storage currentStorage = this.storage;
        ScheduledExecutorService currentExecutor = this.executor;
        currentSaver.close();
        currentStorage.close();
        currentExecutor.shutdown();
    }

    private void initializeContextFinder() {
        Thread current = Thread.currentThread();
        try {
            ClassLoader parent = null;
            String type = this.equinoxConfig.getConfiguration("osgi.contextClassLoaderParent");
            if ("app".equals(type)) {
                parent = ClassLoader.getSystemClassLoader();
            } else if ("boot".equals(type)) {
                parent = EquinoxContainerAdaptor.BOOT_CLASSLOADER;
            } else if ("fwk".equals(type)) {
                parent = EquinoxContainer.class.getClassLoader();
            } else if ("ext".equals(type)) {
                ClassLoader appCL = ClassLoader.getSystemClassLoader();
                if (appCL != null) {
                    parent = appCL.getParent();
                }
            } else {
                parent = current.getContextClassLoader();
            }
            this.contextFinder = new ContextFinder(parent);
            current.setContextClassLoader(this.contextFinder);
            return;
        }
        catch (Exception e) {
            this.logServices.log(NAME, 1, NLS.bind(Msg.CANNOT_SET_CONTEXTFINDER, null), e);
            return;
        }
    }

    public EquinoxEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    ScheduledExecutorService getScheduledExecutor() {
        return this.executor;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public ContextFinder getContextFinder() {
        return this.contextFinder;
    }

    public <K, V, E> ListenerQueue<K, V, E> newListenerQueue() {
        return this.eventPublisher.newListenerQueue();
    }

    void checkAdminPermission(Bundle bundle, String action) {
        if (bundle == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, action));
        }
    }

    public void handleRuntimeError(Throwable t) {
    }

    void systemStart(BundleContext bc) {
        this.signedContentFactory = new ServiceTracker(bc, SignedContentFactory.class, null);
        this.signedContentFactory.open();
    }

    void systemStop(BundleContext bc) {
        if (this.signedContentFactory != null) {
            this.signedContentFactory.close();
        }
    }

    public String toString() {
        String UUID2 = this.equinoxConfig == null ? null : this.equinoxConfig.getConfiguration("org.osgi.framework.uuid");
        return "Equinox Container: " + UUID2;
    }

    StorageSaver getStorageSaver() {
        return this.storageSaver;
    }

    @Override
    public Thread newThread(Runnable r) {
        String type = this.equinoxConfig.getConfiguration("osgi.framework.activeThreadType", "normal");
        Thread t = new Thread(r, "Active Thread: " + this.toString());
        if ("normal".equals(type)) {
            t.setDaemon(false);
        } else {
            t.setDaemon(true);
        }
        t.setPriority(5);
        return t;
    }

    @Override
    public void run() {
    }
}

