/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.ContextFinder;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.EquinoxEventPublisher;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.FilteredServiceListener;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ServiceConsumer;
import org.eclipse.osgi.internal.serviceregistry.ServiceObjectsImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableValueCollectionMap;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceRegistry {
    public static final int SERVICEEVENT = 3;
    static final String findHookName = FindHook.class.getName();
    static final String eventHookName = EventHook.class.getName();
    static final String eventListenerHookName = EventListenerHook.class.getName();
    static final String listenerHookName = ListenerHook.class.getName();
    private final Map<String, List<ServiceRegistrationImpl<?>>> publishedServicesByClass = new ConcurrentHashMap();
    private final Set<ServiceRegistrationImpl<?>> allPublishedServices = Collections.newSetFromMap(new ConcurrentSkipListMap());
    private final Map<BundleContextImpl, Queue<ServiceRegistrationImpl<?>>> publishedServicesByContext = new ConcurrentHashMap();
    private final AtomicLong serviceid = new AtomicLong(1L);
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> serviceEventListeners;
    private static final int initialCapacity = 50;
    private static final int initialSubCapacity = 10;
    private final EquinoxContainer container;
    private final BundleContextImpl systemBundleContext;
    final Debug debug;

    public ServiceRegistry(EquinoxContainer container) {
        this.container = container;
        this.debug = container.getConfiguration().getDebug();
        this.serviceEventListeners = new ConcurrentHashMap<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>>(50);
        Module systemModule = container.getStorage().getModuleContainer().getModule(0L);
        this.systemBundleContext = (BundleContextImpl)systemModule.getBundle().getBundleContext();
        this.systemBundleContext.provisionServicesInUseMap();
    }

    public ServiceRegistrationImpl<?> registerService(BundleContextImpl context, String[] clazzes, Object service, Dictionary<String, ?> properties) {
        String invalidService;
        if (service == null) {
            if (this.debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int size = clazzes.length;
        if (size == 0) {
            if (this.debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        ArrayList<String> copy = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String clazz = clazzes[i].intern();
            if (copy.contains(clazz)) continue;
            copy.add(clazz);
        }
        size = copy.size();
        clazzes = copy.toArray(new String[size]);
        ServiceRegistry.checkRegisterServicePermission(clazzes);
        if (!(service instanceof ServiceFactory) && (invalidService = ServiceRegistry.checkServiceClass(clazzes, service)) != null) {
            if (this.debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + invalidService);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, invalidService));
        }
        ServiceRegistrationImpl<Object> registration = new ServiceRegistrationImpl<Object>(this, context, clazzes, service);
        registration.register(properties);
        if (copy.contains(listenerHookName)) {
            this.notifyNewListenerHook(registration);
        }
        return registration;
    }

    public ServiceReferenceImpl<?>[] getServiceReferences(BundleContextImpl context, String clazz, String filterstring, boolean allservices) throws InvalidSyntaxException {
        if (this.debug.DEBUG_SERVICES) {
            Debug.println((allservices ? "getAllServiceReferences(" : "getServiceReferences(") + clazz + ", \"" + filterstring + "\")");
        }
        Filter filter = filterstring == null ? null : context.createFilter(filterstring);
        List<ServiceRegistrationImpl<?>> registrations = this.lookupServiceRegistrations(clazz, filter);
        ArrayList references = new ArrayList(registrations.size());
        for (ServiceRegistrationImpl<?> registration : registrations) {
            ServiceReferenceImpl<?> reference;
            try {
                reference = registration.getReferenceImpl();
            }
            catch (IllegalStateException e) {
                continue;
            }
            if (!allservices && !ServiceRegistry.isAssignableTo(context, reference)) continue;
            try {
                ServiceRegistry.checkGetServicePermission(reference);
            }
            catch (SecurityException se) {
                continue;
            }
            references.add(reference);
        }
        ArrayList copyReferences = references;
        if (context.getBundleImpl().getBundleId() == 0L) {
            copyReferences = new ArrayList(references);
        }
        ShrinkableCollection shrinkable = new ShrinkableCollection(copyReferences);
        this.notifyFindHooks(context, clazz, filterstring, allservices, shrinkable);
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    public ServiceReferenceImpl<?> getServiceReference(BundleContextImpl context, String clazz) {
        block4: {
            if (this.debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + clazz + ")");
            }
            try {
                ServiceReferenceImpl<?>[] references = this.getServiceReferences(context, clazz, null, false);
                if (references != null) {
                    return references[0];
                }
            }
            catch (InvalidSyntaxException e) {
                if (!this.debug.DEBUG_GENERAL) break block4;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public <S> S getService(BundleContextImpl context, ServiceReferenceImpl<S> reference) {
        ServiceRegistry.checkGetServicePermission(reference);
        return reference.getRegistration().getService(context, ServiceConsumer.singletonConsumer);
    }

    public <S> ServiceObjectsImpl<S> getServiceObjects(BundleContextImpl context, ServiceReferenceImpl<S> reference) {
        ServiceRegistry.checkGetServicePermission(reference);
        return reference.getRegistration().getServiceObjects(context);
    }

    public boolean ungetService(BundleContextImpl context, ServiceReferenceImpl<?> reference) {
        ServiceRegistrationImpl<?> registration = reference.getRegistration();
        return registration.ungetService(context, ServiceConsumer.singletonConsumer, null);
    }

    public ServiceReferenceImpl<?>[] getRegisteredServices(BundleContextImpl context) {
        List<ServiceRegistrationImpl<?>> registrations = this.lookupServiceRegistrations(context);
        ArrayList references = new ArrayList(registrations.size());
        for (ServiceRegistrationImpl<?> registration : registrations) {
            ServiceReferenceImpl<?> reference;
            try {
                reference = registration.getReferenceImpl();
            }
            catch (IllegalStateException e) {
                continue;
            }
            try {
                ServiceRegistry.checkGetServicePermission(reference);
            }
            catch (SecurityException se) {
                continue;
            }
            references.add(reference);
        }
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReferenceImpl<?>[] getServicesInUse(BundleContextImpl context) {
        ArrayList registrations;
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse = context.getServicesInUseMap();
        if (servicesInUse == null) {
            return null;
        }
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> map = servicesInUse;
        synchronized (map) {
            if (servicesInUse.isEmpty()) {
                return null;
            }
            registrations = new ArrayList(servicesInUse.keySet());
        }
        ArrayList references = new ArrayList(registrations.size());
        for (ServiceRegistrationImpl serviceRegistrationImpl : registrations) {
            ServiceReferenceImpl reference;
            try {
                reference = serviceRegistrationImpl.getReferenceImpl();
            }
            catch (IllegalStateException e) {
                continue;
            }
            try {
                ServiceRegistry.checkGetServicePermission(reference);
            }
            catch (SecurityException se) {
                continue;
            }
            references.add(reference);
        }
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    public void unregisterServices(BundleContextImpl context) {
        for (ServiceRegistrationImpl<?> registration : this.lookupServiceRegistrations(context)) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.removeServiceRegistrations(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServicesInUse(BundleContextImpl context) {
        ArrayList registrations;
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse = context.getServicesInUseMap();
        if (servicesInUse == null) {
            return;
        }
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> map = servicesInUse;
        synchronized (map) {
            if (servicesInUse.isEmpty()) {
                return;
            }
            registrations = new ArrayList(servicesInUse.keySet());
        }
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("Releasing services");
        }
        for (ServiceRegistrationImpl serviceRegistrationImpl : registrations) {
            serviceRegistrationImpl.releaseService(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(BundleContextImpl context, ServiceListener listener, String filter) throws InvalidSyntaxException {
        FilteredServiceListener oldFilteredListener;
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addServiceListener[" + context.getBundleImpl() + "](" + listenerName + ", \"" + filter + "\")");
        }
        FilteredServiceListener filteredListener = new FilteredServiceListener(context, listener, filter);
        Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> map = this.serviceEventListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> listeners = this.serviceEventListeners.get(context);
            if (listeners == null) {
                listeners = new CopyOnWriteIdentityMap();
                this.serviceEventListeners.put(context, listeners);
            }
            oldFilteredListener = listeners.put(listener, filteredListener);
        }
        if (oldFilteredListener != null) {
            oldFilteredListener.markRemoved();
            List<ListenerHook.ListenerInfo> removedListeners = Collections.singletonList(oldFilteredListener);
            this.notifyListenerHooks(removedListeners, false);
        }
        List<ListenerHook.ListenerInfo> addedListeners = Collections.singletonList(filteredListener);
        this.notifyListenerHooks(addedListeners, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(BundleContextImpl context, ServiceListener listener) {
        FilteredServiceListener oldFilteredListener;
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeServiceListener[" + context.getBundleImpl() + "](" + listenerName + ")");
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> map = this.serviceEventListeners;
        synchronized (map) {
            Map listeners = this.serviceEventListeners.get(context);
            if (listeners == null) {
                return;
            }
            oldFilteredListener = (FilteredServiceListener)listeners.remove(listener);
        }
        if (oldFilteredListener == null) {
            return;
        }
        oldFilteredListener.markRemoved();
        List<ListenerHook.ListenerInfo> removedListeners = Collections.singletonList(oldFilteredListener);
        this.notifyListenerHooks(removedListeners, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServiceListeners(BundleContextImpl context) {
        Map removedListenersMap;
        Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> map = this.serviceEventListeners;
        synchronized (map) {
            removedListenersMap = this.serviceEventListeners.remove(context);
        }
        if (removedListenersMap == null || removedListenersMap.isEmpty()) {
            return;
        }
        Collection removedListeners = removedListenersMap.values();
        for (FilteredServiceListener oldFilteredListener : removedListeners) {
            oldFilteredListener.markRemoved();
        }
        this.notifyListenerHooks(ServiceRegistry.asListenerInfos(removedListeners), false);
    }

    private static Collection<ListenerHook.ListenerInfo> asListenerInfos(Collection<? extends ListenerHook.ListenerInfo> c) {
        return c;
    }

    public void publishServiceEvent(final ServiceEvent event) {
        if (System.getSecurityManager() == null) {
            this.publishServiceEventPrivileged(event);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceRegistry.this.publishServiceEventPrivileged(event);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishServiceEventPrivileged(ServiceEvent event) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> listenerSnapshot;
        List<ServiceRegistrationImpl<?>> eventHooks = this.lookupServiceRegistrations(eventHookName, null);
        List<ServiceRegistrationImpl<?>> eventListenerHooks = this.lookupServiceRegistrations(eventListenerHookName, null);
        if (eventHooks.isEmpty() && eventListenerHooks.isEmpty()) {
            listenerSnapshot = this.serviceEventListeners;
        } else {
            CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> systemServiceListenersOrig = null;
            BundleContextImpl systemContext = null;
            Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> map = this.serviceEventListeners;
            synchronized (map) {
                listenerSnapshot = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>>(this.serviceEventListeners.size());
                for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> entry : this.serviceEventListeners.entrySet()) {
                    CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> copyOnWriteIdentityMap = entry.getValue();
                    if (copyOnWriteIdentityMap.isEmpty()) continue;
                    if (entry.getKey().getBundleImpl().getBundleId() == 0L) {
                        systemContext = entry.getKey();
                        systemServiceListenersOrig = copyOnWriteIdentityMap;
                    }
                    listenerSnapshot.put(entry.getKey(), copyOnWriteIdentityMap);
                }
            }
            Collection<BundleContext> contexts = ServiceRegistry.asBundleContexts(listenerSnapshot.keySet());
            this.notifyEventHooksPrivileged(event, contexts);
            if (!listenerSnapshot.isEmpty()) {
                HashMap adaptedListenerSnapshot = new HashMap();
                for (Map.Entry entry : listenerSnapshot.entrySet()) {
                    adaptedListenerSnapshot.put(entry.getKey(), ((CopyOnWriteIdentityMap)entry.getValue()).entrySet());
                }
                ShrinkableValueCollectionMap<BundleContext, ListenerHook.ListenerInfo> listeners = new ShrinkableValueCollectionMap<BundleContext, ListenerHook.ListenerInfo>(adaptedListenerSnapshot);
                this.notifyEventListenerHooksPrivileged(event, listeners);
                listenerSnapshot.keySet().retainAll(adaptedListenerSnapshot.keySet());
            }
            if (systemServiceListenersOrig != null) {
                listenerSnapshot.put(systemContext, systemServiceListenersOrig);
            }
        }
        if (listenerSnapshot.isEmpty()) {
            return;
        }
        EquinoxConfiguration equinoxConfiguration = this.container.getConfiguration();
        Thread currentThread = null;
        ClassLoader previousTCCL = null;
        if (equinoxConfiguration.BUNDLE_SET_TCCL) {
            ContextFinder contextFinder;
            currentThread = Thread.currentThread();
            previousTCCL = currentThread.getContextClassLoader();
            if (previousTCCL == (contextFinder = this.container.getContextFinder())) {
                previousTCCL = null;
            } else {
                currentThread.setContextClassLoader(contextFinder);
            }
        }
        try {
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> bundleContextEntry : listenerSnapshot.entrySet()) {
                CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> copyOnWriteIdentityMap = bundleContextEntry.getValue();
                for (FilteredServiceListener filteredServiceListener : copyOnWriteIdentityMap.values()) {
                    try {
                        filteredServiceListener.serviceChanged(event);
                    }
                    catch (Throwable t) {
                        if (this.debug.DEBUG_GENERAL) {
                            Debug.println("Exception in bottom level event dispatcher: " + t.getMessage());
                            Debug.printStackTrace(t);
                        }
                        this.container.handleRuntimeError(t);
                        EquinoxEventPublisher equinoxEventPublisher = this.container.getEventPublisher();
                        BundleContextImpl bundleContextImpl = bundleContextEntry.getKey();
                        equinoxEventPublisher.publishFrameworkEvent(2, bundleContextImpl.getBundle(), t);
                    }
                }
            }
        }
        finally {
            if (previousTCCL != null) {
                currentThread.setContextClassLoader(previousTCCL);
            }
        }
    }

    private static Collection<BundleContext> asBundleContexts(Collection<? extends BundleContext> c) {
        return c;
    }

    long getNextServiceId() {
        return this.serviceid.getAndIncrement();
    }

    void addServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl<?> registration) {
        Queue<ServiceRegistrationImpl<?>> previousContextServices;
        Queue<ServiceRegistrationImpl<?>> contextServices = this.publishedServicesByContext.get(context);
        if (contextServices == null && (previousContextServices = this.publishedServicesByContext.putIfAbsent(context, contextServices = new ConcurrentLinkedQueue())) != null) {
            contextServices = previousContextServices;
        }
        contextServices.add(registration);
        for (String clazz : registration.getClasses()) {
            this.publishedServicesByClass.compute(clazz, (className, services) -> {
                if (services == null) {
                    return Collections.singletonList(registration);
                }
                services = new ArrayList<ServiceRegistrationImpl>((Collection<ServiceRegistrationImpl>)services);
                int insertIndex = -Collections.binarySearch(services, registration) - 1;
                services.add(insertIndex, registration);
                return services;
            });
        }
        this.allPublishedServices.add(registration);
    }

    void modifyServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl<?> registration) {
        for (String clazz : registration.getClasses()) {
            this.publishedServicesByClass.compute(clazz, (className, services) -> {
                services = new ArrayList<ServiceRegistrationImpl>((Collection<ServiceRegistrationImpl>)services);
                services.remove(registration);
                int insertIndex = -Collections.binarySearch(services, registration) - 1;
                services.add(insertIndex, registration);
                return services;
            });
        }
        this.allPublishedServices.remove(registration);
        this.allPublishedServices.add(registration);
    }

    void removeServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl<?> registration) {
        Queue<ServiceRegistrationImpl<?>> contextServices = this.publishedServicesByContext.get(context);
        if (contextServices != null) {
            contextServices.remove(registration);
        }
        for (String clazz : registration.getClasses()) {
            this.publishedServicesByClass.compute(clazz, (className, services) -> {
                services = new ArrayList(services);
                services.remove(registration);
                if (services.isEmpty()) {
                    return null;
                }
                return services;
            });
        }
        this.allPublishedServices.remove(registration);
    }

    private List<ServiceRegistrationImpl<?>> lookupServiceRegistrations(String clazz, Filter filter) {
        Collection<ServiceRegistrationImpl<Object>> result;
        if (clazz == null && filter instanceof FilterImpl) {
            FilterImpl filterImpl = (FilterImpl)filter;
            clazz = filterImpl.getRequiredObjectClass();
        }
        if ((result = clazz == null ? this.allPublishedServices : (Collection)this.publishedServicesByClass.get(clazz)) == null || result.isEmpty()) {
            List<ServiceRegistrationImpl<?>> empty = Collections.emptyList();
            return empty;
        }
        if (filter == null) {
            return new ArrayList(result);
        }
        LinkedList listResult = new LinkedList(result);
        Iterator iter = listResult.iterator();
        while (iter.hasNext()) {
            ServiceReferenceImpl reference;
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            try {
                reference = registration.getReferenceImpl();
            }
            catch (IllegalStateException e) {
                iter.remove();
                continue;
            }
            if (filter.match(reference)) continue;
            iter.remove();
        }
        return listResult;
    }

    private List<ServiceRegistrationImpl<?>> lookupServiceRegistrations(BundleContextImpl context) {
        Queue<ServiceRegistrationImpl<?>> result = this.publishedServicesByContext.get(context);
        if (result == null || result.isEmpty()) {
            List<ServiceRegistrationImpl<?>> empty = Collections.emptyList();
            return empty;
        }
        return new ArrayList(result);
    }

    private void removeServiceRegistrations(BundleContextImpl context) {
        this.publishedServicesByContext.remove(context);
    }

    private static void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            sm.checkPermission(new ServicePermission(names[i], "register"));
        }
    }

    private static void checkGetServicePermission(ServiceReference<?> reference) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(new ServicePermission(reference, "get"));
    }

    static boolean hasListenServicePermission(ServiceEvent event, BundleContextImpl context) {
        ModuleRevision revision = context.getBundleImpl().getModule().getCurrentRevision();
        if (revision == null) {
            return false;
        }
        ProtectionDomain domain = ((BundleInfo.Generation)revision.getRevisionInfo()).getDomain();
        if (domain == null) {
            return true;
        }
        return domain.implies(new ServicePermission(event.getServiceReference(), "get"));
    }

    static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int len = clazzes.length;
        for (int i = 0; i < len; ++i) {
            try {
                Class<?> serviceClazz;
                Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                if (serviceClazz.isInstance(serviceObject)) continue;
                return clazzes[i];
            }
            catch (ClassNotFoundException e) {
                if (!ServiceRegistry.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) continue;
                return clazzes[i];
            }
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class<?> serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int len = interfaces.length;
        for (int i = 0; i < len; ++i) {
            if (ServiceRegistry.extensiveCheckServiceClass(clazz, interfaces[i])) continue;
            return false;
        }
        Class<?> superClazz = serviceClazz.getSuperclass();
        return superClazz == null || ServiceRegistry.extensiveCheckServiceClass(clazz, superClazz);
    }

    static boolean isAssignableTo(BundleContextImpl context, ServiceReferenceImpl<?> reference) {
        EquinoxBundle bundle = context.getBundleImpl();
        String[] clazzes = reference.getClasses();
        int len = clazzes.length;
        for (int i = 0; i < len; ++i) {
            if (reference.isAssignableTo(bundle, clazzes[i])) continue;
            return false;
        }
        return true;
    }

    private void notifyFindHooks(final BundleContextImpl context, final String clazz, final String filterstring, final boolean allservices, final Collection<ServiceReference<?>> result) {
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPrivileged(context, clazz, filterstring, allservices, result);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceRegistry.this.notifyFindHooksPrivileged(context, clazz, filterstring, allservices, result);
                    return null;
                }
            });
        }
    }

    void notifyFindHooksPrivileged(final BundleContextImpl context, final String clazz, final String filterstring, final boolean allservices, final Collection<ServiceReference<?>> result) {
        if (this.debug.DEBUG_HOOKS) {
            Debug.println("notifyServiceFindHooks(" + context.getBundleImpl() + "," + clazz + "," + filterstring + "," + allservices + "," + result + ")");
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof FindHook) {
                    ((FindHook)hook).find(context, clazz, filterstring, allservices, result);
                }
            }

            @Override
            public String getHookClassName() {
                return findHookName;
            }

            @Override
            public String getHookMethodName() {
                return "find";
            }

            @Override
            public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
                return false;
            }
        });
    }

    private void notifyEventHooksPrivileged(final ServiceEvent event, final Collection<BundleContext> result) {
        if (this.debug.DEBUG_HOOKS) {
            Debug.println("notifyServiceEventHooks(" + event.getType() + ":" + event.getServiceReference() + "," + result + ")");
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof EventHook) {
                    ((EventHook)hook).event(event, result);
                }
            }

            @Override
            public String getHookClassName() {
                return eventHookName;
            }

            @Override
            public String getHookMethodName() {
                return "event";
            }

            @Override
            public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
                return false;
            }
        });
    }

    private void notifyEventListenerHooksPrivileged(final ServiceEvent event, final Map<BundleContext, Collection<ListenerHook.ListenerInfo>> result) {
        if (this.debug.DEBUG_HOOKS) {
            Debug.println("notifyServiceEventListenerHooks(" + event.getType() + ":" + event.getServiceReference() + "," + result + ")");
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof EventListenerHook) {
                    ((EventListenerHook)hook).event(event, result);
                }
            }

            @Override
            public String getHookClassName() {
                return eventListenerHookName;
            }

            @Override
            public String getHookMethodName() {
                return "event";
            }

            @Override
            public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
                return false;
            }
        });
    }

    public void notifyHooksPrivileged(HookContext hookContext) {
        List<ServiceRegistrationImpl<?>> hooks = this.lookupServiceRegistrations(hookContext.getHookClassName(), null);
        for (ServiceRegistrationImpl<?> registration : hooks) {
            this.notifyHookPrivileged(this.systemBundleContext, registration, hookContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHookPrivileged(BundleContextImpl context, ServiceRegistrationImpl<?> registration, HookContext hookContext) {
        if (hookContext.skipRegistration(registration)) {
            return;
        }
        Object hook = registration.getSafeService(context, ServiceConsumer.singletonConsumer);
        if (hook == null) {
            return;
        }
        try {
            hookContext.call(hook, registration);
        }
        catch (Throwable t) {
            if (this.debug.DEBUG_HOOKS) {
                Debug.println(hook.getClass().getName() + "." + hookContext.getHookMethodName() + "() exception: " + t.getMessage());
                Debug.printStackTrace(t);
            }
            this.container.handleRuntimeError(t);
            ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, hook.getClass().getName(), hookContext.getHookMethodName()), t);
            this.container.getEventPublisher().publishFrameworkEvent(2, registration.getBundle(), se);
        }
        finally {
            registration.ungetService(context, ServiceConsumer.singletonConsumer, null);
        }
    }

    private void notifyNewListenerHook(final ServiceRegistrationImpl<?> registration) {
        if (System.getSecurityManager() == null) {
            this.notifyNewListenerHookPrivileged(registration);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceRegistry.this.notifyNewListenerHookPrivileged(registration);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNewListenerHookPrivileged(ServiceRegistrationImpl<?> registration) {
        if (this.debug.DEBUG_HOOKS) {
            Debug.println("notifyServiceNewListenerHook(" + registration + ")");
        }
        ArrayList<FilteredServiceListener> addedListeners = new ArrayList<FilteredServiceListener>(50);
        Map<BundleContextImpl, CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener>> map = this.serviceEventListeners;
        synchronized (map) {
            for (CopyOnWriteIdentityMap<ServiceListener, FilteredServiceListener> listeners : this.serviceEventListeners.values()) {
                if (listeners.isEmpty()) continue;
                addedListeners.addAll(listeners.values());
            }
        }
        final Collection listeners = Collections.unmodifiableCollection(addedListeners);
        this.notifyHookPrivileged(this.systemBundleContext, registration, new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof ListenerHook) {
                    ((ListenerHook)hook).added(listeners);
                }
            }

            @Override
            public String getHookClassName() {
                return listenerHookName;
            }

            @Override
            public String getHookMethodName() {
                return "added";
            }

            @Override
            public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
                return false;
            }
        });
    }

    private void notifyListenerHooks(final Collection<ListenerHook.ListenerInfo> listeners, final boolean added) {
        if (System.getSecurityManager() == null) {
            this.notifyListenerHooksPrivileged(listeners, added);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServiceRegistry.this.notifyListenerHooksPrivileged(listeners, added);
                    return null;
                }
            });
        }
    }

    void notifyListenerHooksPrivileged(final Collection<ListenerHook.ListenerInfo> listeners, final boolean added) {
        assert (!listeners.isEmpty());
        if (this.debug.DEBUG_HOOKS) {
            Debug.println("notifyServiceListenerHooks(" + listeners + "," + (added ? "added" : "removed") + ")");
        }
        this.notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof ListenerHook) {
                    if (added) {
                        ((ListenerHook)hook).added(listeners);
                    } else {
                        ((ListenerHook)hook).removed(listeners);
                    }
                }
            }

            @Override
            public String getHookClassName() {
                return listenerHookName;
            }

            @Override
            public String getHookMethodName() {
                return added ? "added" : "removed";
            }

            @Override
            public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
                return false;
            }
        });
    }

    final EquinoxContainer getContainer() {
        return this.container;
    }
}

