/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumnAccessor;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.RangeGroup;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class ColumnSchema
extends ColumnBase
implements SchemaObject {
    public static final ColumnSchema[] emptyArray = new ColumnSchema[0];
    private HsqlNameManager.HsqlName columnName;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    private Expression generatingExpression;
    private Expression updateExpression;
    private NumberSequence sequence;
    private OrderedHashSet references;
    private OrderedHashSet generatedColumnReferences;
    private Expression accessor;
    private int systemPeriodType;

    ColumnSchema(HsqlNameManager.HsqlName name, Type type) {
        this.columnName = name;
        this.dataType = type;
    }

    public ColumnSchema(HsqlNameManager.HsqlName name, Type type, boolean isNullable, boolean isPrimaryKey, Expression defaultExpression) {
        this.columnName = name;
        this.nullability = isNullable ? (byte)1 : 0;
        this.dataType = type;
        this.isPrimaryKey = isPrimaryKey;
        this.defaultExpression = defaultExpression;
        this.setReferences();
    }

    @Override
    public int getType() {
        return this.columnName.type;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.columnName;
    }

    @Override
    public String getNameString() {
        return this.columnName.name;
    }

    @Override
    public String getTableNameString() {
        return this.columnName.parent == null ? null : this.columnName.parent.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.columnName.schema;
    }

    @Override
    public String getSchemaNameString() {
        return this.columnName.schema == null ? null : this.columnName.schema.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.columnName.schema == null ? null : this.columnName.schema.schema;
    }

    @Override
    public String getCatalogNameString() {
        return this.columnName.schema == null ? null : (this.columnName.schema.schema == null ? null : this.columnName.schema.schema.name);
    }

    @Override
    public Grantee getOwner() {
        return this.columnName.schema == null ? null : this.columnName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject table) {
        if (this.generatingExpression == null) {
            return;
        }
        this.generatingExpression.resetColumnReferences();
        this.generatingExpression.resolveCheckOrGenExpression(session, new RangeGroup.RangeGroupSimple(((Table)table).getDefaultRanges(), false), false);
        if (!this.dataType.canBeAssignedFrom(this.generatingExpression.getDataType())) {
            throw Error.error(5561);
        }
        this.setReferences();
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        switch (this.parameterMode) {
            case 1: {
                sb.append("IN").append(' ');
                break;
            }
            case 4: {
                sb.append("OUT").append(' ');
                break;
            }
            case 2: {
                sb.append("INOUT").append(' ');
                break;
            }
        }
        if (this.columnName != null) {
            sb.append(this.columnName.statementName);
            sb.append(' ');
        }
        sb.append(this.dataType.getTypeDefinition());
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public void setType(Type type) {
        this.dataType = type;
        this.setReferences();
    }

    public void setName(HsqlNameManager.HsqlName name) {
        this.columnName = name;
    }

    void setIdentity(NumberSequence sequence) {
        this.sequence = sequence;
        this.isIdentity = sequence != null;
    }

    void setType(ColumnSchema other) {
        this.nullability = other.nullability;
        this.dataType = other.dataType;
    }

    public NumberSequence getIdentitySequence() {
        return this.sequence;
    }

    @Override
    public boolean isNullable() {
        boolean isNullable = super.isNullable();
        if (isNullable && this.dataType.isDomainType()) {
            return this.dataType.userTypeModifier.isNullable();
        }
        return isNullable;
    }

    @Override
    public byte getNullability() {
        return this.isPrimaryKey ? (byte)0 : super.getNullability();
    }

    public boolean isGenerated() {
        return this.generatingExpression != null;
    }

    public boolean isAutoUpdate() {
        return this.updateExpression != null;
    }

    public boolean hasDefault() {
        return this.getDefaultExpression() != null;
    }

    public void setUpdateExpression(Expression updateExpression) {
        this.updateExpression = updateExpression;
    }

    public Expression getUpdateExpression() {
        return this.updateExpression;
    }

    @Override
    public boolean isWriteable() {
        return this.isWriteable;
    }

    @Override
    public void setWriteable(boolean value) {
        this.isWriteable = value;
    }

    @Override
    public boolean isSearchable() {
        return Types.isSearchable(this.dataType.typeCode);
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    public Object getDefaultValue(Session session) {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.dataType);
    }

    public Object getGeneratedValue(Session session) {
        return this.generatingExpression == null ? null : this.generatingExpression.getValue(session, this.dataType);
    }

    public String getDefaultSQL() {
        String ddl = null;
        ddl = this.defaultExpression == null ? null : this.defaultExpression.getSQL();
        return ddl;
    }

    Expression getDefaultExpression() {
        if (this.defaultExpression == null) {
            if (this.dataType.isDomainType()) {
                return this.dataType.userTypeModifier.getDefaultClause();
            }
            return null;
        }
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    public Expression getGeneratingExpression() {
        return this.generatingExpression;
    }

    void setGeneratingExpression(Expression expr) {
        this.generatingExpression = expr;
        this.setWriteable(this.generatingExpression == null);
    }

    public boolean isSystemPeriod() {
        return this.systemPeriodType != 0;
    }

    public int getSystemPeriodType() {
        return this.systemPeriodType;
    }

    void setSystemPeriodType(int type) {
        this.systemPeriodType = type;
        boolean writable = type == 0;
        this.setWriteable(writable);
    }

    public ColumnSchema duplicate() {
        ColumnSchema copy = new ColumnSchema(this.columnName, this.dataType, true, this.isPrimaryKey, this.defaultExpression);
        copy.setNullability(this.nullability);
        copy.setGeneratingExpression(this.generatingExpression);
        copy.setIdentity(this.sequence);
        copy.setUpdateExpression(this.updateExpression);
        copy.setSystemPeriodType(this.systemPeriodType);
        return copy;
    }

    public Expression getAccessor() {
        if (this.accessor == null) {
            this.accessor = new ExpressionColumnAccessor(this);
        }
        return this.accessor;
    }

    public OrderedHashSet getGeneratedColumnReferences() {
        return this.generatedColumnReferences;
    }

    private void setReferences() {
        if (this.references != null) {
            this.references.clear();
        }
        if (this.generatedColumnReferences != null) {
            this.generatedColumnReferences.clear();
        }
        if (this.dataType.isDomainType() || this.dataType.isDistinctType()) {
            HsqlNameManager.HsqlName name = this.dataType.getName();
            if (this.references == null) {
                this.references = new OrderedHashSet();
            }
            this.references.add(name);
        }
        if (this.generatingExpression != null) {
            OrderedHashSet set = new OrderedHashSet();
            this.generatingExpression.collectObjectNames(set);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                if (name.type == 9 || name.type == 3) {
                    if (name.type != 9) continue;
                    if (this.generatedColumnReferences == null) {
                        this.generatedColumnReferences = new OrderedHashSet();
                    }
                    this.generatedColumnReferences.add(name);
                    continue;
                }
                if (this.references == null) {
                    this.references = new OrderedHashSet();
                }
                this.references.add(name);
            }
        }
    }
}

