/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserCommand;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LobManager;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.PersistentStoreCollectionDatabase;
import org.hsqldb.result.Result;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;
import org.hsqldb.rights.UserManager;
import org.hsqldb.types.Collation;

public class Database {
    int databaseID;
    HsqlNameManager.HsqlName databaseUniqueName;
    DatabaseType databaseType;
    private final String canonicalPath;
    public HsqlProperties urlProperties;
    private final String path;
    public Collation collation;
    public DatabaseInformation dbInfo;
    private volatile int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public int sqlAvgScale = 0;
    public boolean sqlRestrictExec = false;
    public boolean sqlCharLiteral = true;
    public boolean sqlConcatNulls = true;
    public boolean sqlConvertTruncate = true;
    public boolean sqlDoubleNaN = true;
    public boolean sqlEnforceTypes = false;
    public boolean sqlEnforceRefs = false;
    public boolean sqlEnforceSize = true;
    public boolean sqlEnforceNames = false;
    public boolean sqlEnforceTDCD = true;
    public boolean sqlEnforceTDCU = true;
    public boolean sqlIgnoreCase = false;
    public boolean sqlLiveObject = false;
    public boolean sqlLongvarIsLob = false;
    public boolean sqlLowerCaseIdentifier = false;
    public boolean sqlNullsFirst = true;
    public boolean sqlNullsOrder = true;
    public int sqlMaxRecursive = 256;
    public boolean sqlRegularNames = true;
    public boolean sqlSyntaxDb2 = false;
    public boolean sqlSyntaxMss = false;
    public boolean sqlSyntaxMys = false;
    public boolean sqlSyntaxOra = false;
    public boolean sqlSyntaxPgs = false;
    public boolean sqlSysIndexNames = false;
    public boolean sqlTranslateTTI = true;
    public boolean sqlTruncateTrailing = true;
    public boolean sqlUniqueNulls = true;
    public int recoveryMode = 0;
    private boolean isReferentialIntegrity = true;
    public HsqlDatabaseProperties databaseProperties;
    private final boolean shutdownOnNoConnection;
    int resultMaxMemoryRows;
    public UserManager userManager;
    public GranteeManager granteeManager;
    public HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    public int defaultIsolationLevel = 2;
    public boolean txConflictRollback = true;
    public boolean txInterruptRollback = false;
    public SchemaManager schemaManager;
    public PersistentStoreCollectionDatabase persistentStoreCollection;
    public LobManager lobManager;
    public CheckpointRunner checkpointRunner;
    public TimeoutRunner timeoutRunner;
    Result updateZeroResult = Result.updateZeroResult;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 2;
    public static final int DATABASE_CLOSING = 3;
    public static final int DATABASE_SHUTDOWN = 4;
    public static final int CLOSEMODE_IMMEDIATELY = 1;
    public static final int CLOSEMODE_NORMAL = 2;
    public static final int CLOSEMODE_COMPACT = 3;
    public static final int CLOSEMODE_SCRIPT = 4;

    Database(DatabaseType type, String path, String canonicalPath, HsqlProperties props) {
        this.setState(4);
        this.databaseType = type;
        this.path = path;
        this.canonicalPath = canonicalPath;
        this.urlProperties = props;
        if (this.databaseType == DatabaseType.DB_RES) {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        this.logger = new Logger(this);
        this.shutdownOnNoConnection = this.urlProperties.isPropertyTrue("shutdown");
        this.recoveryMode = this.urlProperties.getIntegerProperty("recover", 0);
    }

    synchronized void open() {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() {
        boolean isNew = false;
        this.setState(2);
        try {
            this.createObjectStructures();
            this.logger.open();
            isNew = this.logger.isNewDatabase;
            if (isNew) {
                String username = this.urlProperties.getProperty("user", "SA");
                String password = this.urlProperties.getProperty("password", "");
                this.userManager.createFirstUser(username, password);
                this.schemaManager.createPublicSchema();
                this.logger.checkpoint(null, false, false);
            }
            this.lobManager.open();
            this.dbInfo.setWithContent(true);
            this.checkpointRunner = new CheckpointRunner();
            this.timeoutRunner = new TimeoutRunner();
        }
        catch (Throwable e2) {
            HsqlException e2;
            this.logger.close(1);
            this.logger.releaseLock();
            this.setState(4);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (!(e2 instanceof HsqlException)) {
                e2 = Error.error(458, e2);
            }
            this.logger.logSevereEvent("could not reopen database", e2);
            throw e2;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.release();
        }
        if (this.checkpointRunner != null) {
            this.checkpointRunner.stop();
        }
        if (this.timeoutRunner != null) {
            this.timeoutRunner.stop();
        }
        this.lobManager = null;
        this.granteeManager = null;
        this.userManager = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
        this.checkpointRunner = null;
        this.timeoutRunner = null;
    }

    public void createObjectStructures() {
        this.nameManager = new HsqlNameManager(this);
        this.databaseUniqueName = this.nameManager.newHsqlName("", false, 0);
        this.lobManager = new LobManager(this);
        this.granteeManager = new GranteeManager(this);
        this.userManager = new UserManager(this);
        this.schemaManager = new SchemaManager(this);
        this.persistentStoreCollection = new PersistentStoreCollectionDatabase(this);
        this.isReferentialIntegrity = true;
        this.sessionManager = new SessionManager(this);
        this.collation = Collation.newDatabaseInstance();
        this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
        this.txManager = new TransactionManager2PL(this);
        this.lobManager.createSchema();
        this.sessionManager.getSysLobSession().setSchema("SYSTEM_LOBS");
        this.schemaManager.setSchemaChangeTimestamp();
        this.schemaManager.createSystemTables();
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.databaseUniqueName;
    }

    public String getNameString() {
        return this.databaseUniqueName.name;
    }

    public void setDatabaseName(String name) {
        this.databaseUniqueName.rename(name, false);
    }

    public DatabaseType getType() {
        return this.databaseType;
    }

    public String getPath() {
        return this.path;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.nameManager.getCatalogName();
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isReadOnly() {
        return this.databaseReadOnly;
    }

    boolean isShutdown() {
        return this.dbState == 4;
    }

    synchronized Session connect(String username, String password, TimeZone zone) {
        if (this.getState() != 1) {
            throw Error.error(1301);
        }
        if (username.equalsIgnoreCase("SA")) {
            username = "SA";
        }
        User user = this.userManager.getUser(username, password);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, true, zone);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setLiveObject(boolean mode) {
        this.sqlLiveObject = mode;
    }

    public void setReferentialIntegrity(boolean ref) {
        this.isReferentialIntegrity = ref;
    }

    public boolean isReferentialIntegrity() {
        return this.isReferentialIntegrity;
    }

    public int getResultMaxMemoryRows() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMaxMemoryRows(int size) {
        this.resultMaxMemoryRows = size;
    }

    public void setRestrictExec(boolean mode) {
        this.sqlRestrictExec = mode;
    }

    public void setStrictNames(boolean mode) {
        this.sqlEnforceNames = mode;
    }

    public void setRegularNames(boolean mode) {
        this.sqlRegularNames = mode;
        this.nameManager.setSqlRegularNames(mode);
    }

    public void setStrictColumnSize(boolean mode) {
        this.sqlEnforceSize = mode;
    }

    public void setStrictReferences(boolean mode) {
        this.sqlEnforceRefs = mode;
    }

    public void setStrictTypes(boolean mode) {
        this.sqlEnforceTypes = mode;
    }

    public void setStrictTDCD(boolean mode) {
        this.sqlEnforceTDCD = mode;
    }

    public void setStrictTDCU(boolean mode) {
        this.sqlEnforceTDCU = mode;
    }

    public void setTranslateTTI(boolean mode) {
        this.sqlTranslateTTI = mode;
    }

    public void setNullsFirst(boolean mode) {
        this.sqlNullsFirst = mode;
    }

    public void setNullsOrder(boolean mode) {
        this.sqlNullsOrder = mode;
    }

    public void setCharacterLiteral(boolean mode) {
        this.sqlCharLiteral = mode;
    }

    public void setConcatNulls(boolean mode) {
        this.sqlConcatNulls = mode;
    }

    public void setUniqueNulls(boolean mode) {
        this.sqlUniqueNulls = mode;
    }

    public void setConvertTrunc(boolean mode) {
        this.sqlConvertTruncate = mode;
    }

    public void setTruncateTrailing(boolean mode) {
        this.sqlTruncateTrailing = mode;
    }

    public void setDoubleNaN(boolean mode) {
        this.sqlDoubleNaN = mode;
    }

    public void setAvgScale(int scale) {
        this.sqlAvgScale = scale;
    }

    public void setMaxRecursive(int value) {
        this.sqlMaxRecursive = value;
    }

    public void setLongVarIsLob(boolean mode) {
        this.sqlLongvarIsLob = mode;
    }

    public void setIgnoreCase(boolean mode) {
        this.sqlIgnoreCase = mode;
    }

    public void setSysIndexNames(boolean mode) {
        this.sqlSysIndexNames = mode;
    }

    public void setLowerCaseIndentifer(boolean mode) {
        this.sqlLowerCaseIdentifier = mode;
    }

    public void setSyntaxDb2(boolean mode) {
        this.sqlSyntaxDb2 = mode;
    }

    public void setSyntaxMss(boolean mode) {
        this.sqlSyntaxMss = mode;
    }

    public void setSyntaxMys(boolean mode) {
        this.sqlSyntaxMys = mode;
    }

    public void setSyntaxOra(boolean mode) {
        this.sqlSyntaxOra = mode;
    }

    public void setSyntaxPgs(boolean mode) {
        this.sqlSyntaxPgs = mode;
    }

    void closeIfLast() {
        if (this.sessionManager.isEmpty() && this.dbState == 1) {
            if (this.shutdownOnNoConnection) {
                try {
                    this.close(2);
                }
                catch (HsqlException hsqlException) {}
            } else {
                this.logger.synchLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closemode) {
        HsqlException he = null;
        Database database = this;
        synchronized (database) {
            if (this.getState() != 1) {
                return;
            }
            this.setState(3);
        }
        this.sessionManager.closeAllSessions();
        if (this.filesReadOnly) {
            closemode = 1;
        }
        boolean result = this.logger.close(closemode);
        this.lobManager.close();
        this.sessionManager.close();
        try {
            if (result && closemode == 3) {
                this.clearStructures();
                this.reopen();
                this.txManager.setSystemChangeNumber(this.txManager.getSystemChangeNumber() + 1L);
                this.setState(3);
                this.sessionManager.closeAllSessions();
                this.logger.close(2);
                this.lobManager.close();
                this.sessionManager.close();
            }
        }
        catch (Throwable t) {
            he = t instanceof HsqlException ? (HsqlException)t : Error.error(458, t);
        }
        this.logger.releaseLock();
        this.setState(4);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        FrameworkLogger.clearLoggers("hsqldb.db." + this.getNameString());
        if (he != null) {
            throw he;
        }
    }

    private void setState(int state) {
        this.dbState = state;
    }

    int getState() {
        return this.dbState;
    }

    String getStateString() {
        int state = this.getState();
        switch (state) {
            case 3: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 2: {
                return "DATABASE_OPENING";
            }
            case 4: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String[] getSettingsSQL() {
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!this.getCatalogName().name.equals("PUBLIC")) {
            String name = this.getCatalogName().statementName;
            sb.append("ALTER CATALOG PUBLIC RENAME TO ").append(name);
            list.add(sb.toString());
            sb.setLength(0);
        }
        list.add(this.collation.getDatabaseCollationSQL());
        OrderedHashMap lobTables = this.schemaManager.getTables("SYSTEM_LOBS");
        for (int i = 0; i < lobTables.size(); ++i) {
            Table table = (Table)lobTables.get(i);
            if (!table.isCached()) continue;
            sb.append("SET").append(' ').append("TABLE");
            sb.append(' ');
            sb.append(table.getName().getSchemaQualifiedStatementName());
            sb.append(' ').append("TYPE").append(' ');
            sb.append("CACHED");
            list.add(sb.toString());
            sb.setLength(0);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public Result getScript(boolean indexRoots) {
        Result r = Result.newSingleColumnResult("COMMAND");
        String[] list = this.logger.getPropertiesSQL(indexRoots);
        r.addRows(list);
        list = this.getSettingsSQL();
        r.addRows(list);
        list = this.granteeManager.getSQL();
        r.addRows(list);
        list = this.schemaManager.getSQLArray();
        r.addRows(list);
        list = this.schemaManager.getTableSpaceSQL();
        r.addRows(list);
        if (indexRoots) {
            list = this.schemaManager.getIndexRootsSQL();
            r.addRows(list);
        }
        list = this.schemaManager.getTablePropsSQL(!indexRoots);
        r.addRows(list);
        list = this.userManager.getAuthenticationSQL();
        r.addRows(list);
        list = this.userManager.getInitialSchemaSQL();
        r.addRows(list);
        list = this.granteeManager.getRightsSQL();
        r.addRows(list);
        return r;
    }

    public String getURI() {
        return this.databaseType.value() + this.canonicalPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }

    public TimeoutRunner getTimeoutRunner() {
        return this.timeoutRunner;
    }

    static class TimeoutRunner
    implements Runnable {
        private Object timerTask;
        private HsqlArrayList timeoutList;
        int abortCount;

        TimeoutRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TimeoutRunner timeoutRunner = this;
                synchronized (timeoutRunner) {
                    long systemMillis = System.currentTimeMillis();
                    for (int i = 0; i < this.timeoutList.size(); ++i) {
                        Session.TimeoutManager timeOut = (Session.TimeoutManager)this.timeoutList.get(i);
                        if (timeOut.isClosed()) {
                            this.timeoutList.remove(i);
                            --i;
                            continue;
                        }
                        boolean result = timeOut.checkTimeout(systemMillis);
                        if (!result) continue;
                        ++this.abortCount;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            TimeoutRunner timeoutRunner = this;
            synchronized (timeoutRunner) {
                if (this.timerTask == null) {
                    return;
                }
                HsqlTimer.cancel(this.timerTask);
                this.timerTask = null;
                this.timeoutList = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSession(Session.TimeoutManager timeout) {
            TimeoutRunner timeoutRunner = this;
            synchronized (timeoutRunner) {
                if (this.timerTask == null) {
                    this.start();
                }
                this.timeoutList.add(timeout);
            }
        }

        private void start() {
            this.timeoutList = new HsqlArrayList();
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(1000L, 1000L, this, true);
        }
    }

    class CheckpointRunner
    implements Runnable {
        private volatile boolean waiting;
        private Object timerTask;

        CheckpointRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Statement checkpoint = ParserCommand.getAutoCheckpointStatement(Database.this);
            Session sysSession = Database.this.sessionManager.newSysSession();
            try {
                sysSession.executeCompiledStatement(checkpoint, ValuePool.emptyObjectArray, 0);
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    sysSession.commit(false);
                    sysSession.close();
                }
                catch (Throwable throwable) {}
                this.waiting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            CheckpointRunner checkpointRunner = this;
            synchronized (checkpointRunner) {
                if (this.waiting) {
                    return;
                }
                this.waiting = true;
            }
            this.timerTask = DatabaseManager.getTimer().scheduleAfter(0L, this);
        }

        public void stop() {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
            this.waiting = false;
        }
    }
}

