/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Notified;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseManager {
    private static AtomicInteger dbIDCounter = new AtomicInteger();
    static final HashMap memDatabaseMap = new HashMap();
    static final HashMap fileDatabaseMap = new HashMap();
    static final HashMap resDatabaseMap = new HashMap();
    static final IntKeyHashMap databaseIDMap = new IntKeyHashMap();
    static final HashMap serverMap = new HashMap();
    private static final HsqlTimer timer = new HsqlTimer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDatabaseURIs() {
        Vector<String> v = new Vector<String>();
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator it = databaseIDMap.values().iterator();
            while (it.hasNext()) {
                Database db = (Database)it.next();
                v.addElement(db.getURI());
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabases(int mode) {
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator it = databaseIDMap.values().iterator();
            while (it.hasNext()) {
                Database db = (Database)it.next();
                try {
                    db.close(mode);
                }
                catch (HsqlException hsqlException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session newSession(int dbID, String user, String password, String zoneString) {
        Database db = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            db = (Database)databaseIDMap.get(dbID);
        }
        if (db == null) {
            return null;
        }
        Session session = db.connect(user, password, TimeZone.getTimeZone(zoneString));
        session.isNetwork = true;
        return session;
    }

    public static Session newSession(String type, String path, String user, String password, HsqlProperties props, TimeZone zone) {
        Database db = DatabaseManager.getDatabase(type, path, props);
        return db.connect(user, password, zone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(int dbId, long sessionId) {
        Database db = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            db = (Database)databaseIDMap.get(dbId);
        }
        return db == null ? null : db.sessionManager.getSession(sessionId);
    }

    public static int getDatabase(String type, String path, Notified server, HsqlProperties props) {
        Database db = DatabaseManager.getDatabase(type, path, props);
        DatabaseManager.registerServer(server, db);
        return db.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(int id) {
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            return (Database)databaseIDMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabases(Notified server, int shutdownMode) {
        Database[] dbArray;
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            HashSet databases = (HashSet)serverMap.get(server);
            if (databases == null) {
                dbArray = new Database[]{};
            } else {
                dbArray = new Database[databases.size()];
                databases.toArray(dbArray);
            }
        }
        for (int i = 0; i < dbArray.length; ++i) {
            dbArray[i].close(shutdownMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String dbtype, String path, HsqlProperties props) {
        Database db;
        DatabaseType type = DatabaseType.get(dbtype);
        Database database = db = DatabaseManager.getDatabaseObject(type, path, props);
        synchronized (database) {
            switch (db.getState()) {
                case 1: {
                    break;
                }
                case 4: {
                    if (DatabaseManager.lookupDatabaseObject(type, path) == null) {
                        DatabaseManager.addDatabaseObject(type, path, db);
                    }
                    db.open();
                    break;
                }
                case 2: 
                case 3: {
                    throw Error.error(451, 23);
                }
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Database getDatabaseObject(DatabaseType type, String path, HsqlProperties props) {
        Database db;
        BaseHashMap baseHashMap;
        HashMap databaseMap;
        String key = path;
        switch (type) {
            case DB_FILE: {
                databaseMap = fileDatabaseMap;
                key = DatabaseManager.filePathToKey(path);
                baseHashMap = databaseMap;
                synchronized (baseHashMap) {
                    db = (Database)databaseMap.get(key);
                    if (db == null && databaseMap.size() > 0) {
                        Iterator it = databaseMap.keySet().iterator();
                        while (it.hasNext()) {
                            String current = (String)it.next();
                            if (!key.equalsIgnoreCase(current)) continue;
                            key = current;
                            break;
                        }
                    }
                    break;
                }
            }
            case DB_RES: {
                databaseMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                databaseMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        baseHashMap = databaseMap;
        synchronized (baseHashMap) {
            db = (Database)databaseMap.get(key);
        }
        if (db == null) {
            db = new Database(type, path, key, props);
            db.databaseID = dbIDCounter.getAndIncrement();
            baseHashMap = databaseIDMap;
            synchronized (baseHashMap) {
                databaseIDMap.put(db.databaseID, db);
            }
            baseHashMap = databaseMap;
            synchronized (baseHashMap) {
                databaseMap.put(key, db);
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Database lookupDatabaseObject(DatabaseType type, String path) {
        HashMap databaseMap;
        String key = path;
        switch (type) {
            case DB_FILE: {
                databaseMap = fileDatabaseMap;
                key = DatabaseManager.filePathToKey(path);
                break;
            }
            case DB_RES: {
                databaseMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                databaseMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        HashMap hashMap = databaseMap;
        synchronized (hashMap) {
            return (Database)databaseMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addDatabaseObject(DatabaseType type, String path, Database db) {
        HashMap databaseMap;
        String key = path;
        switch (type) {
            case DB_FILE: {
                databaseMap = fileDatabaseMap;
                key = DatabaseManager.filePathToKey(path);
                break;
            }
            case DB_RES: {
                databaseMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                databaseMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        BaseHashMap baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.put(db.databaseID, db);
        }
        baseHashMap = databaseMap;
        synchronized (baseHashMap) {
            databaseMap.put(key, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDatabase(Database database) {
        HashMap databaseMap;
        String path;
        int dbID = database.databaseID;
        DatabaseType type = database.getType();
        String key = path = database.getPath();
        DatabaseManager.notifyServers(database);
        if (type == DatabaseType.DB_FILE) {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == DatabaseType.DB_RES) {
            databaseMap = resDatabaseMap;
        } else if (type == DatabaseType.DB_MEM) {
            databaseMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        boolean isEmpty = false;
        BaseHashMap baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.remove(dbID);
            isEmpty = databaseIDMap.isEmpty();
        }
        baseHashMap = databaseMap;
        synchronized (baseHashMap) {
            databaseMap.remove(key);
        }
        if (isEmpty) {
            ValuePool.resetPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegisterServer(Notified server) {
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            serverMap.remove(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerServer(Notified server, Database db) {
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            if (!serverMap.containsKey(server)) {
                serverMap.put(server, new HashSet());
            }
            HashSet databases = (HashSet)serverMap.get(server);
            databases.add(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServers(Database db) {
        Notified[] servers;
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            servers = new Notified[serverMap.size()];
            serverMap.keysToArray(servers);
        }
        for (int i = 0; i < servers.length; ++i) {
            HashSet databases;
            Notified server = servers[i];
            boolean removed = false;
            BaseHashMap baseHashMap = serverMap;
            synchronized (baseHashMap) {
                databases = (HashSet)serverMap.get(server);
            }
            if (databases != null) {
                baseHashMap = databases;
                synchronized (baseHashMap) {
                    removed = databases.remove(db);
                }
            }
            if (!removed) continue;
            server.notify(db.databaseID);
        }
    }

    static boolean isServerDB(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Notified server = (Notified)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String path) {
        try {
            return FileUtil.getFileUtil().canonicalPath(path);
        }
        catch (Exception e) {
            return path;
        }
    }
}

