/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.error.Error;

public enum DatabaseType {
    DB_MEM("mem:"),
    DB_FILE("file:"),
    DB_RES("res:");

    private final String value;

    private DatabaseType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public boolean isFileBased() {
        switch (this) {
            case DB_FILE: 
            case DB_RES: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInProcessDatabaseType(String type) {
        return DatabaseType.DB_FILE.value.equals(type) || DatabaseType.DB_RES.value.equals(type) || DatabaseType.DB_MEM.value.equals(type);
    }

    public static DatabaseType get(String value) {
        if (DatabaseType.DB_MEM.value.equals(value)) {
            return DB_MEM;
        }
        if (DatabaseType.DB_FILE.value.equals(value)) {
            return DB_FILE;
        }
        if (DatabaseType.DB_RES.value.equals(value)) {
            return DB_RES;
        }
        throw Error.runtimeError(201, "DatabaseType");
    }
}

