/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueAggregate;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.List;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionAggregate
extends Expression {
    ExpressionAggregate(int type, boolean distinct, Expression e) {
        super(type);
        this.nodes = new Expression[2];
        this.isDistinctAggregate = distinct;
        this.nodes[0] = e;
        this.nodes[1] = Expression.EXPR_TRUE;
    }

    @Override
    public boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder(64);
        String left = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 74: {
                sb.append(' ').append("COUNT").append('(');
                sb.append(left).append(')');
                break;
            }
            case 75: {
                sb.append(' ').append("SUM").append('(');
                sb.append(left).append(')');
                break;
            }
            case 76: {
                sb.append(' ').append("MIN").append('(');
                sb.append(left).append(')');
                break;
            }
            case 77: {
                sb.append(' ').append("MAX").append('(');
                sb.append(left).append(')');
                break;
            }
            case 78: {
                sb.append(' ').append("AVG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 79: {
                sb.append(' ').append("EVERY").append('(');
                sb.append(left).append(')');
                break;
            }
            case 80: {
                sb.append(' ').append("SOME").append('(');
                sb.append(left).append(')');
                break;
            }
            case 81: {
                sb.append(' ').append("STDDEV_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 82: {
                sb.append(' ').append("STDDEV_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 83: {
                sb.append(' ').append("VAR_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 84: {
                sb.append(' ').append("VAR_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 74: {
                sb.append("COUNT").append(' ');
                break;
            }
            case 75: {
                sb.append("SUM").append(' ');
                break;
            }
            case 76: {
                sb.append("MIN").append(' ');
                break;
            }
            case 77: {
                sb.append("MAX").append(' ');
                break;
            }
            case 78: {
                sb.append("AVG").append(' ');
                break;
            }
            case 79: {
                sb.append("EVERY").append(' ');
                break;
            }
            case 80: {
                sb.append("SOME").append(' ');
                break;
            }
            case 81: {
                sb.append("STDDEV_POP").append(' ');
                break;
            }
            case 82: {
                sb.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 83: {
                sb.append("VAR_POP").append(' ');
                break;
            }
            case 84: {
                sb.append("VAR_SAMP").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, List unresolvedSet, boolean acceptsSequences) {
        List conditionSet = this.nodes[1].resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity<ExpressionAggregate>();
        }
        unresolvedSet.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroups;
            this.rangeGroup = rangeGroup;
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].getDegree() > 1) {
            this.nodes[0].dataType = new RowType(this.nodes[0].nodeDataTypes);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate && this.nodes[0].dataType.isLobType()) {
            throw Error.error(5534);
        }
        this.dataType = ExpressionAggregate.getType(session, this.opType, this.nodes[0].dataType);
    }

    static Type getType(Session session, int setType, Type dataType) {
        if (setType == 74) {
            return Type.SQL_BIGINT;
        }
        int typeCode = dataType.typeCode;
        if (dataType.isIntervalYearMonthType()) {
            typeCode = 102;
        } else if (dataType.isIntervalDaySecondType()) {
            typeCode = 106;
        }
        switch (setType) {
            case 78: 
            case 89: {
                switch (typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 25: {
                        int scale = session.database.sqlAvgScale;
                        if (scale <= dataType.scale) {
                            return dataType;
                        }
                        int digits = ((NumberType)dataType).getDecimalPrecision();
                        return NumberType.getNumberType(3, digits + scale, scale);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 102: 
                    case 106: {
                        return dataType;
                    }
                }
                throw Error.error(5563);
            }
            case 75: {
                switch (typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return Type.SQL_BIGINT;
                    }
                    case 25: {
                        return Type.SQL_DECIMAL_BIGINT_SQR;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Type.SQL_DOUBLE;
                    }
                    case 2: 
                    case 3: {
                        return Type.getType(dataType.typeCode, null, null, dataType.precision * 2L, dataType.scale);
                    }
                    case 102: 
                    case 106: {
                        return IntervalType.newIntervalType(dataType.typeCode, 9L, dataType.scale);
                    }
                }
                throw Error.error(5563);
            }
            case 76: 
            case 77: {
                if (dataType.isArrayType() || dataType.isLobType()) {
                    throw Error.error(5563);
                }
                return dataType;
            }
            case 79: 
            case 80: {
                if (!dataType.isBooleanType()) break;
                return Type.SQL_BOOLEAN;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                if (!dataType.isNumberType()) break;
                return Type.SQL_DOUBLE;
            }
            case 100: {
                return dataType;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        throw Error.error(5563);
    }

    @Override
    boolean equals(Expression other) {
        if (other instanceof ExpressionAggregate) {
            ExpressionAggregate o = (ExpressionAggregate)other;
            boolean result = super.equals(other) && this.isDistinctAggregate == o.isDistinctAggregate;
            return result;
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction currValue) {
        if (!this.nodes[1].testCondition(session)) {
            return currValue;
        }
        if (currValue == null) {
            currValue = this.getSetFunction(session);
        }
        Integer newValue = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        currValue.add(newValue);
        return currValue;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction currValue, SetFunction value) {
        if (currValue == null) {
            currValue = this.getSetFunction(session);
        }
        currValue.addGroup(value);
        return currValue;
    }

    SetFunction getSetFunction(Session session) {
        return new SetFunctionValueAggregate(session, this.opType, this.nodes[0].dataType, this.dataType, this.isDistinctAggregate);
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction currValue) {
        if (currValue == null) {
            return this.opType == 74 ? Long.valueOf(0L) : null;
        }
        return currValue.getValue();
    }

    @Override
    public Expression getCondition() {
        return this.nodes[1];
    }

    @Override
    public boolean hasCondition() {
        return !this.nodes[1].isTrue();
    }

    @Override
    public void setCondition(Expression e) {
        this.nodes[1] = e;
    }
}

