/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueAggregate;
import org.hsqldb.SetFunctionValueArray;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionArrayAggregate
extends Expression {
    SortAndSlice sort;
    SortAndSlice distinctSort;
    String separator = ",";
    ArrayType arrayDataType;
    Type exprDataType;
    int exprOpType;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionArrayAggregate(int type, boolean distinct, Expression e, SortAndSlice sort, String separator) {
        super(type);
        this.isDistinctAggregate = distinct;
        this.sort = sort;
        this.exprOpType = e.opType;
        if (separator != null) {
            this.separator = separator;
        }
        if (sort == null) {
            this.nodes = new Expression[]{e};
        } else {
            HsqlArrayList list = sort.getExpressionList();
            this.nodes = new Expression[list.size() + 1];
            list.toArray(this.nodes);
            this.nodes[list.size()] = e;
            sort.prepareExtraColumn(1);
        }
        if (this.isDistinctAggregate) {
            this.distinctSort = new SortAndSlice();
            this.distinctSort.prepareSingleColumn(this.nodes.length - 1);
        }
    }

    @Override
    public boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder(64);
        String left = ExpressionArrayAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 85: {
                sb.append(' ').append("ARRAY_AGG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 86: {
                sb.append(' ').append("GROUP_CONCAT").append('(');
                sb.append(left).append(')');
                break;
            }
            case 89: {
                sb.append(' ').append("MEDIAN").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 85: {
                sb.append("ARRAY_AGG").append(' ');
                break;
            }
            case 86: {
                sb.append("GROUP_CONCAT").append(' ');
                break;
            }
            case 89: {
                sb.append("MEDIAN").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int rangeCount, RangeGroup[] rangeGroups, List unresolvedSet, boolean acceptsSequences) {
        List conditionSet = this.condition.resolveColumnReferences(session, rangeGroup, rangeCount, rangeGroups, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity<ExpressionArrayAggregate>();
        }
        unresolvedSet.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroups;
            this.rangeGroup = rangeGroup;
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.nodeDataTypes = new Type[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
            if (this.nodes[i].isUnresolvedParam()) {
                throw Error.error(5567);
            }
            if (this.nodes[i].dataType == null) {
                throw Error.error(5567);
            }
            this.nodeDataTypes[i] = this.nodes[i].dataType;
        }
        this.exprDataType = this.nodes[this.nodes.length - 1].dataType;
        if (this.exprDataType.isLobType()) {
            throw Error.error(5534);
        }
        if (this.exprDataType.isArrayType()) {
            throw Error.error(5534);
        }
        RowType rowDataType = new RowType(this.nodeDataTypes);
        switch (this.opType) {
            case 85: {
                this.arrayDataType = new ArrayType(rowDataType, Integer.MAX_VALUE);
                this.dataType = new ArrayType(this.exprDataType, 0x100000);
                break;
            }
            case 86: {
                this.arrayDataType = new ArrayType(rowDataType, Integer.MAX_VALUE);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 89: {
                this.arrayDataType = new ArrayType(this.nodeDataTypes[0], Integer.MAX_VALUE);
                this.dataType = ExpressionAggregate.getType(session, 89, this.exprDataType);
            }
        }
        this.condition.resolveTypes(session, null);
    }

    @Override
    boolean equals(Expression other) {
        if (other instanceof ExpressionArrayAggregate) {
            ExpressionArrayAggregate o = (ExpressionArrayAggregate)other;
            return super.equals(other) && this.opType == other.opType && this.exprSubType == other.exprSubType && this.isDistinctAggregate == o.isDistinctAggregate && this.separator.equals(o.separator) && this.condition.equals(o.condition);
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        Object[] value = null;
        switch (this.opType) {
            case 85: {
                Object[] data = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    data[i] = this.nodes[i].getValue(session);
                }
                value = data;
                break;
            }
            case 86: {
                Object[] data = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    data[i] = this.nodes[i].getValue(session);
                }
                if (data[data.length - 1] == null) {
                    return currValue;
                }
                value = data;
                break;
            }
            case 89: {
                value = this.nodes[0].getValue(session);
                if (value != null) break;
                return currValue;
            }
        }
        if (currValue == null) {
            currValue = new SetFunctionValueArray();
        }
        currValue.add(value);
        return currValue;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction currValue, SetFunction value) {
        if (currValue == null) {
            currValue = new SetFunctionValueArray();
        }
        currValue.addGroup(value);
        return currValue;
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction currValue) {
        if (currValue == null) {
            return null;
        }
        Object[] array = (Object[])currValue.getValue();
        if (this.isDistinctAggregate) {
            this.arrayDataType.sort(session, array, this.distinctSort);
            int size = this.arrayDataType.deDuplicate(session, array, this.distinctSort);
            array = (Object[])ArrayUtil.resizeArrayIfDifferent(array, size);
        }
        if (this.sort != null) {
            this.arrayDataType.sort(session, array, this.sort);
        }
        switch (this.opType) {
            case 85: {
                Object[] resultArray = new Object[array.length];
                for (int i = 0; i < array.length; ++i) {
                    Object[] row = (Object[])array[i];
                    resultArray[i] = row[row.length - 1];
                }
                return resultArray;
            }
            case 86: {
                StringBuilder sb = new StringBuilder(16 * array.length);
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        sb.append(this.separator);
                    }
                    Object[] row = (Object[])array[i];
                    Object value = row[row.length - 1];
                    String string = (String)Type.SQL_VARCHAR.convertToType(session, value, this.exprDataType);
                    sb.append(string);
                }
                return sb.toString();
            }
            case 89: {
                Object value;
                boolean even;
                SortAndSlice exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                this.arrayDataType.sort(session, array, exprSort);
                boolean bl = even = array.length % 2 == 0;
                if (even) {
                    SetFunctionValueAggregate sf = new SetFunctionValueAggregate(session, 78, this.nodes[0].dataType, this.dataType, false);
                    sf.add(array[array.length / 2 - 1]);
                    sf.add(array[array.length / 2]);
                    value = sf.getValue();
                } else {
                    value = array[array.length / 2];
                }
                if (this.dataType.isDateTimeTypeWithZone()) {
                    value = ((DateTimeType)this.dataType).changeZoneToUTC(value);
                }
                return this.dataType.convertToType(session, value, this.exprDataType);
            }
        }
        return null;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return !this.condition.isTrue();
    }

    @Override
    public void setCondition(Expression e) {
        this.condition = e;
    }

    @Override
    public Expression duplicate() {
        ExpressionArrayAggregate e = (ExpressionArrayAggregate)super.duplicate();
        e.condition = this.condition.duplicate();
        return e;
    }
}

